/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Card data parameters that are required to generate Card Verification Values (CVV/CVV2), Dynamic Card Verification
 * Values (dCVV/dCVV2), or Card Security Codes (CSC).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CardGenerationAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<CardGenerationAttributes.Builder, CardGenerationAttributes> {
    private static final SdkField<AmexCardSecurityCodeVersion1> AMEX_CARD_SECURITY_CODE_VERSION1_FIELD = SdkField
            .<AmexCardSecurityCodeVersion1> builder(MarshallingType.SDK_POJO)
            .memberName("AmexCardSecurityCodeVersion1")
            .getter(getter(CardGenerationAttributes::amexCardSecurityCodeVersion1))
            .setter(setter(Builder::amexCardSecurityCodeVersion1))
            .constructor(AmexCardSecurityCodeVersion1::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmexCardSecurityCodeVersion1")
                    .build()).build();

    private static final SdkField<AmexCardSecurityCodeVersion2> AMEX_CARD_SECURITY_CODE_VERSION2_FIELD = SdkField
            .<AmexCardSecurityCodeVersion2> builder(MarshallingType.SDK_POJO)
            .memberName("AmexCardSecurityCodeVersion2")
            .getter(getter(CardGenerationAttributes::amexCardSecurityCodeVersion2))
            .setter(setter(Builder::amexCardSecurityCodeVersion2))
            .constructor(AmexCardSecurityCodeVersion2::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmexCardSecurityCodeVersion2")
                    .build()).build();

    private static final SdkField<CardHolderVerificationValue> CARD_HOLDER_VERIFICATION_VALUE_FIELD = SdkField
            .<CardHolderVerificationValue> builder(MarshallingType.SDK_POJO)
            .memberName("CardHolderVerificationValue")
            .getter(getter(CardGenerationAttributes::cardHolderVerificationValue))
            .setter(setter(Builder::cardHolderVerificationValue))
            .constructor(CardHolderVerificationValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CardHolderVerificationValue")
                    .build()).build();

    private static final SdkField<CardVerificationValue1> CARD_VERIFICATION_VALUE1_FIELD = SdkField
            .<CardVerificationValue1> builder(MarshallingType.SDK_POJO).memberName("CardVerificationValue1")
            .getter(getter(CardGenerationAttributes::cardVerificationValue1)).setter(setter(Builder::cardVerificationValue1))
            .constructor(CardVerificationValue1::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CardVerificationValue1").build())
            .build();

    private static final SdkField<CardVerificationValue2> CARD_VERIFICATION_VALUE2_FIELD = SdkField
            .<CardVerificationValue2> builder(MarshallingType.SDK_POJO).memberName("CardVerificationValue2")
            .getter(getter(CardGenerationAttributes::cardVerificationValue2)).setter(setter(Builder::cardVerificationValue2))
            .constructor(CardVerificationValue2::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CardVerificationValue2").build())
            .build();

    private static final SdkField<DynamicCardVerificationCode> DYNAMIC_CARD_VERIFICATION_CODE_FIELD = SdkField
            .<DynamicCardVerificationCode> builder(MarshallingType.SDK_POJO)
            .memberName("DynamicCardVerificationCode")
            .getter(getter(CardGenerationAttributes::dynamicCardVerificationCode))
            .setter(setter(Builder::dynamicCardVerificationCode))
            .constructor(DynamicCardVerificationCode::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DynamicCardVerificationCode")
                    .build()).build();

    private static final SdkField<DynamicCardVerificationValue> DYNAMIC_CARD_VERIFICATION_VALUE_FIELD = SdkField
            .<DynamicCardVerificationValue> builder(MarshallingType.SDK_POJO)
            .memberName("DynamicCardVerificationValue")
            .getter(getter(CardGenerationAttributes::dynamicCardVerificationValue))
            .setter(setter(Builder::dynamicCardVerificationValue))
            .constructor(DynamicCardVerificationValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DynamicCardVerificationValue")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            AMEX_CARD_SECURITY_CODE_VERSION1_FIELD, AMEX_CARD_SECURITY_CODE_VERSION2_FIELD, CARD_HOLDER_VERIFICATION_VALUE_FIELD,
            CARD_VERIFICATION_VALUE1_FIELD, CARD_VERIFICATION_VALUE2_FIELD, DYNAMIC_CARD_VERIFICATION_CODE_FIELD,
            DYNAMIC_CARD_VERIFICATION_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final AmexCardSecurityCodeVersion1 amexCardSecurityCodeVersion1;

    private final AmexCardSecurityCodeVersion2 amexCardSecurityCodeVersion2;

    private final CardHolderVerificationValue cardHolderVerificationValue;

    private final CardVerificationValue1 cardVerificationValue1;

    private final CardVerificationValue2 cardVerificationValue2;

    private final DynamicCardVerificationCode dynamicCardVerificationCode;

    private final DynamicCardVerificationValue dynamicCardVerificationValue;

    private final Type type;

    private CardGenerationAttributes(BuilderImpl builder) {
        this.amexCardSecurityCodeVersion1 = builder.amexCardSecurityCodeVersion1;
        this.amexCardSecurityCodeVersion2 = builder.amexCardSecurityCodeVersion2;
        this.cardHolderVerificationValue = builder.cardHolderVerificationValue;
        this.cardVerificationValue1 = builder.cardVerificationValue1;
        this.cardVerificationValue2 = builder.cardVerificationValue2;
        this.dynamicCardVerificationCode = builder.dynamicCardVerificationCode;
        this.dynamicCardVerificationValue = builder.dynamicCardVerificationValue;
        this.type = builder.type;
    }

    /**
     * Returns the value of the AmexCardSecurityCodeVersion1 property for this object.
     * 
     * @return The value of the AmexCardSecurityCodeVersion1 property for this object.
     */
    public final AmexCardSecurityCodeVersion1 amexCardSecurityCodeVersion1() {
        return amexCardSecurityCodeVersion1;
    }

    /**
     * <p>
     * Card data parameters that are required to generate a Card Security Code (CSC2) for an AMEX payment card.
     * </p>
     * 
     * @return Card data parameters that are required to generate a Card Security Code (CSC2) for an AMEX payment card.
     */
    public final AmexCardSecurityCodeVersion2 amexCardSecurityCodeVersion2() {
        return amexCardSecurityCodeVersion2;
    }

    /**
     * <p>
     * Card data parameters that are required to generate a cardholder verification value for the payment card.
     * </p>
     * 
     * @return Card data parameters that are required to generate a cardholder verification value for the payment card.
     */
    public final CardHolderVerificationValue cardHolderVerificationValue() {
        return cardHolderVerificationValue;
    }

    /**
     * <p>
     * Card data parameters that are required to generate Card Verification Value (CVV) for the payment card.
     * </p>
     * 
     * @return Card data parameters that are required to generate Card Verification Value (CVV) for the payment card.
     */
    public final CardVerificationValue1 cardVerificationValue1() {
        return cardVerificationValue1;
    }

    /**
     * <p>
     * Card data parameters that are required to generate Card Verification Value (CVV2) for the payment card.
     * </p>
     * 
     * @return Card data parameters that are required to generate Card Verification Value (CVV2) for the payment card.
     */
    public final CardVerificationValue2 cardVerificationValue2() {
        return cardVerificationValue2;
    }

    /**
     * <p>
     * Card data parameters that are required to generate CDynamic Card Verification Code (dCVC) for the payment card.
     * </p>
     * 
     * @return Card data parameters that are required to generate CDynamic Card Verification Code (dCVC) for the payment
     *         card.
     */
    public final DynamicCardVerificationCode dynamicCardVerificationCode() {
        return dynamicCardVerificationCode;
    }

    /**
     * <p>
     * Card data parameters that are required to generate CDynamic Card Verification Value (dCVV) for the payment card.
     * </p>
     * 
     * @return Card data parameters that are required to generate CDynamic Card Verification Value (dCVV) for the
     *         payment card.
     */
    public final DynamicCardVerificationValue dynamicCardVerificationValue() {
        return dynamicCardVerificationValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(amexCardSecurityCodeVersion1());
        hashCode = 31 * hashCode + Objects.hashCode(amexCardSecurityCodeVersion2());
        hashCode = 31 * hashCode + Objects.hashCode(cardHolderVerificationValue());
        hashCode = 31 * hashCode + Objects.hashCode(cardVerificationValue1());
        hashCode = 31 * hashCode + Objects.hashCode(cardVerificationValue2());
        hashCode = 31 * hashCode + Objects.hashCode(dynamicCardVerificationCode());
        hashCode = 31 * hashCode + Objects.hashCode(dynamicCardVerificationValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CardGenerationAttributes)) {
            return false;
        }
        CardGenerationAttributes other = (CardGenerationAttributes) obj;
        return Objects.equals(amexCardSecurityCodeVersion1(), other.amexCardSecurityCodeVersion1())
                && Objects.equals(amexCardSecurityCodeVersion2(), other.amexCardSecurityCodeVersion2())
                && Objects.equals(cardHolderVerificationValue(), other.cardHolderVerificationValue())
                && Objects.equals(cardVerificationValue1(), other.cardVerificationValue1())
                && Objects.equals(cardVerificationValue2(), other.cardVerificationValue2())
                && Objects.equals(dynamicCardVerificationCode(), other.dynamicCardVerificationCode())
                && Objects.equals(dynamicCardVerificationValue(), other.dynamicCardVerificationValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CardGenerationAttributes").add("AmexCardSecurityCodeVersion1", amexCardSecurityCodeVersion1())
                .add("AmexCardSecurityCodeVersion2", amexCardSecurityCodeVersion2())
                .add("CardHolderVerificationValue", cardHolderVerificationValue())
                .add("CardVerificationValue1", cardVerificationValue1()).add("CardVerificationValue2", cardVerificationValue2())
                .add("DynamicCardVerificationCode", dynamicCardVerificationCode())
                .add("DynamicCardVerificationValue", dynamicCardVerificationValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AmexCardSecurityCodeVersion1":
            return Optional.ofNullable(clazz.cast(amexCardSecurityCodeVersion1()));
        case "AmexCardSecurityCodeVersion2":
            return Optional.ofNullable(clazz.cast(amexCardSecurityCodeVersion2()));
        case "CardHolderVerificationValue":
            return Optional.ofNullable(clazz.cast(cardHolderVerificationValue()));
        case "CardVerificationValue1":
            return Optional.ofNullable(clazz.cast(cardVerificationValue1()));
        case "CardVerificationValue2":
            return Optional.ofNullable(clazz.cast(cardVerificationValue2()));
        case "DynamicCardVerificationCode":
            return Optional.ofNullable(clazz.cast(dynamicCardVerificationCode()));
        case "DynamicCardVerificationValue":
            return Optional.ofNullable(clazz.cast(dynamicCardVerificationValue()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #amexCardSecurityCodeVersion1()} initialized to the given value.
     *
     * Sets the value of the AmexCardSecurityCodeVersion1 property for this object.
     *
     * @param amexCardSecurityCodeVersion1
     *        The new value for the AmexCardSecurityCodeVersion1 property for this object.
     */
    public static CardGenerationAttributes fromAmexCardSecurityCodeVersion1(
            AmexCardSecurityCodeVersion1 amexCardSecurityCodeVersion1) {
        return builder().amexCardSecurityCodeVersion1(amexCardSecurityCodeVersion1).build();
    }

    /**
     * Create an instance of this class with {@link #amexCardSecurityCodeVersion1()} initialized to the given value.
     *
     * Sets the value of the AmexCardSecurityCodeVersion1 property for this object.
     *
     * @param amexCardSecurityCodeVersion1
     *        The new value for the AmexCardSecurityCodeVersion1 property for this object.
     */
    public static CardGenerationAttributes fromAmexCardSecurityCodeVersion1(
            Consumer<AmexCardSecurityCodeVersion1.Builder> amexCardSecurityCodeVersion1) {
        AmexCardSecurityCodeVersion1.Builder builder = AmexCardSecurityCodeVersion1.builder();
        amexCardSecurityCodeVersion1.accept(builder);
        return fromAmexCardSecurityCodeVersion1(builder.build());
    }

    /**
     * Create an instance of this class with {@link #amexCardSecurityCodeVersion2()} initialized to the given value.
     *
     * <p>
     * Card data parameters that are required to generate a Card Security Code (CSC2) for an AMEX payment card.
     * </p>
     * 
     * @param amexCardSecurityCodeVersion2
     *        Card data parameters that are required to generate a Card Security Code (CSC2) for an AMEX payment card.
     */
    public static CardGenerationAttributes fromAmexCardSecurityCodeVersion2(
            AmexCardSecurityCodeVersion2 amexCardSecurityCodeVersion2) {
        return builder().amexCardSecurityCodeVersion2(amexCardSecurityCodeVersion2).build();
    }

    /**
     * Create an instance of this class with {@link #amexCardSecurityCodeVersion2()} initialized to the given value.
     *
     * <p>
     * Card data parameters that are required to generate a Card Security Code (CSC2) for an AMEX payment card.
     * </p>
     * 
     * @param amexCardSecurityCodeVersion2
     *        Card data parameters that are required to generate a Card Security Code (CSC2) for an AMEX payment card.
     */
    public static CardGenerationAttributes fromAmexCardSecurityCodeVersion2(
            Consumer<AmexCardSecurityCodeVersion2.Builder> amexCardSecurityCodeVersion2) {
        AmexCardSecurityCodeVersion2.Builder builder = AmexCardSecurityCodeVersion2.builder();
        amexCardSecurityCodeVersion2.accept(builder);
        return fromAmexCardSecurityCodeVersion2(builder.build());
    }

    /**
     * Create an instance of this class with {@link #cardHolderVerificationValue()} initialized to the given value.
     *
     * <p>
     * Card data parameters that are required to generate a cardholder verification value for the payment card.
     * </p>
     * 
     * @param cardHolderVerificationValue
     *        Card data parameters that are required to generate a cardholder verification value for the payment card.
     */
    public static CardGenerationAttributes fromCardHolderVerificationValue(CardHolderVerificationValue cardHolderVerificationValue) {
        return builder().cardHolderVerificationValue(cardHolderVerificationValue).build();
    }

    /**
     * Create an instance of this class with {@link #cardHolderVerificationValue()} initialized to the given value.
     *
     * <p>
     * Card data parameters that are required to generate a cardholder verification value for the payment card.
     * </p>
     * 
     * @param cardHolderVerificationValue
     *        Card data parameters that are required to generate a cardholder verification value for the payment card.
     */
    public static CardGenerationAttributes fromCardHolderVerificationValue(
            Consumer<CardHolderVerificationValue.Builder> cardHolderVerificationValue) {
        CardHolderVerificationValue.Builder builder = CardHolderVerificationValue.builder();
        cardHolderVerificationValue.accept(builder);
        return fromCardHolderVerificationValue(builder.build());
    }

    /**
     * Create an instance of this class with {@link #cardVerificationValue1()} initialized to the given value.
     *
     * <p>
     * Card data parameters that are required to generate Card Verification Value (CVV) for the payment card.
     * </p>
     * 
     * @param cardVerificationValue1
     *        Card data parameters that are required to generate Card Verification Value (CVV) for the payment card.
     */
    public static CardGenerationAttributes fromCardVerificationValue1(CardVerificationValue1 cardVerificationValue1) {
        return builder().cardVerificationValue1(cardVerificationValue1).build();
    }

    /**
     * Create an instance of this class with {@link #cardVerificationValue1()} initialized to the given value.
     *
     * <p>
     * Card data parameters that are required to generate Card Verification Value (CVV) for the payment card.
     * </p>
     * 
     * @param cardVerificationValue1
     *        Card data parameters that are required to generate Card Verification Value (CVV) for the payment card.
     */
    public static CardGenerationAttributes fromCardVerificationValue1(
            Consumer<CardVerificationValue1.Builder> cardVerificationValue1) {
        CardVerificationValue1.Builder builder = CardVerificationValue1.builder();
        cardVerificationValue1.accept(builder);
        return fromCardVerificationValue1(builder.build());
    }

    /**
     * Create an instance of this class with {@link #cardVerificationValue2()} initialized to the given value.
     *
     * <p>
     * Card data parameters that are required to generate Card Verification Value (CVV2) for the payment card.
     * </p>
     * 
     * @param cardVerificationValue2
     *        Card data parameters that are required to generate Card Verification Value (CVV2) for the payment card.
     */
    public static CardGenerationAttributes fromCardVerificationValue2(CardVerificationValue2 cardVerificationValue2) {
        return builder().cardVerificationValue2(cardVerificationValue2).build();
    }

    /**
     * Create an instance of this class with {@link #cardVerificationValue2()} initialized to the given value.
     *
     * <p>
     * Card data parameters that are required to generate Card Verification Value (CVV2) for the payment card.
     * </p>
     * 
     * @param cardVerificationValue2
     *        Card data parameters that are required to generate Card Verification Value (CVV2) for the payment card.
     */
    public static CardGenerationAttributes fromCardVerificationValue2(
            Consumer<CardVerificationValue2.Builder> cardVerificationValue2) {
        CardVerificationValue2.Builder builder = CardVerificationValue2.builder();
        cardVerificationValue2.accept(builder);
        return fromCardVerificationValue2(builder.build());
    }

    /**
     * Create an instance of this class with {@link #dynamicCardVerificationCode()} initialized to the given value.
     *
     * <p>
     * Card data parameters that are required to generate CDynamic Card Verification Code (dCVC) for the payment card.
     * </p>
     * 
     * @param dynamicCardVerificationCode
     *        Card data parameters that are required to generate CDynamic Card Verification Code (dCVC) for the payment
     *        card.
     */
    public static CardGenerationAttributes fromDynamicCardVerificationCode(DynamicCardVerificationCode dynamicCardVerificationCode) {
        return builder().dynamicCardVerificationCode(dynamicCardVerificationCode).build();
    }

    /**
     * Create an instance of this class with {@link #dynamicCardVerificationCode()} initialized to the given value.
     *
     * <p>
     * Card data parameters that are required to generate CDynamic Card Verification Code (dCVC) for the payment card.
     * </p>
     * 
     * @param dynamicCardVerificationCode
     *        Card data parameters that are required to generate CDynamic Card Verification Code (dCVC) for the payment
     *        card.
     */
    public static CardGenerationAttributes fromDynamicCardVerificationCode(
            Consumer<DynamicCardVerificationCode.Builder> dynamicCardVerificationCode) {
        DynamicCardVerificationCode.Builder builder = DynamicCardVerificationCode.builder();
        dynamicCardVerificationCode.accept(builder);
        return fromDynamicCardVerificationCode(builder.build());
    }

    /**
     * Create an instance of this class with {@link #dynamicCardVerificationValue()} initialized to the given value.
     *
     * <p>
     * Card data parameters that are required to generate CDynamic Card Verification Value (dCVV) for the payment card.
     * </p>
     * 
     * @param dynamicCardVerificationValue
     *        Card data parameters that are required to generate CDynamic Card Verification Value (dCVV) for the payment
     *        card.
     */
    public static CardGenerationAttributes fromDynamicCardVerificationValue(
            DynamicCardVerificationValue dynamicCardVerificationValue) {
        return builder().dynamicCardVerificationValue(dynamicCardVerificationValue).build();
    }

    /**
     * Create an instance of this class with {@link #dynamicCardVerificationValue()} initialized to the given value.
     *
     * <p>
     * Card data parameters that are required to generate CDynamic Card Verification Value (dCVV) for the payment card.
     * </p>
     * 
     * @param dynamicCardVerificationValue
     *        Card data parameters that are required to generate CDynamic Card Verification Value (dCVV) for the payment
     *        card.
     */
    public static CardGenerationAttributes fromDynamicCardVerificationValue(
            Consumer<DynamicCardVerificationValue.Builder> dynamicCardVerificationValue) {
        DynamicCardVerificationValue.Builder builder = DynamicCardVerificationValue.builder();
        dynamicCardVerificationValue.accept(builder);
        return fromDynamicCardVerificationValue(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CardGenerationAttributes, T> g) {
        return obj -> g.apply((CardGenerationAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CardGenerationAttributes> {
        /**
         * Sets the value of the AmexCardSecurityCodeVersion1 property for this object.
         *
         * @param amexCardSecurityCodeVersion1
         *        The new value for the AmexCardSecurityCodeVersion1 property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amexCardSecurityCodeVersion1(AmexCardSecurityCodeVersion1 amexCardSecurityCodeVersion1);

        /**
         * Sets the value of the AmexCardSecurityCodeVersion1 property for this object.
         *
         * This is a convenience method that creates an instance of the {@link AmexCardSecurityCodeVersion1.Builder}
         * avoiding the need to create one manually via {@link AmexCardSecurityCodeVersion1#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AmexCardSecurityCodeVersion1.Builder#build()} is called
         * immediately and its result is passed to {@link #amexCardSecurityCodeVersion1(AmexCardSecurityCodeVersion1)}.
         * 
         * @param amexCardSecurityCodeVersion1
         *        a consumer that will call methods on {@link AmexCardSecurityCodeVersion1.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #amexCardSecurityCodeVersion1(AmexCardSecurityCodeVersion1)
         */
        default Builder amexCardSecurityCodeVersion1(Consumer<AmexCardSecurityCodeVersion1.Builder> amexCardSecurityCodeVersion1) {
            return amexCardSecurityCodeVersion1(AmexCardSecurityCodeVersion1.builder()
                    .applyMutation(amexCardSecurityCodeVersion1).build());
        }

        /**
         * <p>
         * Card data parameters that are required to generate a Card Security Code (CSC2) for an AMEX payment card.
         * </p>
         * 
         * @param amexCardSecurityCodeVersion2
         *        Card data parameters that are required to generate a Card Security Code (CSC2) for an AMEX payment
         *        card.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amexCardSecurityCodeVersion2(AmexCardSecurityCodeVersion2 amexCardSecurityCodeVersion2);

        /**
         * <p>
         * Card data parameters that are required to generate a Card Security Code (CSC2) for an AMEX payment card.
         * </p>
         * This is a convenience method that creates an instance of the {@link AmexCardSecurityCodeVersion2.Builder}
         * avoiding the need to create one manually via {@link AmexCardSecurityCodeVersion2#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AmexCardSecurityCodeVersion2.Builder#build()} is called
         * immediately and its result is passed to {@link #amexCardSecurityCodeVersion2(AmexCardSecurityCodeVersion2)}.
         * 
         * @param amexCardSecurityCodeVersion2
         *        a consumer that will call methods on {@link AmexCardSecurityCodeVersion2.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #amexCardSecurityCodeVersion2(AmexCardSecurityCodeVersion2)
         */
        default Builder amexCardSecurityCodeVersion2(Consumer<AmexCardSecurityCodeVersion2.Builder> amexCardSecurityCodeVersion2) {
            return amexCardSecurityCodeVersion2(AmexCardSecurityCodeVersion2.builder()
                    .applyMutation(amexCardSecurityCodeVersion2).build());
        }

        /**
         * <p>
         * Card data parameters that are required to generate a cardholder verification value for the payment card.
         * </p>
         * 
         * @param cardHolderVerificationValue
         *        Card data parameters that are required to generate a cardholder verification value for the payment
         *        card.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cardHolderVerificationValue(CardHolderVerificationValue cardHolderVerificationValue);

        /**
         * <p>
         * Card data parameters that are required to generate a cardholder verification value for the payment card.
         * </p>
         * This is a convenience method that creates an instance of the {@link CardHolderVerificationValue.Builder}
         * avoiding the need to create one manually via {@link CardHolderVerificationValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CardHolderVerificationValue.Builder#build()} is called
         * immediately and its result is passed to {@link #cardHolderVerificationValue(CardHolderVerificationValue)}.
         * 
         * @param cardHolderVerificationValue
         *        a consumer that will call methods on {@link CardHolderVerificationValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cardHolderVerificationValue(CardHolderVerificationValue)
         */
        default Builder cardHolderVerificationValue(Consumer<CardHolderVerificationValue.Builder> cardHolderVerificationValue) {
            return cardHolderVerificationValue(CardHolderVerificationValue.builder().applyMutation(cardHolderVerificationValue)
                    .build());
        }

        /**
         * <p>
         * Card data parameters that are required to generate Card Verification Value (CVV) for the payment card.
         * </p>
         * 
         * @param cardVerificationValue1
         *        Card data parameters that are required to generate Card Verification Value (CVV) for the payment card.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cardVerificationValue1(CardVerificationValue1 cardVerificationValue1);

        /**
         * <p>
         * Card data parameters that are required to generate Card Verification Value (CVV) for the payment card.
         * </p>
         * This is a convenience method that creates an instance of the {@link CardVerificationValue1.Builder} avoiding
         * the need to create one manually via {@link CardVerificationValue1#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CardVerificationValue1.Builder#build()} is called immediately and
         * its result is passed to {@link #cardVerificationValue1(CardVerificationValue1)}.
         * 
         * @param cardVerificationValue1
         *        a consumer that will call methods on {@link CardVerificationValue1.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cardVerificationValue1(CardVerificationValue1)
         */
        default Builder cardVerificationValue1(Consumer<CardVerificationValue1.Builder> cardVerificationValue1) {
            return cardVerificationValue1(CardVerificationValue1.builder().applyMutation(cardVerificationValue1).build());
        }

        /**
         * <p>
         * Card data parameters that are required to generate Card Verification Value (CVV2) for the payment card.
         * </p>
         * 
         * @param cardVerificationValue2
         *        Card data parameters that are required to generate Card Verification Value (CVV2) for the payment
         *        card.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cardVerificationValue2(CardVerificationValue2 cardVerificationValue2);

        /**
         * <p>
         * Card data parameters that are required to generate Card Verification Value (CVV2) for the payment card.
         * </p>
         * This is a convenience method that creates an instance of the {@link CardVerificationValue2.Builder} avoiding
         * the need to create one manually via {@link CardVerificationValue2#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CardVerificationValue2.Builder#build()} is called immediately and
         * its result is passed to {@link #cardVerificationValue2(CardVerificationValue2)}.
         * 
         * @param cardVerificationValue2
         *        a consumer that will call methods on {@link CardVerificationValue2.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cardVerificationValue2(CardVerificationValue2)
         */
        default Builder cardVerificationValue2(Consumer<CardVerificationValue2.Builder> cardVerificationValue2) {
            return cardVerificationValue2(CardVerificationValue2.builder().applyMutation(cardVerificationValue2).build());
        }

        /**
         * <p>
         * Card data parameters that are required to generate CDynamic Card Verification Code (dCVC) for the payment
         * card.
         * </p>
         * 
         * @param dynamicCardVerificationCode
         *        Card data parameters that are required to generate CDynamic Card Verification Code (dCVC) for the
         *        payment card.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dynamicCardVerificationCode(DynamicCardVerificationCode dynamicCardVerificationCode);

        /**
         * <p>
         * Card data parameters that are required to generate CDynamic Card Verification Code (dCVC) for the payment
         * card.
         * </p>
         * This is a convenience method that creates an instance of the {@link DynamicCardVerificationCode.Builder}
         * avoiding the need to create one manually via {@link DynamicCardVerificationCode#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DynamicCardVerificationCode.Builder#build()} is called
         * immediately and its result is passed to {@link #dynamicCardVerificationCode(DynamicCardVerificationCode)}.
         * 
         * @param dynamicCardVerificationCode
         *        a consumer that will call methods on {@link DynamicCardVerificationCode.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dynamicCardVerificationCode(DynamicCardVerificationCode)
         */
        default Builder dynamicCardVerificationCode(Consumer<DynamicCardVerificationCode.Builder> dynamicCardVerificationCode) {
            return dynamicCardVerificationCode(DynamicCardVerificationCode.builder().applyMutation(dynamicCardVerificationCode)
                    .build());
        }

        /**
         * <p>
         * Card data parameters that are required to generate CDynamic Card Verification Value (dCVV) for the payment
         * card.
         * </p>
         * 
         * @param dynamicCardVerificationValue
         *        Card data parameters that are required to generate CDynamic Card Verification Value (dCVV) for the
         *        payment card.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dynamicCardVerificationValue(DynamicCardVerificationValue dynamicCardVerificationValue);

        /**
         * <p>
         * Card data parameters that are required to generate CDynamic Card Verification Value (dCVV) for the payment
         * card.
         * </p>
         * This is a convenience method that creates an instance of the {@link DynamicCardVerificationValue.Builder}
         * avoiding the need to create one manually via {@link DynamicCardVerificationValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DynamicCardVerificationValue.Builder#build()} is called
         * immediately and its result is passed to {@link #dynamicCardVerificationValue(DynamicCardVerificationValue)}.
         * 
         * @param dynamicCardVerificationValue
         *        a consumer that will call methods on {@link DynamicCardVerificationValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dynamicCardVerificationValue(DynamicCardVerificationValue)
         */
        default Builder dynamicCardVerificationValue(Consumer<DynamicCardVerificationValue.Builder> dynamicCardVerificationValue) {
            return dynamicCardVerificationValue(DynamicCardVerificationValue.builder()
                    .applyMutation(dynamicCardVerificationValue).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AmexCardSecurityCodeVersion1 amexCardSecurityCodeVersion1;

        private AmexCardSecurityCodeVersion2 amexCardSecurityCodeVersion2;

        private CardHolderVerificationValue cardHolderVerificationValue;

        private CardVerificationValue1 cardVerificationValue1;

        private CardVerificationValue2 cardVerificationValue2;

        private DynamicCardVerificationCode dynamicCardVerificationCode;

        private DynamicCardVerificationValue dynamicCardVerificationValue;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(CardGenerationAttributes model) {
            amexCardSecurityCodeVersion1(model.amexCardSecurityCodeVersion1);
            amexCardSecurityCodeVersion2(model.amexCardSecurityCodeVersion2);
            cardHolderVerificationValue(model.cardHolderVerificationValue);
            cardVerificationValue1(model.cardVerificationValue1);
            cardVerificationValue2(model.cardVerificationValue2);
            dynamicCardVerificationCode(model.dynamicCardVerificationCode);
            dynamicCardVerificationValue(model.dynamicCardVerificationValue);
        }

        public final AmexCardSecurityCodeVersion1.Builder getAmexCardSecurityCodeVersion1() {
            return amexCardSecurityCodeVersion1 != null ? amexCardSecurityCodeVersion1.toBuilder() : null;
        }

        public final void setAmexCardSecurityCodeVersion1(AmexCardSecurityCodeVersion1.BuilderImpl amexCardSecurityCodeVersion1) {
            Object oldValue = this.amexCardSecurityCodeVersion1;
            this.amexCardSecurityCodeVersion1 = amexCardSecurityCodeVersion1 != null ? amexCardSecurityCodeVersion1.build()
                    : null;
            handleUnionValueChange(Type.AMEX_CARD_SECURITY_CODE_VERSION1, oldValue, this.amexCardSecurityCodeVersion1);
        }

        @Override
        public final Builder amexCardSecurityCodeVersion1(AmexCardSecurityCodeVersion1 amexCardSecurityCodeVersion1) {
            Object oldValue = this.amexCardSecurityCodeVersion1;
            this.amexCardSecurityCodeVersion1 = amexCardSecurityCodeVersion1;
            handleUnionValueChange(Type.AMEX_CARD_SECURITY_CODE_VERSION1, oldValue, this.amexCardSecurityCodeVersion1);
            return this;
        }

        public final AmexCardSecurityCodeVersion2.Builder getAmexCardSecurityCodeVersion2() {
            return amexCardSecurityCodeVersion2 != null ? amexCardSecurityCodeVersion2.toBuilder() : null;
        }

        public final void setAmexCardSecurityCodeVersion2(AmexCardSecurityCodeVersion2.BuilderImpl amexCardSecurityCodeVersion2) {
            Object oldValue = this.amexCardSecurityCodeVersion2;
            this.amexCardSecurityCodeVersion2 = amexCardSecurityCodeVersion2 != null ? amexCardSecurityCodeVersion2.build()
                    : null;
            handleUnionValueChange(Type.AMEX_CARD_SECURITY_CODE_VERSION2, oldValue, this.amexCardSecurityCodeVersion2);
        }

        @Override
        public final Builder amexCardSecurityCodeVersion2(AmexCardSecurityCodeVersion2 amexCardSecurityCodeVersion2) {
            Object oldValue = this.amexCardSecurityCodeVersion2;
            this.amexCardSecurityCodeVersion2 = amexCardSecurityCodeVersion2;
            handleUnionValueChange(Type.AMEX_CARD_SECURITY_CODE_VERSION2, oldValue, this.amexCardSecurityCodeVersion2);
            return this;
        }

        public final CardHolderVerificationValue.Builder getCardHolderVerificationValue() {
            return cardHolderVerificationValue != null ? cardHolderVerificationValue.toBuilder() : null;
        }

        public final void setCardHolderVerificationValue(CardHolderVerificationValue.BuilderImpl cardHolderVerificationValue) {
            Object oldValue = this.cardHolderVerificationValue;
            this.cardHolderVerificationValue = cardHolderVerificationValue != null ? cardHolderVerificationValue.build() : null;
            handleUnionValueChange(Type.CARD_HOLDER_VERIFICATION_VALUE, oldValue, this.cardHolderVerificationValue);
        }

        @Override
        public final Builder cardHolderVerificationValue(CardHolderVerificationValue cardHolderVerificationValue) {
            Object oldValue = this.cardHolderVerificationValue;
            this.cardHolderVerificationValue = cardHolderVerificationValue;
            handleUnionValueChange(Type.CARD_HOLDER_VERIFICATION_VALUE, oldValue, this.cardHolderVerificationValue);
            return this;
        }

        public final CardVerificationValue1.Builder getCardVerificationValue1() {
            return cardVerificationValue1 != null ? cardVerificationValue1.toBuilder() : null;
        }

        public final void setCardVerificationValue1(CardVerificationValue1.BuilderImpl cardVerificationValue1) {
            Object oldValue = this.cardVerificationValue1;
            this.cardVerificationValue1 = cardVerificationValue1 != null ? cardVerificationValue1.build() : null;
            handleUnionValueChange(Type.CARD_VERIFICATION_VALUE1, oldValue, this.cardVerificationValue1);
        }

        @Override
        public final Builder cardVerificationValue1(CardVerificationValue1 cardVerificationValue1) {
            Object oldValue = this.cardVerificationValue1;
            this.cardVerificationValue1 = cardVerificationValue1;
            handleUnionValueChange(Type.CARD_VERIFICATION_VALUE1, oldValue, this.cardVerificationValue1);
            return this;
        }

        public final CardVerificationValue2.Builder getCardVerificationValue2() {
            return cardVerificationValue2 != null ? cardVerificationValue2.toBuilder() : null;
        }

        public final void setCardVerificationValue2(CardVerificationValue2.BuilderImpl cardVerificationValue2) {
            Object oldValue = this.cardVerificationValue2;
            this.cardVerificationValue2 = cardVerificationValue2 != null ? cardVerificationValue2.build() : null;
            handleUnionValueChange(Type.CARD_VERIFICATION_VALUE2, oldValue, this.cardVerificationValue2);
        }

        @Override
        public final Builder cardVerificationValue2(CardVerificationValue2 cardVerificationValue2) {
            Object oldValue = this.cardVerificationValue2;
            this.cardVerificationValue2 = cardVerificationValue2;
            handleUnionValueChange(Type.CARD_VERIFICATION_VALUE2, oldValue, this.cardVerificationValue2);
            return this;
        }

        public final DynamicCardVerificationCode.Builder getDynamicCardVerificationCode() {
            return dynamicCardVerificationCode != null ? dynamicCardVerificationCode.toBuilder() : null;
        }

        public final void setDynamicCardVerificationCode(DynamicCardVerificationCode.BuilderImpl dynamicCardVerificationCode) {
            Object oldValue = this.dynamicCardVerificationCode;
            this.dynamicCardVerificationCode = dynamicCardVerificationCode != null ? dynamicCardVerificationCode.build() : null;
            handleUnionValueChange(Type.DYNAMIC_CARD_VERIFICATION_CODE, oldValue, this.dynamicCardVerificationCode);
        }

        @Override
        public final Builder dynamicCardVerificationCode(DynamicCardVerificationCode dynamicCardVerificationCode) {
            Object oldValue = this.dynamicCardVerificationCode;
            this.dynamicCardVerificationCode = dynamicCardVerificationCode;
            handleUnionValueChange(Type.DYNAMIC_CARD_VERIFICATION_CODE, oldValue, this.dynamicCardVerificationCode);
            return this;
        }

        public final DynamicCardVerificationValue.Builder getDynamicCardVerificationValue() {
            return dynamicCardVerificationValue != null ? dynamicCardVerificationValue.toBuilder() : null;
        }

        public final void setDynamicCardVerificationValue(DynamicCardVerificationValue.BuilderImpl dynamicCardVerificationValue) {
            Object oldValue = this.dynamicCardVerificationValue;
            this.dynamicCardVerificationValue = dynamicCardVerificationValue != null ? dynamicCardVerificationValue.build()
                    : null;
            handleUnionValueChange(Type.DYNAMIC_CARD_VERIFICATION_VALUE, oldValue, this.dynamicCardVerificationValue);
        }

        @Override
        public final Builder dynamicCardVerificationValue(DynamicCardVerificationValue dynamicCardVerificationValue) {
            Object oldValue = this.dynamicCardVerificationValue;
            this.dynamicCardVerificationValue = dynamicCardVerificationValue;
            handleUnionValueChange(Type.DYNAMIC_CARD_VERIFICATION_VALUE, oldValue, this.dynamicCardVerificationValue);
            return this;
        }

        @Override
        public CardGenerationAttributes build() {
            return new CardGenerationAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see CardGenerationAttributes#type()
     */
    public enum Type {
        AMEX_CARD_SECURITY_CODE_VERSION1,

        AMEX_CARD_SECURITY_CODE_VERSION2,

        CARD_HOLDER_VERIFICATION_VALUE,

        CARD_VERIFICATION_VALUE1,

        CARD_VERIFICATION_VALUE2,

        DYNAMIC_CARD_VERIFICATION_CODE,

        DYNAMIC_CARD_VERIFICATION_VALUE,

        UNKNOWN_TO_SDK_VERSION
    }
}
