/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.paymentcryptographydata.model.DukptAttributes;
import software.amazon.awssdk.services.paymentcryptographydata.model.PaymentCryptographyDataRequest;
import software.amazon.awssdk.services.paymentcryptographydata.model.PinBlockFormatForPinData;
import software.amazon.awssdk.services.paymentcryptographydata.model.PinVerificationAttributes;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VerifyPinDataRequest
extends PaymentCryptographyDataRequest
implements ToCopyableBuilder<Builder, VerifyPinDataRequest> {
    private static final SdkField<DukptAttributes> DUKPT_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DukptAttributes").getter(VerifyPinDataRequest.getter(VerifyPinDataRequest::dukptAttributes)).setter(VerifyPinDataRequest.setter(Builder::dukptAttributes)).constructor(DukptAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DukptAttributes").build()}).build();
    private static final SdkField<String> ENCRYPTED_PIN_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EncryptedPinBlock").getter(VerifyPinDataRequest.getter(VerifyPinDataRequest::encryptedPinBlock)).setter(VerifyPinDataRequest.setter(Builder::encryptedPinBlock)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptedPinBlock").build()}).build();
    private static final SdkField<String> ENCRYPTION_KEY_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EncryptionKeyIdentifier").getter(VerifyPinDataRequest.getter(VerifyPinDataRequest::encryptionKeyIdentifier)).setter(VerifyPinDataRequest.setter(Builder::encryptionKeyIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionKeyIdentifier").build()}).build();
    private static final SdkField<String> PIN_BLOCK_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PinBlockFormat").getter(VerifyPinDataRequest.getter(VerifyPinDataRequest::pinBlockFormatAsString)).setter(VerifyPinDataRequest.setter(Builder::pinBlockFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PinBlockFormat").build()}).build();
    private static final SdkField<Integer> PIN_DATA_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PinDataLength").getter(VerifyPinDataRequest.getter(VerifyPinDataRequest::pinDataLength)).setter(VerifyPinDataRequest.setter(Builder::pinDataLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PinDataLength").build()}).build();
    private static final SdkField<String> PRIMARY_ACCOUNT_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrimaryAccountNumber").getter(VerifyPinDataRequest.getter(VerifyPinDataRequest::primaryAccountNumber)).setter(VerifyPinDataRequest.setter(Builder::primaryAccountNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryAccountNumber").build()}).build();
    private static final SdkField<PinVerificationAttributes> VERIFICATION_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VerificationAttributes").getter(VerifyPinDataRequest.getter(VerifyPinDataRequest::verificationAttributes)).setter(VerifyPinDataRequest.setter(Builder::verificationAttributes)).constructor(PinVerificationAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerificationAttributes").build()}).build();
    private static final SdkField<String> VERIFICATION_KEY_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VerificationKeyIdentifier").getter(VerifyPinDataRequest.getter(VerifyPinDataRequest::verificationKeyIdentifier)).setter(VerifyPinDataRequest.setter(Builder::verificationKeyIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerificationKeyIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DUKPT_ATTRIBUTES_FIELD, ENCRYPTED_PIN_BLOCK_FIELD, ENCRYPTION_KEY_IDENTIFIER_FIELD, PIN_BLOCK_FORMAT_FIELD, PIN_DATA_LENGTH_FIELD, PRIMARY_ACCOUNT_NUMBER_FIELD, VERIFICATION_ATTRIBUTES_FIELD, VERIFICATION_KEY_IDENTIFIER_FIELD));
    private final DukptAttributes dukptAttributes;
    private final String encryptedPinBlock;
    private final String encryptionKeyIdentifier;
    private final String pinBlockFormat;
    private final Integer pinDataLength;
    private final String primaryAccountNumber;
    private final PinVerificationAttributes verificationAttributes;
    private final String verificationKeyIdentifier;

    private VerifyPinDataRequest(BuilderImpl builder) {
        super(builder);
        this.dukptAttributes = builder.dukptAttributes;
        this.encryptedPinBlock = builder.encryptedPinBlock;
        this.encryptionKeyIdentifier = builder.encryptionKeyIdentifier;
        this.pinBlockFormat = builder.pinBlockFormat;
        this.pinDataLength = builder.pinDataLength;
        this.primaryAccountNumber = builder.primaryAccountNumber;
        this.verificationAttributes = builder.verificationAttributes;
        this.verificationKeyIdentifier = builder.verificationKeyIdentifier;
    }

    public final DukptAttributes dukptAttributes() {
        return this.dukptAttributes;
    }

    public final String encryptedPinBlock() {
        return this.encryptedPinBlock;
    }

    public final String encryptionKeyIdentifier() {
        return this.encryptionKeyIdentifier;
    }

    public final PinBlockFormatForPinData pinBlockFormat() {
        return PinBlockFormatForPinData.fromValue(this.pinBlockFormat);
    }

    public final String pinBlockFormatAsString() {
        return this.pinBlockFormat;
    }

    public final Integer pinDataLength() {
        return this.pinDataLength;
    }

    public final String primaryAccountNumber() {
        return this.primaryAccountNumber;
    }

    public final PinVerificationAttributes verificationAttributes() {
        return this.verificationAttributes;
    }

    public final String verificationKeyIdentifier() {
        return this.verificationKeyIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dukptAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptedPinBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionKeyIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.pinBlockFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.pinDataLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryAccountNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.verificationAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.verificationKeyIdentifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VerifyPinDataRequest)) {
            return false;
        }
        VerifyPinDataRequest other = (VerifyPinDataRequest)((Object)obj);
        return Objects.equals(this.dukptAttributes(), other.dukptAttributes()) && Objects.equals(this.encryptedPinBlock(), other.encryptedPinBlock()) && Objects.equals(this.encryptionKeyIdentifier(), other.encryptionKeyIdentifier()) && Objects.equals(this.pinBlockFormatAsString(), other.pinBlockFormatAsString()) && Objects.equals(this.pinDataLength(), other.pinDataLength()) && Objects.equals(this.primaryAccountNumber(), other.primaryAccountNumber()) && Objects.equals(this.verificationAttributes(), other.verificationAttributes()) && Objects.equals(this.verificationKeyIdentifier(), other.verificationKeyIdentifier());
    }

    public final String toString() {
        return ToString.builder((String)"VerifyPinDataRequest").add("DukptAttributes", (Object)this.dukptAttributes()).add("EncryptedPinBlock", (Object)this.encryptedPinBlock()).add("EncryptionKeyIdentifier", (Object)this.encryptionKeyIdentifier()).add("PinBlockFormat", (Object)this.pinBlockFormatAsString()).add("PinDataLength", (Object)this.pinDataLength()).add("PrimaryAccountNumber", (Object)(this.primaryAccountNumber() == null ? null : "*** Sensitive Data Redacted ***")).add("VerificationAttributes", (Object)this.verificationAttributes()).add("VerificationKeyIdentifier", (Object)this.verificationKeyIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DukptAttributes": {
                return Optional.ofNullable(clazz.cast(this.dukptAttributes()));
            }
            case "EncryptedPinBlock": {
                return Optional.ofNullable(clazz.cast(this.encryptedPinBlock()));
            }
            case "EncryptionKeyIdentifier": {
                return Optional.ofNullable(clazz.cast(this.encryptionKeyIdentifier()));
            }
            case "PinBlockFormat": {
                return Optional.ofNullable(clazz.cast(this.pinBlockFormatAsString()));
            }
            case "PinDataLength": {
                return Optional.ofNullable(clazz.cast(this.pinDataLength()));
            }
            case "PrimaryAccountNumber": {
                return Optional.ofNullable(clazz.cast(this.primaryAccountNumber()));
            }
            case "VerificationAttributes": {
                return Optional.ofNullable(clazz.cast(this.verificationAttributes()));
            }
            case "VerificationKeyIdentifier": {
                return Optional.ofNullable(clazz.cast(this.verificationKeyIdentifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VerifyPinDataRequest, T> g) {
        return obj -> g.apply((VerifyPinDataRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PaymentCryptographyDataRequest.BuilderImpl
    implements Builder {
        private DukptAttributes dukptAttributes;
        private String encryptedPinBlock;
        private String encryptionKeyIdentifier;
        private String pinBlockFormat;
        private Integer pinDataLength;
        private String primaryAccountNumber;
        private PinVerificationAttributes verificationAttributes;
        private String verificationKeyIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(VerifyPinDataRequest model) {
            super(model);
            this.dukptAttributes(model.dukptAttributes);
            this.encryptedPinBlock(model.encryptedPinBlock);
            this.encryptionKeyIdentifier(model.encryptionKeyIdentifier);
            this.pinBlockFormat(model.pinBlockFormat);
            this.pinDataLength(model.pinDataLength);
            this.primaryAccountNumber(model.primaryAccountNumber);
            this.verificationAttributes(model.verificationAttributes);
            this.verificationKeyIdentifier(model.verificationKeyIdentifier);
        }

        public final DukptAttributes.Builder getDukptAttributes() {
            return this.dukptAttributes != null ? this.dukptAttributes.toBuilder() : null;
        }

        public final void setDukptAttributes(DukptAttributes.BuilderImpl dukptAttributes) {
            this.dukptAttributes = dukptAttributes != null ? dukptAttributes.build() : null;
        }

        @Override
        public final Builder dukptAttributes(DukptAttributes dukptAttributes) {
            this.dukptAttributes = dukptAttributes;
            return this;
        }

        public final String getEncryptedPinBlock() {
            return this.encryptedPinBlock;
        }

        public final void setEncryptedPinBlock(String encryptedPinBlock) {
            this.encryptedPinBlock = encryptedPinBlock;
        }

        @Override
        public final Builder encryptedPinBlock(String encryptedPinBlock) {
            this.encryptedPinBlock = encryptedPinBlock;
            return this;
        }

        public final String getEncryptionKeyIdentifier() {
            return this.encryptionKeyIdentifier;
        }

        public final void setEncryptionKeyIdentifier(String encryptionKeyIdentifier) {
            this.encryptionKeyIdentifier = encryptionKeyIdentifier;
        }

        @Override
        public final Builder encryptionKeyIdentifier(String encryptionKeyIdentifier) {
            this.encryptionKeyIdentifier = encryptionKeyIdentifier;
            return this;
        }

        public final String getPinBlockFormat() {
            return this.pinBlockFormat;
        }

        public final void setPinBlockFormat(String pinBlockFormat) {
            this.pinBlockFormat = pinBlockFormat;
        }

        @Override
        public final Builder pinBlockFormat(String pinBlockFormat) {
            this.pinBlockFormat = pinBlockFormat;
            return this;
        }

        @Override
        public final Builder pinBlockFormat(PinBlockFormatForPinData pinBlockFormat) {
            this.pinBlockFormat(pinBlockFormat == null ? null : pinBlockFormat.toString());
            return this;
        }

        public final Integer getPinDataLength() {
            return this.pinDataLength;
        }

        public final void setPinDataLength(Integer pinDataLength) {
            this.pinDataLength = pinDataLength;
        }

        @Override
        public final Builder pinDataLength(Integer pinDataLength) {
            this.pinDataLength = pinDataLength;
            return this;
        }

        public final String getPrimaryAccountNumber() {
            return this.primaryAccountNumber;
        }

        public final void setPrimaryAccountNumber(String primaryAccountNumber) {
            this.primaryAccountNumber = primaryAccountNumber;
        }

        @Override
        public final Builder primaryAccountNumber(String primaryAccountNumber) {
            this.primaryAccountNumber = primaryAccountNumber;
            return this;
        }

        public final PinVerificationAttributes.Builder getVerificationAttributes() {
            return this.verificationAttributes != null ? this.verificationAttributes.toBuilder() : null;
        }

        public final void setVerificationAttributes(PinVerificationAttributes.BuilderImpl verificationAttributes) {
            this.verificationAttributes = verificationAttributes != null ? verificationAttributes.build() : null;
        }

        @Override
        public final Builder verificationAttributes(PinVerificationAttributes verificationAttributes) {
            this.verificationAttributes = verificationAttributes;
            return this;
        }

        public final String getVerificationKeyIdentifier() {
            return this.verificationKeyIdentifier;
        }

        public final void setVerificationKeyIdentifier(String verificationKeyIdentifier) {
            this.verificationKeyIdentifier = verificationKeyIdentifier;
        }

        @Override
        public final Builder verificationKeyIdentifier(String verificationKeyIdentifier) {
            this.verificationKeyIdentifier = verificationKeyIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public VerifyPinDataRequest build() {
            return new VerifyPinDataRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PaymentCryptographyDataRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, VerifyPinDataRequest> {
        public Builder dukptAttributes(DukptAttributes var1);

        default public Builder dukptAttributes(Consumer<DukptAttributes.Builder> dukptAttributes) {
            return this.dukptAttributes((DukptAttributes)((DukptAttributes.Builder)DukptAttributes.builder().applyMutation(dukptAttributes)).build());
        }

        public Builder encryptedPinBlock(String var1);

        public Builder encryptionKeyIdentifier(String var1);

        public Builder pinBlockFormat(String var1);

        public Builder pinBlockFormat(PinBlockFormatForPinData var1);

        public Builder pinDataLength(Integer var1);

        public Builder primaryAccountNumber(String var1);

        public Builder verificationAttributes(PinVerificationAttributes var1);

        default public Builder verificationAttributes(Consumer<PinVerificationAttributes.Builder> verificationAttributes) {
            return this.verificationAttributes((PinVerificationAttributes)((PinVerificationAttributes.Builder)PinVerificationAttributes.builder().applyMutation(verificationAttributes)).build());
        }

        public Builder verificationKeyIdentifier(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

