/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptography.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum KeyReplicationState {
    IN_PROGRESS("IN_PROGRESS"),
    DELETE_IN_PROGRESS("DELETE_IN_PROGRESS"),
    FAILED("FAILED"),
    SYNCHRONIZED("SYNCHRONIZED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, KeyReplicationState> VALUE_MAP;
    private final String value;

    private KeyReplicationState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static KeyReplicationState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<KeyReplicationState> knownValues() {
        EnumSet<KeyReplicationState> knownValues = EnumSet.allOf(KeyReplicationState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(KeyReplicationState.class, KeyReplicationState::toString);
    }
}

