/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptography.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.paymentcryptography.model.As2805KeyVariant;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExportAs2805KeyCryptogram
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExportAs2805KeyCryptogram> {
    private static final SdkField<String> WRAPPING_KEY_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WrappingKeyIdentifier").getter(ExportAs2805KeyCryptogram.getter(ExportAs2805KeyCryptogram::wrappingKeyIdentifier)).setter(ExportAs2805KeyCryptogram.setter(Builder::wrappingKeyIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WrappingKeyIdentifier").build()}).build();
    private static final SdkField<String> AS2805_KEY_VARIANT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("As2805KeyVariant").getter(ExportAs2805KeyCryptogram.getter(ExportAs2805KeyCryptogram::as2805KeyVariantAsString)).setter(ExportAs2805KeyCryptogram.setter(Builder::as2805KeyVariant)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("As2805KeyVariant").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WRAPPING_KEY_IDENTIFIER_FIELD, AS2805_KEY_VARIANT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ExportAs2805KeyCryptogram.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String wrappingKeyIdentifier;
    private final String as2805KeyVariant;

    private ExportAs2805KeyCryptogram(BuilderImpl builder) {
        this.wrappingKeyIdentifier = builder.wrappingKeyIdentifier;
        this.as2805KeyVariant = builder.as2805KeyVariant;
    }

    public final String wrappingKeyIdentifier() {
        return this.wrappingKeyIdentifier;
    }

    public final As2805KeyVariant as2805KeyVariant() {
        return As2805KeyVariant.fromValue(this.as2805KeyVariant);
    }

    public final String as2805KeyVariantAsString() {
        return this.as2805KeyVariant;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.wrappingKeyIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.as2805KeyVariantAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportAs2805KeyCryptogram)) {
            return false;
        }
        ExportAs2805KeyCryptogram other = (ExportAs2805KeyCryptogram)obj;
        return Objects.equals(this.wrappingKeyIdentifier(), other.wrappingKeyIdentifier()) && Objects.equals(this.as2805KeyVariantAsString(), other.as2805KeyVariantAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ExportAs2805KeyCryptogram").add("WrappingKeyIdentifier", (Object)this.wrappingKeyIdentifier()).add("As2805KeyVariant", (Object)this.as2805KeyVariantAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WrappingKeyIdentifier": {
                return Optional.ofNullable(clazz.cast(this.wrappingKeyIdentifier()));
            }
            case "As2805KeyVariant": {
                return Optional.ofNullable(clazz.cast(this.as2805KeyVariantAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("WrappingKeyIdentifier", WRAPPING_KEY_IDENTIFIER_FIELD);
        map.put("As2805KeyVariant", AS2805_KEY_VARIANT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExportAs2805KeyCryptogram, T> g) {
        return obj -> g.apply((ExportAs2805KeyCryptogram)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String wrappingKeyIdentifier;
        private String as2805KeyVariant;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportAs2805KeyCryptogram model) {
            this.wrappingKeyIdentifier(model.wrappingKeyIdentifier);
            this.as2805KeyVariant(model.as2805KeyVariant);
        }

        public final String getWrappingKeyIdentifier() {
            return this.wrappingKeyIdentifier;
        }

        public final void setWrappingKeyIdentifier(String wrappingKeyIdentifier) {
            this.wrappingKeyIdentifier = wrappingKeyIdentifier;
        }

        @Override
        public final Builder wrappingKeyIdentifier(String wrappingKeyIdentifier) {
            this.wrappingKeyIdentifier = wrappingKeyIdentifier;
            return this;
        }

        public final String getAs2805KeyVariant() {
            return this.as2805KeyVariant;
        }

        public final void setAs2805KeyVariant(String as2805KeyVariant) {
            this.as2805KeyVariant = as2805KeyVariant;
        }

        @Override
        public final Builder as2805KeyVariant(String as2805KeyVariant) {
            this.as2805KeyVariant = as2805KeyVariant;
            return this;
        }

        @Override
        public final Builder as2805KeyVariant(As2805KeyVariant as2805KeyVariant) {
            this.as2805KeyVariant(as2805KeyVariant == null ? null : as2805KeyVariant.toString());
            return this;
        }

        public ExportAs2805KeyCryptogram build() {
            return new ExportAs2805KeyCryptogram(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExportAs2805KeyCryptogram> {
        public Builder wrappingKeyIdentifier(String var1);

        public Builder as2805KeyVariant(String var1);

        public Builder as2805KeyVariant(As2805KeyVariant var1);
    }
}

