/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptography.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.paymentcryptography.model.PaymentCryptographyRequest;
import software.amazon.awssdk.services.paymentcryptography.model.RegionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DisableDefaultKeyReplicationRegionsRequest
extends PaymentCryptographyRequest
implements ToCopyableBuilder<Builder, DisableDefaultKeyReplicationRegionsRequest> {
    private static final SdkField<List<String>> REPLICATION_REGIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReplicationRegions").getter(DisableDefaultKeyReplicationRegionsRequest.getter(DisableDefaultKeyReplicationRegionsRequest::replicationRegions)).setter(DisableDefaultKeyReplicationRegionsRequest.setter(Builder::replicationRegions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationRegions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATION_REGIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DisableDefaultKeyReplicationRegionsRequest.memberNameToFieldInitializer();
    private final List<String> replicationRegions;

    private DisableDefaultKeyReplicationRegionsRequest(BuilderImpl builder) {
        super(builder);
        this.replicationRegions = builder.replicationRegions;
    }

    public final boolean hasReplicationRegions() {
        return this.replicationRegions != null && !(this.replicationRegions instanceof SdkAutoConstructList);
    }

    public final List<String> replicationRegions() {
        return this.replicationRegions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReplicationRegions() ? this.replicationRegions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisableDefaultKeyReplicationRegionsRequest)) {
            return false;
        }
        DisableDefaultKeyReplicationRegionsRequest other = (DisableDefaultKeyReplicationRegionsRequest)((Object)obj);
        return this.hasReplicationRegions() == other.hasReplicationRegions() && Objects.equals(this.replicationRegions(), other.replicationRegions());
    }

    public final String toString() {
        return ToString.builder((String)"DisableDefaultKeyReplicationRegionsRequest").add("ReplicationRegions", this.hasReplicationRegions() ? this.replicationRegions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReplicationRegions": {
                return Optional.ofNullable(clazz.cast(this.replicationRegions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("ReplicationRegions", REPLICATION_REGIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DisableDefaultKeyReplicationRegionsRequest, T> g) {
        return obj -> g.apply((DisableDefaultKeyReplicationRegionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PaymentCryptographyRequest.BuilderImpl
    implements Builder {
        private List<String> replicationRegions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DisableDefaultKeyReplicationRegionsRequest model) {
            super(model);
            this.replicationRegions(model.replicationRegions);
        }

        public final Collection<String> getReplicationRegions() {
            if (this.replicationRegions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.replicationRegions;
        }

        public final void setReplicationRegions(Collection<String> replicationRegions) {
            this.replicationRegions = RegionsCopier.copy(replicationRegions);
        }

        @Override
        public final Builder replicationRegions(Collection<String> replicationRegions) {
            this.replicationRegions = RegionsCopier.copy(replicationRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationRegions(String ... replicationRegions) {
            this.replicationRegions(Arrays.asList(replicationRegions));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DisableDefaultKeyReplicationRegionsRequest build() {
            return new DisableDefaultKeyReplicationRegionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PaymentCryptographyRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DisableDefaultKeyReplicationRegionsRequest> {
        public Builder replicationRegions(Collection<String> var1);

        public Builder replicationRegions(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

