/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptography.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum As2805KeyVariant {
    TERMINAL_MAJOR_KEY_VARIANT_00("TERMINAL_MAJOR_KEY_VARIANT_00"),
    PIN_ENCRYPTION_KEY_VARIANT_28("PIN_ENCRYPTION_KEY_VARIANT_28"),
    MESSAGE_AUTHENTICATION_KEY_VARIANT_24("MESSAGE_AUTHENTICATION_KEY_VARIANT_24"),
    DATA_ENCRYPTION_KEY_VARIANT_22("DATA_ENCRYPTION_KEY_VARIANT_22"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, As2805KeyVariant> VALUE_MAP;
    private final String value;

    private As2805KeyVariant(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static As2805KeyVariant fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<As2805KeyVariant> knownValues() {
        EnumSet<As2805KeyVariant> knownValues = EnumSet.allOf(As2805KeyVariant.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(As2805KeyVariant.class, As2805KeyVariant::toString);
    }
}

