/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.paymentcryptography.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Metadata about an Amazon Web Services Payment Cryptography key.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KeySummary implements SdkPojo, Serializable, ToCopyableBuilder<KeySummary.Builder, KeySummary> {
    private static final SdkField<String> KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("KeyArn")
            .getter(getter(KeySummary::keyArn)).setter(setter(Builder::keyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyArn").build()).build();

    private static final SdkField<String> KEY_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KeyState").getter(getter(KeySummary::keyStateAsString)).setter(setter(Builder::keyState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyState").build()).build();

    private static final SdkField<KeyAttributes> KEY_ATTRIBUTES_FIELD = SdkField
            .<KeyAttributes> builder(MarshallingType.SDK_POJO).memberName("KeyAttributes")
            .getter(getter(KeySummary::keyAttributes)).setter(setter(Builder::keyAttributes)).constructor(KeyAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyAttributes").build()).build();

    private static final SdkField<String> KEY_CHECK_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KeyCheckValue").getter(getter(KeySummary::keyCheckValue)).setter(setter(Builder::keyCheckValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyCheckValue").build()).build();

    private static final SdkField<Boolean> EXPORTABLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Exportable").getter(getter(KeySummary::exportable)).setter(setter(Builder::exportable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Exportable").build()).build();

    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Enabled").getter(getter(KeySummary::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()).build();

    private static final SdkField<String> MULTI_REGION_KEY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MultiRegionKeyType").getter(getter(KeySummary::multiRegionKeyTypeAsString))
            .setter(setter(Builder::multiRegionKeyType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiRegionKeyType").build())
            .build();

    private static final SdkField<String> PRIMARY_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrimaryRegion").getter(getter(KeySummary::primaryRegion)).setter(setter(Builder::primaryRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryRegion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_ARN_FIELD,
            KEY_STATE_FIELD, KEY_ATTRIBUTES_FIELD, KEY_CHECK_VALUE_FIELD, EXPORTABLE_FIELD, ENABLED_FIELD,
            MULTI_REGION_KEY_TYPE_FIELD, PRIMARY_REGION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String keyArn;

    private final String keyState;

    private final KeyAttributes keyAttributes;

    private final String keyCheckValue;

    private final Boolean exportable;

    private final Boolean enabled;

    private final String multiRegionKeyType;

    private final String primaryRegion;

    private KeySummary(BuilderImpl builder) {
        this.keyArn = builder.keyArn;
        this.keyState = builder.keyState;
        this.keyAttributes = builder.keyAttributes;
        this.keyCheckValue = builder.keyCheckValue;
        this.exportable = builder.exportable;
        this.enabled = builder.enabled;
        this.multiRegionKeyType = builder.multiRegionKeyType;
        this.primaryRegion = builder.primaryRegion;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the key.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the key.
     */
    public final String keyArn() {
        return keyArn;
    }

    /**
     * <p>
     * The state of an Amazon Web Services Payment Cryptography that is being created or deleted.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #keyState} will
     * return {@link KeyState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #keyStateAsString}.
     * </p>
     * 
     * @return The state of an Amazon Web Services Payment Cryptography that is being created or deleted.
     * @see KeyState
     */
    public final KeyState keyState() {
        return KeyState.fromValue(keyState);
    }

    /**
     * <p>
     * The state of an Amazon Web Services Payment Cryptography that is being created or deleted.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #keyState} will
     * return {@link KeyState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #keyStateAsString}.
     * </p>
     * 
     * @return The state of an Amazon Web Services Payment Cryptography that is being created or deleted.
     * @see KeyState
     */
    public final String keyStateAsString() {
        return keyState;
    }

    /**
     * <p>
     * The role of the key, the algorithm it supports, and the cryptographic operations allowed with the key. This data
     * is immutable after the key is created.
     * </p>
     * 
     * @return The role of the key, the algorithm it supports, and the cryptographic operations allowed with the key.
     *         This data is immutable after the key is created.
     */
    public final KeyAttributes keyAttributes() {
        return keyAttributes;
    }

    /**
     * <p>
     * The key check value (KCV) is used to check if all parties holding a given key have the same key or to detect that
     * a key has changed.
     * </p>
     * 
     * @return The key check value (KCV) is used to check if all parties holding a given key have the same key or to
     *         detect that a key has changed.
     */
    public final String keyCheckValue() {
        return keyCheckValue;
    }

    /**
     * <p>
     * Specifies whether the key is exportable. This data is immutable after the key is created.
     * </p>
     * 
     * @return Specifies whether the key is exportable. This data is immutable after the key is created.
     */
    public final Boolean exportable() {
        return exportable;
    }

    /**
     * <p>
     * Specifies whether the key is enabled.
     * </p>
     * 
     * @return Specifies whether the key is enabled.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * Indicates whether this key is a Multi-Region key and its role in the Multi-Region key hierarchy.
     * </p>
     * <p>
     * Multi-Region replication keys allow the same key material to be used across multiple Amazon Web Services Regions.
     * This field specifies whether the key is a Primary Region key (PRK) (which can be replicated to other Amazon Web
     * Services Regions) or a Replica Region key (RRK) (which is a copy of a PRK in another Region). For more
     * information, see <a
     * href="https://docs.aws.amazon.com/payment-cryptography/latest/userguide/keys-multi-region-replication.html"
     * >Multi-Region key replication</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #multiRegionKeyType} will return {@link MultiRegionKeyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #multiRegionKeyTypeAsString}.
     * </p>
     * 
     * @return Indicates whether this key is a Multi-Region key and its role in the Multi-Region key hierarchy.</p>
     *         <p>
     *         Multi-Region replication keys allow the same key material to be used across multiple Amazon Web Services
     *         Regions. This field specifies whether the key is a Primary Region key (PRK) (which can be replicated to
     *         other Amazon Web Services Regions) or a Replica Region key (RRK) (which is a copy of a PRK in another
     *         Region). For more information, see <a href=
     *         "https://docs.aws.amazon.com/payment-cryptography/latest/userguide/keys-multi-region-replication.html"
     *         >Multi-Region key replication</a>.
     * @see MultiRegionKeyType
     */
    public final MultiRegionKeyType multiRegionKeyType() {
        return MultiRegionKeyType.fromValue(multiRegionKeyType);
    }

    /**
     * <p>
     * Indicates whether this key is a Multi-Region key and its role in the Multi-Region key hierarchy.
     * </p>
     * <p>
     * Multi-Region replication keys allow the same key material to be used across multiple Amazon Web Services Regions.
     * This field specifies whether the key is a Primary Region key (PRK) (which can be replicated to other Amazon Web
     * Services Regions) or a Replica Region key (RRK) (which is a copy of a PRK in another Region). For more
     * information, see <a
     * href="https://docs.aws.amazon.com/payment-cryptography/latest/userguide/keys-multi-region-replication.html"
     * >Multi-Region key replication</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #multiRegionKeyType} will return {@link MultiRegionKeyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #multiRegionKeyTypeAsString}.
     * </p>
     * 
     * @return Indicates whether this key is a Multi-Region key and its role in the Multi-Region key hierarchy.</p>
     *         <p>
     *         Multi-Region replication keys allow the same key material to be used across multiple Amazon Web Services
     *         Regions. This field specifies whether the key is a Primary Region key (PRK) (which can be replicated to
     *         other Amazon Web Services Regions) or a Replica Region key (RRK) (which is a copy of a PRK in another
     *         Region). For more information, see <a href=
     *         "https://docs.aws.amazon.com/payment-cryptography/latest/userguide/keys-multi-region-replication.html"
     *         >Multi-Region key replication</a>.
     * @see MultiRegionKeyType
     */
    public final String multiRegionKeyTypeAsString() {
        return multiRegionKeyType;
    }

    /**
     * Returns the value of the PrimaryRegion property for this object.
     * 
     * @return The value of the PrimaryRegion property for this object.
     */
    public final String primaryRegion() {
        return primaryRegion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(keyArn());
        hashCode = 31 * hashCode + Objects.hashCode(keyStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(keyAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(keyCheckValue());
        hashCode = 31 * hashCode + Objects.hashCode(exportable());
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(multiRegionKeyTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(primaryRegion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KeySummary)) {
            return false;
        }
        KeySummary other = (KeySummary) obj;
        return Objects.equals(keyArn(), other.keyArn()) && Objects.equals(keyStateAsString(), other.keyStateAsString())
                && Objects.equals(keyAttributes(), other.keyAttributes())
                && Objects.equals(keyCheckValue(), other.keyCheckValue()) && Objects.equals(exportable(), other.exportable())
                && Objects.equals(enabled(), other.enabled())
                && Objects.equals(multiRegionKeyTypeAsString(), other.multiRegionKeyTypeAsString())
                && Objects.equals(primaryRegion(), other.primaryRegion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KeySummary").add("KeyArn", keyArn()).add("KeyState", keyStateAsString())
                .add("KeyAttributes", keyAttributes()).add("KeyCheckValue", keyCheckValue()).add("Exportable", exportable())
                .add("Enabled", enabled()).add("MultiRegionKeyType", multiRegionKeyTypeAsString())
                .add("PrimaryRegion", primaryRegion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KeyArn":
            return Optional.ofNullable(clazz.cast(keyArn()));
        case "KeyState":
            return Optional.ofNullable(clazz.cast(keyStateAsString()));
        case "KeyAttributes":
            return Optional.ofNullable(clazz.cast(keyAttributes()));
        case "KeyCheckValue":
            return Optional.ofNullable(clazz.cast(keyCheckValue()));
        case "Exportable":
            return Optional.ofNullable(clazz.cast(exportable()));
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "MultiRegionKeyType":
            return Optional.ofNullable(clazz.cast(multiRegionKeyTypeAsString()));
        case "PrimaryRegion":
            return Optional.ofNullable(clazz.cast(primaryRegion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("KeyArn", KEY_ARN_FIELD);
        map.put("KeyState", KEY_STATE_FIELD);
        map.put("KeyAttributes", KEY_ATTRIBUTES_FIELD);
        map.put("KeyCheckValue", KEY_CHECK_VALUE_FIELD);
        map.put("Exportable", EXPORTABLE_FIELD);
        map.put("Enabled", ENABLED_FIELD);
        map.put("MultiRegionKeyType", MULTI_REGION_KEY_TYPE_FIELD);
        map.put("PrimaryRegion", PRIMARY_REGION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KeySummary, T> g) {
        return obj -> g.apply((KeySummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KeySummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the key.
         * </p>
         * 
         * @param keyArn
         *        The Amazon Resource Name (ARN) of the key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyArn(String keyArn);

        /**
         * <p>
         * The state of an Amazon Web Services Payment Cryptography that is being created or deleted.
         * </p>
         * 
         * @param keyState
         *        The state of an Amazon Web Services Payment Cryptography that is being created or deleted.
         * @see KeyState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KeyState
         */
        Builder keyState(String keyState);

        /**
         * <p>
         * The state of an Amazon Web Services Payment Cryptography that is being created or deleted.
         * </p>
         * 
         * @param keyState
         *        The state of an Amazon Web Services Payment Cryptography that is being created or deleted.
         * @see KeyState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KeyState
         */
        Builder keyState(KeyState keyState);

        /**
         * <p>
         * The role of the key, the algorithm it supports, and the cryptographic operations allowed with the key. This
         * data is immutable after the key is created.
         * </p>
         * 
         * @param keyAttributes
         *        The role of the key, the algorithm it supports, and the cryptographic operations allowed with the key.
         *        This data is immutable after the key is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyAttributes(KeyAttributes keyAttributes);

        /**
         * <p>
         * The role of the key, the algorithm it supports, and the cryptographic operations allowed with the key. This
         * data is immutable after the key is created.
         * </p>
         * This is a convenience method that creates an instance of the {@link KeyAttributes.Builder} avoiding the need
         * to create one manually via {@link KeyAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KeyAttributes.Builder#build()} is called immediately and its
         * result is passed to {@link #keyAttributes(KeyAttributes)}.
         * 
         * @param keyAttributes
         *        a consumer that will call methods on {@link KeyAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #keyAttributes(KeyAttributes)
         */
        default Builder keyAttributes(Consumer<KeyAttributes.Builder> keyAttributes) {
            return keyAttributes(KeyAttributes.builder().applyMutation(keyAttributes).build());
        }

        /**
         * <p>
         * The key check value (KCV) is used to check if all parties holding a given key have the same key or to detect
         * that a key has changed.
         * </p>
         * 
         * @param keyCheckValue
         *        The key check value (KCV) is used to check if all parties holding a given key have the same key or to
         *        detect that a key has changed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyCheckValue(String keyCheckValue);

        /**
         * <p>
         * Specifies whether the key is exportable. This data is immutable after the key is created.
         * </p>
         * 
         * @param exportable
         *        Specifies whether the key is exportable. This data is immutable after the key is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportable(Boolean exportable);

        /**
         * <p>
         * Specifies whether the key is enabled.
         * </p>
         * 
         * @param enabled
         *        Specifies whether the key is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * Indicates whether this key is a Multi-Region key and its role in the Multi-Region key hierarchy.
         * </p>
         * <p>
         * Multi-Region replication keys allow the same key material to be used across multiple Amazon Web Services
         * Regions. This field specifies whether the key is a Primary Region key (PRK) (which can be replicated to other
         * Amazon Web Services Regions) or a Replica Region key (RRK) (which is a copy of a PRK in another Region). For
         * more information, see <a
         * href="https://docs.aws.amazon.com/payment-cryptography/latest/userguide/keys-multi-region-replication.html"
         * >Multi-Region key replication</a>.
         * </p>
         * 
         * @param multiRegionKeyType
         *        Indicates whether this key is a Multi-Region key and its role in the Multi-Region key hierarchy.</p>
         *        <p>
         *        Multi-Region replication keys allow the same key material to be used across multiple Amazon Web
         *        Services Regions. This field specifies whether the key is a Primary Region key (PRK) (which can be
         *        replicated to other Amazon Web Services Regions) or a Replica Region key (RRK) (which is a copy of a
         *        PRK in another Region). For more information, see <a href=
         *        "https://docs.aws.amazon.com/payment-cryptography/latest/userguide/keys-multi-region-replication.html"
         *        >Multi-Region key replication</a>.
         * @see MultiRegionKeyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MultiRegionKeyType
         */
        Builder multiRegionKeyType(String multiRegionKeyType);

        /**
         * <p>
         * Indicates whether this key is a Multi-Region key and its role in the Multi-Region key hierarchy.
         * </p>
         * <p>
         * Multi-Region replication keys allow the same key material to be used across multiple Amazon Web Services
         * Regions. This field specifies whether the key is a Primary Region key (PRK) (which can be replicated to other
         * Amazon Web Services Regions) or a Replica Region key (RRK) (which is a copy of a PRK in another Region). For
         * more information, see <a
         * href="https://docs.aws.amazon.com/payment-cryptography/latest/userguide/keys-multi-region-replication.html"
         * >Multi-Region key replication</a>.
         * </p>
         * 
         * @param multiRegionKeyType
         *        Indicates whether this key is a Multi-Region key and its role in the Multi-Region key hierarchy.</p>
         *        <p>
         *        Multi-Region replication keys allow the same key material to be used across multiple Amazon Web
         *        Services Regions. This field specifies whether the key is a Primary Region key (PRK) (which can be
         *        replicated to other Amazon Web Services Regions) or a Replica Region key (RRK) (which is a copy of a
         *        PRK in another Region). For more information, see <a href=
         *        "https://docs.aws.amazon.com/payment-cryptography/latest/userguide/keys-multi-region-replication.html"
         *        >Multi-Region key replication</a>.
         * @see MultiRegionKeyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MultiRegionKeyType
         */
        Builder multiRegionKeyType(MultiRegionKeyType multiRegionKeyType);

        /**
         * Sets the value of the PrimaryRegion property for this object.
         *
         * @param primaryRegion
         *        The new value for the PrimaryRegion property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryRegion(String primaryRegion);
    }

    static final class BuilderImpl implements Builder {
        private String keyArn;

        private String keyState;

        private KeyAttributes keyAttributes;

        private String keyCheckValue;

        private Boolean exportable;

        private Boolean enabled;

        private String multiRegionKeyType;

        private String primaryRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(KeySummary model) {
            keyArn(model.keyArn);
            keyState(model.keyState);
            keyAttributes(model.keyAttributes);
            keyCheckValue(model.keyCheckValue);
            exportable(model.exportable);
            enabled(model.enabled);
            multiRegionKeyType(model.multiRegionKeyType);
            primaryRegion(model.primaryRegion);
        }

        public final String getKeyArn() {
            return keyArn;
        }

        public final void setKeyArn(String keyArn) {
            this.keyArn = keyArn;
        }

        @Override
        public final Builder keyArn(String keyArn) {
            this.keyArn = keyArn;
            return this;
        }

        public final String getKeyState() {
            return keyState;
        }

        public final void setKeyState(String keyState) {
            this.keyState = keyState;
        }

        @Override
        public final Builder keyState(String keyState) {
            this.keyState = keyState;
            return this;
        }

        @Override
        public final Builder keyState(KeyState keyState) {
            this.keyState(keyState == null ? null : keyState.toString());
            return this;
        }

        public final KeyAttributes.Builder getKeyAttributes() {
            return keyAttributes != null ? keyAttributes.toBuilder() : null;
        }

        public final void setKeyAttributes(KeyAttributes.BuilderImpl keyAttributes) {
            this.keyAttributes = keyAttributes != null ? keyAttributes.build() : null;
        }

        @Override
        public final Builder keyAttributes(KeyAttributes keyAttributes) {
            this.keyAttributes = keyAttributes;
            return this;
        }

        public final String getKeyCheckValue() {
            return keyCheckValue;
        }

        public final void setKeyCheckValue(String keyCheckValue) {
            this.keyCheckValue = keyCheckValue;
        }

        @Override
        public final Builder keyCheckValue(String keyCheckValue) {
            this.keyCheckValue = keyCheckValue;
            return this;
        }

        public final Boolean getExportable() {
            return exportable;
        }

        public final void setExportable(Boolean exportable) {
            this.exportable = exportable;
        }

        @Override
        public final Builder exportable(Boolean exportable) {
            this.exportable = exportable;
            return this;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final String getMultiRegionKeyType() {
            return multiRegionKeyType;
        }

        public final void setMultiRegionKeyType(String multiRegionKeyType) {
            this.multiRegionKeyType = multiRegionKeyType;
        }

        @Override
        public final Builder multiRegionKeyType(String multiRegionKeyType) {
            this.multiRegionKeyType = multiRegionKeyType;
            return this;
        }

        @Override
        public final Builder multiRegionKeyType(MultiRegionKeyType multiRegionKeyType) {
            this.multiRegionKeyType(multiRegionKeyType == null ? null : multiRegionKeyType.toString());
            return this;
        }

        public final String getPrimaryRegion() {
            return primaryRegion;
        }

        public final void setPrimaryRegion(String primaryRegion) {
            this.primaryRegion = primaryRegion;
        }

        @Override
        public final Builder primaryRegion(String primaryRegion) {
            this.primaryRegion = primaryRegion;
            return this;
        }

        @Override
        public KeySummary build() {
            return new KeySummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
