/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.paymentcryptography.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The list of cryptographic operations that you can perform using the key. The modes of use are deﬁned in section A.5.3
 * of the TR-31 spec.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KeyModesOfUse implements SdkPojo, Serializable, ToCopyableBuilder<KeyModesOfUse.Builder, KeyModesOfUse> {
    private static final SdkField<Boolean> ENCRYPT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Encrypt").getter(getter(KeyModesOfUse::encrypt)).setter(setter(Builder::encrypt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encrypt").build()).build();

    private static final SdkField<Boolean> DECRYPT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Decrypt").getter(getter(KeyModesOfUse::decrypt)).setter(setter(Builder::decrypt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Decrypt").build()).build();

    private static final SdkField<Boolean> WRAP_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN).memberName("Wrap")
            .getter(getter(KeyModesOfUse::wrap)).setter(setter(Builder::wrap))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Wrap").build()).build();

    private static final SdkField<Boolean> UNWRAP_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Unwrap").getter(getter(KeyModesOfUse::unwrap)).setter(setter(Builder::unwrap))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Unwrap").build()).build();

    private static final SdkField<Boolean> GENERATE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Generate").getter(getter(KeyModesOfUse::generate)).setter(setter(Builder::generate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Generate").build()).build();

    private static final SdkField<Boolean> SIGN_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN).memberName("Sign")
            .getter(getter(KeyModesOfUse::sign)).setter(setter(Builder::sign))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sign").build()).build();

    private static final SdkField<Boolean> VERIFY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Verify").getter(getter(KeyModesOfUse::verify)).setter(setter(Builder::verify))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Verify").build()).build();

    private static final SdkField<Boolean> DERIVE_KEY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DeriveKey").getter(getter(KeyModesOfUse::deriveKey)).setter(setter(Builder::deriveKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeriveKey").build()).build();

    private static final SdkField<Boolean> NO_RESTRICTIONS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("NoRestrictions").getter(getter(KeyModesOfUse::noRestrictions)).setter(setter(Builder::noRestrictions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NoRestrictions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENCRYPT_FIELD, DECRYPT_FIELD,
            WRAP_FIELD, UNWRAP_FIELD, GENERATE_FIELD, SIGN_FIELD, VERIFY_FIELD, DERIVE_KEY_FIELD, NO_RESTRICTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean encrypt;

    private final Boolean decrypt;

    private final Boolean wrap;

    private final Boolean unwrap;

    private final Boolean generate;

    private final Boolean sign;

    private final Boolean verify;

    private final Boolean deriveKey;

    private final Boolean noRestrictions;

    private KeyModesOfUse(BuilderImpl builder) {
        this.encrypt = builder.encrypt;
        this.decrypt = builder.decrypt;
        this.wrap = builder.wrap;
        this.unwrap = builder.unwrap;
        this.generate = builder.generate;
        this.sign = builder.sign;
        this.verify = builder.verify;
        this.deriveKey = builder.deriveKey;
        this.noRestrictions = builder.noRestrictions;
    }

    /**
     * <p>
     * Speciﬁes whether an Amazon Web Services Payment Cryptography key can be used to encrypt data.
     * </p>
     * 
     * @return Speciﬁes whether an Amazon Web Services Payment Cryptography key can be used to encrypt data.
     */
    public final Boolean encrypt() {
        return encrypt;
    }

    /**
     * <p>
     * Speciﬁes whether an Amazon Web Services Payment Cryptography key can be used to decrypt data.
     * </p>
     * 
     * @return Speciﬁes whether an Amazon Web Services Payment Cryptography key can be used to decrypt data.
     */
    public final Boolean decrypt() {
        return decrypt;
    }

    /**
     * <p>
     * Speciﬁes whether an Amazon Web Services Payment Cryptography key can be used to wrap other keys.
     * </p>
     * 
     * @return Speciﬁes whether an Amazon Web Services Payment Cryptography key can be used to wrap other keys.
     */
    public final Boolean wrap() {
        return wrap;
    }

    /**
     * <p>
     * Speciﬁes whether an Amazon Web Services Payment Cryptography key can be used to unwrap other keys.
     * </p>
     * 
     * @return Speciﬁes whether an Amazon Web Services Payment Cryptography key can be used to unwrap other keys.
     */
    public final Boolean unwrap() {
        return unwrap;
    }

    /**
     * <p>
     * Speciﬁes whether an Amazon Web Services Payment Cryptography key can be used to generate and verify other card
     * and PIN verification keys.
     * </p>
     * 
     * @return Speciﬁes whether an Amazon Web Services Payment Cryptography key can be used to generate and verify other
     *         card and PIN verification keys.
     */
    public final Boolean generate() {
        return generate;
    }

    /**
     * <p>
     * Speciﬁes whether an Amazon Web Services Payment Cryptography key can be used for signing.
     * </p>
     * 
     * @return Speciﬁes whether an Amazon Web Services Payment Cryptography key can be used for signing.
     */
    public final Boolean sign() {
        return sign;
    }

    /**
     * <p>
     * Speciﬁes whether an Amazon Web Services Payment Cryptography key can be used to verify signatures.
     * </p>
     * 
     * @return Speciﬁes whether an Amazon Web Services Payment Cryptography key can be used to verify signatures.
     */
    public final Boolean verify() {
        return verify;
    }

    /**
     * <p>
     * Speciﬁes whether an Amazon Web Services Payment Cryptography key can be used to derive new keys.
     * </p>
     * 
     * @return Speciﬁes whether an Amazon Web Services Payment Cryptography key can be used to derive new keys.
     */
    public final Boolean deriveKey() {
        return deriveKey;
    }

    /**
     * <p>
     * Speciﬁes whether an Amazon Web Services Payment Cryptography key has no special restrictions other than the
     * restrictions implied by <code>KeyUsage</code>.
     * </p>
     * 
     * @return Speciﬁes whether an Amazon Web Services Payment Cryptography key has no special restrictions other than
     *         the restrictions implied by <code>KeyUsage</code>.
     */
    public final Boolean noRestrictions() {
        return noRestrictions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(encrypt());
        hashCode = 31 * hashCode + Objects.hashCode(decrypt());
        hashCode = 31 * hashCode + Objects.hashCode(wrap());
        hashCode = 31 * hashCode + Objects.hashCode(unwrap());
        hashCode = 31 * hashCode + Objects.hashCode(generate());
        hashCode = 31 * hashCode + Objects.hashCode(sign());
        hashCode = 31 * hashCode + Objects.hashCode(verify());
        hashCode = 31 * hashCode + Objects.hashCode(deriveKey());
        hashCode = 31 * hashCode + Objects.hashCode(noRestrictions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KeyModesOfUse)) {
            return false;
        }
        KeyModesOfUse other = (KeyModesOfUse) obj;
        return Objects.equals(encrypt(), other.encrypt()) && Objects.equals(decrypt(), other.decrypt())
                && Objects.equals(wrap(), other.wrap()) && Objects.equals(unwrap(), other.unwrap())
                && Objects.equals(generate(), other.generate()) && Objects.equals(sign(), other.sign())
                && Objects.equals(verify(), other.verify()) && Objects.equals(deriveKey(), other.deriveKey())
                && Objects.equals(noRestrictions(), other.noRestrictions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KeyModesOfUse").add("Encrypt", encrypt()).add("Decrypt", decrypt()).add("Wrap", wrap())
                .add("Unwrap", unwrap()).add("Generate", generate()).add("Sign", sign()).add("Verify", verify())
                .add("DeriveKey", deriveKey()).add("NoRestrictions", noRestrictions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Encrypt":
            return Optional.ofNullable(clazz.cast(encrypt()));
        case "Decrypt":
            return Optional.ofNullable(clazz.cast(decrypt()));
        case "Wrap":
            return Optional.ofNullable(clazz.cast(wrap()));
        case "Unwrap":
            return Optional.ofNullable(clazz.cast(unwrap()));
        case "Generate":
            return Optional.ofNullable(clazz.cast(generate()));
        case "Sign":
            return Optional.ofNullable(clazz.cast(sign()));
        case "Verify":
            return Optional.ofNullable(clazz.cast(verify()));
        case "DeriveKey":
            return Optional.ofNullable(clazz.cast(deriveKey()));
        case "NoRestrictions":
            return Optional.ofNullable(clazz.cast(noRestrictions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Encrypt", ENCRYPT_FIELD);
        map.put("Decrypt", DECRYPT_FIELD);
        map.put("Wrap", WRAP_FIELD);
        map.put("Unwrap", UNWRAP_FIELD);
        map.put("Generate", GENERATE_FIELD);
        map.put("Sign", SIGN_FIELD);
        map.put("Verify", VERIFY_FIELD);
        map.put("DeriveKey", DERIVE_KEY_FIELD);
        map.put("NoRestrictions", NO_RESTRICTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KeyModesOfUse, T> g) {
        return obj -> g.apply((KeyModesOfUse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KeyModesOfUse> {
        /**
         * <p>
         * Speciﬁes whether an Amazon Web Services Payment Cryptography key can be used to encrypt data.
         * </p>
         * 
         * @param encrypt
         *        Speciﬁes whether an Amazon Web Services Payment Cryptography key can be used to encrypt data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encrypt(Boolean encrypt);

        /**
         * <p>
         * Speciﬁes whether an Amazon Web Services Payment Cryptography key can be used to decrypt data.
         * </p>
         * 
         * @param decrypt
         *        Speciﬁes whether an Amazon Web Services Payment Cryptography key can be used to decrypt data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder decrypt(Boolean decrypt);

        /**
         * <p>
         * Speciﬁes whether an Amazon Web Services Payment Cryptography key can be used to wrap other keys.
         * </p>
         * 
         * @param wrap
         *        Speciﬁes whether an Amazon Web Services Payment Cryptography key can be used to wrap other keys.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder wrap(Boolean wrap);

        /**
         * <p>
         * Speciﬁes whether an Amazon Web Services Payment Cryptography key can be used to unwrap other keys.
         * </p>
         * 
         * @param unwrap
         *        Speciﬁes whether an Amazon Web Services Payment Cryptography key can be used to unwrap other keys.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unwrap(Boolean unwrap);

        /**
         * <p>
         * Speciﬁes whether an Amazon Web Services Payment Cryptography key can be used to generate and verify other
         * card and PIN verification keys.
         * </p>
         * 
         * @param generate
         *        Speciﬁes whether an Amazon Web Services Payment Cryptography key can be used to generate and verify
         *        other card and PIN verification keys.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generate(Boolean generate);

        /**
         * <p>
         * Speciﬁes whether an Amazon Web Services Payment Cryptography key can be used for signing.
         * </p>
         * 
         * @param sign
         *        Speciﬁes whether an Amazon Web Services Payment Cryptography key can be used for signing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sign(Boolean sign);

        /**
         * <p>
         * Speciﬁes whether an Amazon Web Services Payment Cryptography key can be used to verify signatures.
         * </p>
         * 
         * @param verify
         *        Speciﬁes whether an Amazon Web Services Payment Cryptography key can be used to verify signatures.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verify(Boolean verify);

        /**
         * <p>
         * Speciﬁes whether an Amazon Web Services Payment Cryptography key can be used to derive new keys.
         * </p>
         * 
         * @param deriveKey
         *        Speciﬁes whether an Amazon Web Services Payment Cryptography key can be used to derive new keys.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deriveKey(Boolean deriveKey);

        /**
         * <p>
         * Speciﬁes whether an Amazon Web Services Payment Cryptography key has no special restrictions other than the
         * restrictions implied by <code>KeyUsage</code>.
         * </p>
         * 
         * @param noRestrictions
         *        Speciﬁes whether an Amazon Web Services Payment Cryptography key has no special restrictions other
         *        than the restrictions implied by <code>KeyUsage</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder noRestrictions(Boolean noRestrictions);
    }

    static final class BuilderImpl implements Builder {
        private Boolean encrypt;

        private Boolean decrypt;

        private Boolean wrap;

        private Boolean unwrap;

        private Boolean generate;

        private Boolean sign;

        private Boolean verify;

        private Boolean deriveKey;

        private Boolean noRestrictions;

        private BuilderImpl() {
        }

        private BuilderImpl(KeyModesOfUse model) {
            encrypt(model.encrypt);
            decrypt(model.decrypt);
            wrap(model.wrap);
            unwrap(model.unwrap);
            generate(model.generate);
            sign(model.sign);
            verify(model.verify);
            deriveKey(model.deriveKey);
            noRestrictions(model.noRestrictions);
        }

        public final Boolean getEncrypt() {
            return encrypt;
        }

        public final void setEncrypt(Boolean encrypt) {
            this.encrypt = encrypt;
        }

        @Override
        public final Builder encrypt(Boolean encrypt) {
            this.encrypt = encrypt;
            return this;
        }

        public final Boolean getDecrypt() {
            return decrypt;
        }

        public final void setDecrypt(Boolean decrypt) {
            this.decrypt = decrypt;
        }

        @Override
        public final Builder decrypt(Boolean decrypt) {
            this.decrypt = decrypt;
            return this;
        }

        public final Boolean getWrap() {
            return wrap;
        }

        public final void setWrap(Boolean wrap) {
            this.wrap = wrap;
        }

        @Override
        public final Builder wrap(Boolean wrap) {
            this.wrap = wrap;
            return this;
        }

        public final Boolean getUnwrap() {
            return unwrap;
        }

        public final void setUnwrap(Boolean unwrap) {
            this.unwrap = unwrap;
        }

        @Override
        public final Builder unwrap(Boolean unwrap) {
            this.unwrap = unwrap;
            return this;
        }

        public final Boolean getGenerate() {
            return generate;
        }

        public final void setGenerate(Boolean generate) {
            this.generate = generate;
        }

        @Override
        public final Builder generate(Boolean generate) {
            this.generate = generate;
            return this;
        }

        public final Boolean getSign() {
            return sign;
        }

        public final void setSign(Boolean sign) {
            this.sign = sign;
        }

        @Override
        public final Builder sign(Boolean sign) {
            this.sign = sign;
            return this;
        }

        public final Boolean getVerify() {
            return verify;
        }

        public final void setVerify(Boolean verify) {
            this.verify = verify;
        }

        @Override
        public final Builder verify(Boolean verify) {
            this.verify = verify;
            return this;
        }

        public final Boolean getDeriveKey() {
            return deriveKey;
        }

        public final void setDeriveKey(Boolean deriveKey) {
            this.deriveKey = deriveKey;
        }

        @Override
        public final Builder deriveKey(Boolean deriveKey) {
            this.deriveKey = deriveKey;
            return this;
        }

        public final Boolean getNoRestrictions() {
            return noRestrictions;
        }

        public final void setNoRestrictions(Boolean noRestrictions) {
            this.noRestrictions = noRestrictions;
        }

        @Override
        public final Builder noRestrictions(Boolean noRestrictions) {
            this.noRestrictions = noRestrictions;
            return this;
        }

        @Override
        public KeyModesOfUse build() {
            return new KeyModesOfUse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
