/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.paymentcryptography.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The metadata used to create the certificate signing request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CertificateSubjectType implements SdkPojo, Serializable,
        ToCopyableBuilder<CertificateSubjectType.Builder, CertificateSubjectType> {
    private static final SdkField<String> COMMON_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CommonName").getter(getter(CertificateSubjectType::commonName)).setter(setter(Builder::commonName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CommonName").build()).build();

    private static final SdkField<String> ORGANIZATION_UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OrganizationUnit").getter(getter(CertificateSubjectType::organizationUnit))
            .setter(setter(Builder::organizationUnit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationUnit").build()).build();

    private static final SdkField<String> ORGANIZATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Organization").getter(getter(CertificateSubjectType::organization))
            .setter(setter(Builder::organization))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Organization").build()).build();

    private static final SdkField<String> CITY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("City")
            .getter(getter(CertificateSubjectType::city)).setter(setter(Builder::city))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("City").build()).build();

    private static final SdkField<String> COUNTRY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Country")
            .getter(getter(CertificateSubjectType::country)).setter(setter(Builder::country))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Country").build()).build();

    private static final SdkField<String> STATE_OR_PROVINCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StateOrProvince").getter(getter(CertificateSubjectType::stateOrProvince))
            .setter(setter(Builder::stateOrProvince))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateOrProvince").build()).build();

    private static final SdkField<String> EMAIL_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EmailAddress").getter(getter(CertificateSubjectType::emailAddress))
            .setter(setter(Builder::emailAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailAddress").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(COMMON_NAME_FIELD, ORGANIZATION_UNIT_FIELD, ORGANIZATION_FIELD, CITY_FIELD,
                    COUNTRY_FIELD, STATE_OR_PROVINCE_FIELD, EMAIL_ADDRESS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String commonName;

    private final String organizationUnit;

    private final String organization;

    private final String city;

    private final String country;

    private final String stateOrProvince;

    private final String emailAddress;

    private CertificateSubjectType(BuilderImpl builder) {
        this.commonName = builder.commonName;
        this.organizationUnit = builder.organizationUnit;
        this.organization = builder.organization;
        this.city = builder.city;
        this.country = builder.country;
        this.stateOrProvince = builder.stateOrProvince;
        this.emailAddress = builder.emailAddress;
    }

    /**
     * <p>
     * The name you provide to create the certificate signing request.
     * </p>
     * 
     * @return The name you provide to create the certificate signing request.
     */
    public final String commonName() {
        return commonName;
    }

    /**
     * <p>
     * The organization unit you provide to create the certificate signing request.
     * </p>
     * 
     * @return The organization unit you provide to create the certificate signing request.
     */
    public final String organizationUnit() {
        return organizationUnit;
    }

    /**
     * <p>
     * The organization you provide to create the certificate signing request.
     * </p>
     * 
     * @return The organization you provide to create the certificate signing request.
     */
    public final String organization() {
        return organization;
    }

    /**
     * <p>
     * The city you provide to create the certificate signing request.
     * </p>
     * 
     * @return The city you provide to create the certificate signing request.
     */
    public final String city() {
        return city;
    }

    /**
     * <p>
     * The city you provide to create the certificate signing request.
     * </p>
     * 
     * @return The city you provide to create the certificate signing request.
     */
    public final String country() {
        return country;
    }

    /**
     * <p>
     * The state or province you provide to create the certificate signing request.
     * </p>
     * 
     * @return The state or province you provide to create the certificate signing request.
     */
    public final String stateOrProvince() {
        return stateOrProvince;
    }

    /**
     * <p>
     * The email address you provide to create the certificate signing request.
     * </p>
     * 
     * @return The email address you provide to create the certificate signing request.
     */
    public final String emailAddress() {
        return emailAddress;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(commonName());
        hashCode = 31 * hashCode + Objects.hashCode(organizationUnit());
        hashCode = 31 * hashCode + Objects.hashCode(organization());
        hashCode = 31 * hashCode + Objects.hashCode(city());
        hashCode = 31 * hashCode + Objects.hashCode(country());
        hashCode = 31 * hashCode + Objects.hashCode(stateOrProvince());
        hashCode = 31 * hashCode + Objects.hashCode(emailAddress());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CertificateSubjectType)) {
            return false;
        }
        CertificateSubjectType other = (CertificateSubjectType) obj;
        return Objects.equals(commonName(), other.commonName()) && Objects.equals(organizationUnit(), other.organizationUnit())
                && Objects.equals(organization(), other.organization()) && Objects.equals(city(), other.city())
                && Objects.equals(country(), other.country()) && Objects.equals(stateOrProvince(), other.stateOrProvince())
                && Objects.equals(emailAddress(), other.emailAddress());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CertificateSubjectType").add("CommonName", commonName())
                .add("OrganizationUnit", organizationUnit()).add("Organization", organization()).add("City", city())
                .add("Country", country()).add("StateOrProvince", stateOrProvince()).add("EmailAddress", emailAddress()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CommonName":
            return Optional.ofNullable(clazz.cast(commonName()));
        case "OrganizationUnit":
            return Optional.ofNullable(clazz.cast(organizationUnit()));
        case "Organization":
            return Optional.ofNullable(clazz.cast(organization()));
        case "City":
            return Optional.ofNullable(clazz.cast(city()));
        case "Country":
            return Optional.ofNullable(clazz.cast(country()));
        case "StateOrProvince":
            return Optional.ofNullable(clazz.cast(stateOrProvince()));
        case "EmailAddress":
            return Optional.ofNullable(clazz.cast(emailAddress()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CommonName", COMMON_NAME_FIELD);
        map.put("OrganizationUnit", ORGANIZATION_UNIT_FIELD);
        map.put("Organization", ORGANIZATION_FIELD);
        map.put("City", CITY_FIELD);
        map.put("Country", COUNTRY_FIELD);
        map.put("StateOrProvince", STATE_OR_PROVINCE_FIELD);
        map.put("EmailAddress", EMAIL_ADDRESS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CertificateSubjectType, T> g) {
        return obj -> g.apply((CertificateSubjectType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CertificateSubjectType> {
        /**
         * <p>
         * The name you provide to create the certificate signing request.
         * </p>
         * 
         * @param commonName
         *        The name you provide to create the certificate signing request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commonName(String commonName);

        /**
         * <p>
         * The organization unit you provide to create the certificate signing request.
         * </p>
         * 
         * @param organizationUnit
         *        The organization unit you provide to create the certificate signing request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationUnit(String organizationUnit);

        /**
         * <p>
         * The organization you provide to create the certificate signing request.
         * </p>
         * 
         * @param organization
         *        The organization you provide to create the certificate signing request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organization(String organization);

        /**
         * <p>
         * The city you provide to create the certificate signing request.
         * </p>
         * 
         * @param city
         *        The city you provide to create the certificate signing request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder city(String city);

        /**
         * <p>
         * The city you provide to create the certificate signing request.
         * </p>
         * 
         * @param country
         *        The city you provide to create the certificate signing request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder country(String country);

        /**
         * <p>
         * The state or province you provide to create the certificate signing request.
         * </p>
         * 
         * @param stateOrProvince
         *        The state or province you provide to create the certificate signing request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateOrProvince(String stateOrProvince);

        /**
         * <p>
         * The email address you provide to create the certificate signing request.
         * </p>
         * 
         * @param emailAddress
         *        The email address you provide to create the certificate signing request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailAddress(String emailAddress);
    }

    static final class BuilderImpl implements Builder {
        private String commonName;

        private String organizationUnit;

        private String organization;

        private String city;

        private String country;

        private String stateOrProvince;

        private String emailAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(CertificateSubjectType model) {
            commonName(model.commonName);
            organizationUnit(model.organizationUnit);
            organization(model.organization);
            city(model.city);
            country(model.country);
            stateOrProvince(model.stateOrProvince);
            emailAddress(model.emailAddress);
        }

        public final String getCommonName() {
            return commonName;
        }

        public final void setCommonName(String commonName) {
            this.commonName = commonName;
        }

        @Override
        public final Builder commonName(String commonName) {
            this.commonName = commonName;
            return this;
        }

        public final String getOrganizationUnit() {
            return organizationUnit;
        }

        public final void setOrganizationUnit(String organizationUnit) {
            this.organizationUnit = organizationUnit;
        }

        @Override
        public final Builder organizationUnit(String organizationUnit) {
            this.organizationUnit = organizationUnit;
            return this;
        }

        public final String getOrganization() {
            return organization;
        }

        public final void setOrganization(String organization) {
            this.organization = organization;
        }

        @Override
        public final Builder organization(String organization) {
            this.organization = organization;
            return this;
        }

        public final String getCity() {
            return city;
        }

        public final void setCity(String city) {
            this.city = city;
        }

        @Override
        public final Builder city(String city) {
            this.city = city;
            return this;
        }

        public final String getCountry() {
            return country;
        }

        public final void setCountry(String country) {
            this.country = country;
        }

        @Override
        public final Builder country(String country) {
            this.country = country;
            return this;
        }

        public final String getStateOrProvince() {
            return stateOrProvince;
        }

        public final void setStateOrProvince(String stateOrProvince) {
            this.stateOrProvince = stateOrProvince;
        }

        @Override
        public final Builder stateOrProvince(String stateOrProvince) {
            this.stateOrProvince = stateOrProvince;
            return this;
        }

        public final String getEmailAddress() {
            return emailAddress;
        }

        public final void setEmailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
        }

        @Override
        public final Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        @Override
        public CertificateSubjectType build() {
            return new CertificateSubjectType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
