/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptography.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.paymentcryptography.model.KeyAttributes;
import software.amazon.awssdk.services.paymentcryptography.model.WrappingKeySpec;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImportKeyCryptogram
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ImportKeyCryptogram> {
    private static final SdkField<KeyAttributes> KEY_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KeyAttributes").getter(ImportKeyCryptogram.getter(ImportKeyCryptogram::keyAttributes)).setter(ImportKeyCryptogram.setter(Builder::keyAttributes)).constructor(KeyAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyAttributes").build()}).build();
    private static final SdkField<Boolean> EXPORTABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Exportable").getter(ImportKeyCryptogram.getter(ImportKeyCryptogram::exportable)).setter(ImportKeyCryptogram.setter(Builder::exportable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Exportable").build()}).build();
    private static final SdkField<String> WRAPPED_KEY_CRYPTOGRAM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WrappedKeyCryptogram").getter(ImportKeyCryptogram.getter(ImportKeyCryptogram::wrappedKeyCryptogram)).setter(ImportKeyCryptogram.setter(Builder::wrappedKeyCryptogram)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WrappedKeyCryptogram").build()}).build();
    private static final SdkField<String> IMPORT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImportToken").getter(ImportKeyCryptogram.getter(ImportKeyCryptogram::importToken)).setter(ImportKeyCryptogram.setter(Builder::importToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportToken").build()}).build();
    private static final SdkField<String> WRAPPING_SPEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WrappingSpec").getter(ImportKeyCryptogram.getter(ImportKeyCryptogram::wrappingSpecAsString)).setter(ImportKeyCryptogram.setter(Builder::wrappingSpec)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WrappingSpec").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_ATTRIBUTES_FIELD, EXPORTABLE_FIELD, WRAPPED_KEY_CRYPTOGRAM_FIELD, IMPORT_TOKEN_FIELD, WRAPPING_SPEC_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ImportKeyCryptogram.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final KeyAttributes keyAttributes;
    private final Boolean exportable;
    private final String wrappedKeyCryptogram;
    private final String importToken;
    private final String wrappingSpec;

    private ImportKeyCryptogram(BuilderImpl builder) {
        this.keyAttributes = builder.keyAttributes;
        this.exportable = builder.exportable;
        this.wrappedKeyCryptogram = builder.wrappedKeyCryptogram;
        this.importToken = builder.importToken;
        this.wrappingSpec = builder.wrappingSpec;
    }

    public final KeyAttributes keyAttributes() {
        return this.keyAttributes;
    }

    public final Boolean exportable() {
        return this.exportable;
    }

    public final String wrappedKeyCryptogram() {
        return this.wrappedKeyCryptogram;
    }

    public final String importToken() {
        return this.importToken;
    }

    public final WrappingKeySpec wrappingSpec() {
        return WrappingKeySpec.fromValue(this.wrappingSpec);
    }

    public final String wrappingSpecAsString() {
        return this.wrappingSpec;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.keyAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportable());
        hashCode = 31 * hashCode + Objects.hashCode(this.wrappedKeyCryptogram());
        hashCode = 31 * hashCode + Objects.hashCode(this.importToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.wrappingSpecAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportKeyCryptogram)) {
            return false;
        }
        ImportKeyCryptogram other = (ImportKeyCryptogram)obj;
        return Objects.equals(this.keyAttributes(), other.keyAttributes()) && Objects.equals(this.exportable(), other.exportable()) && Objects.equals(this.wrappedKeyCryptogram(), other.wrappedKeyCryptogram()) && Objects.equals(this.importToken(), other.importToken()) && Objects.equals(this.wrappingSpecAsString(), other.wrappingSpecAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ImportKeyCryptogram").add("KeyAttributes", (Object)this.keyAttributes()).add("Exportable", (Object)this.exportable()).add("WrappedKeyCryptogram", (Object)(this.wrappedKeyCryptogram() == null ? null : "*** Sensitive Data Redacted ***")).add("ImportToken", (Object)this.importToken()).add("WrappingSpec", (Object)this.wrappingSpecAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyAttributes": {
                return Optional.ofNullable(clazz.cast(this.keyAttributes()));
            }
            case "Exportable": {
                return Optional.ofNullable(clazz.cast(this.exportable()));
            }
            case "WrappedKeyCryptogram": {
                return Optional.ofNullable(clazz.cast(this.wrappedKeyCryptogram()));
            }
            case "ImportToken": {
                return Optional.ofNullable(clazz.cast(this.importToken()));
            }
            case "WrappingSpec": {
                return Optional.ofNullable(clazz.cast(this.wrappingSpecAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("KeyAttributes", KEY_ATTRIBUTES_FIELD);
        map.put("Exportable", EXPORTABLE_FIELD);
        map.put("WrappedKeyCryptogram", WRAPPED_KEY_CRYPTOGRAM_FIELD);
        map.put("ImportToken", IMPORT_TOKEN_FIELD);
        map.put("WrappingSpec", WRAPPING_SPEC_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImportKeyCryptogram, T> g) {
        return obj -> g.apply((ImportKeyCryptogram)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private KeyAttributes keyAttributes;
        private Boolean exportable;
        private String wrappedKeyCryptogram;
        private String importToken;
        private String wrappingSpec;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportKeyCryptogram model) {
            this.keyAttributes(model.keyAttributes);
            this.exportable(model.exportable);
            this.wrappedKeyCryptogram(model.wrappedKeyCryptogram);
            this.importToken(model.importToken);
            this.wrappingSpec(model.wrappingSpec);
        }

        public final KeyAttributes.Builder getKeyAttributes() {
            return this.keyAttributes != null ? this.keyAttributes.toBuilder() : null;
        }

        public final void setKeyAttributes(KeyAttributes.BuilderImpl keyAttributes) {
            this.keyAttributes = keyAttributes != null ? keyAttributes.build() : null;
        }

        @Override
        public final Builder keyAttributes(KeyAttributes keyAttributes) {
            this.keyAttributes = keyAttributes;
            return this;
        }

        public final Boolean getExportable() {
            return this.exportable;
        }

        public final void setExportable(Boolean exportable) {
            this.exportable = exportable;
        }

        @Override
        public final Builder exportable(Boolean exportable) {
            this.exportable = exportable;
            return this;
        }

        public final String getWrappedKeyCryptogram() {
            return this.wrappedKeyCryptogram;
        }

        public final void setWrappedKeyCryptogram(String wrappedKeyCryptogram) {
            this.wrappedKeyCryptogram = wrappedKeyCryptogram;
        }

        @Override
        public final Builder wrappedKeyCryptogram(String wrappedKeyCryptogram) {
            this.wrappedKeyCryptogram = wrappedKeyCryptogram;
            return this;
        }

        public final String getImportToken() {
            return this.importToken;
        }

        public final void setImportToken(String importToken) {
            this.importToken = importToken;
        }

        @Override
        public final Builder importToken(String importToken) {
            this.importToken = importToken;
            return this;
        }

        public final String getWrappingSpec() {
            return this.wrappingSpec;
        }

        public final void setWrappingSpec(String wrappingSpec) {
            this.wrappingSpec = wrappingSpec;
        }

        @Override
        public final Builder wrappingSpec(String wrappingSpec) {
            this.wrappingSpec = wrappingSpec;
            return this;
        }

        @Override
        public final Builder wrappingSpec(WrappingKeySpec wrappingSpec) {
            this.wrappingSpec(wrappingSpec == null ? null : wrappingSpec.toString());
            return this;
        }

        public ImportKeyCryptogram build() {
            return new ImportKeyCryptogram(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ImportKeyCryptogram> {
        public Builder keyAttributes(KeyAttributes var1);

        default public Builder keyAttributes(Consumer<KeyAttributes.Builder> keyAttributes) {
            return this.keyAttributes((KeyAttributes)((KeyAttributes.Builder)KeyAttributes.builder().applyMutation(keyAttributes)).build());
        }

        public Builder exportable(Boolean var1);

        public Builder wrappedKeyCryptogram(String var1);

        public Builder importToken(String var1);

        public Builder wrappingSpec(String var1);

        public Builder wrappingSpec(WrappingKeySpec var1);
    }
}

