/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptography.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.paymentcryptography.model.KeyBlockHeaders;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExportTr31KeyBlock
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExportTr31KeyBlock> {
    private static final SdkField<String> WRAPPING_KEY_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WrappingKeyIdentifier").getter(ExportTr31KeyBlock.getter(ExportTr31KeyBlock::wrappingKeyIdentifier)).setter(ExportTr31KeyBlock.setter(Builder::wrappingKeyIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WrappingKeyIdentifier").build()}).build();
    private static final SdkField<KeyBlockHeaders> KEY_BLOCK_HEADERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KeyBlockHeaders").getter(ExportTr31KeyBlock.getter(ExportTr31KeyBlock::keyBlockHeaders)).setter(ExportTr31KeyBlock.setter(Builder::keyBlockHeaders)).constructor(KeyBlockHeaders::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyBlockHeaders").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WRAPPING_KEY_IDENTIFIER_FIELD, KEY_BLOCK_HEADERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ExportTr31KeyBlock.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String wrappingKeyIdentifier;
    private final KeyBlockHeaders keyBlockHeaders;

    private ExportTr31KeyBlock(BuilderImpl builder) {
        this.wrappingKeyIdentifier = builder.wrappingKeyIdentifier;
        this.keyBlockHeaders = builder.keyBlockHeaders;
    }

    public final String wrappingKeyIdentifier() {
        return this.wrappingKeyIdentifier;
    }

    public final KeyBlockHeaders keyBlockHeaders() {
        return this.keyBlockHeaders;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.wrappingKeyIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyBlockHeaders());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportTr31KeyBlock)) {
            return false;
        }
        ExportTr31KeyBlock other = (ExportTr31KeyBlock)obj;
        return Objects.equals(this.wrappingKeyIdentifier(), other.wrappingKeyIdentifier()) && Objects.equals(this.keyBlockHeaders(), other.keyBlockHeaders());
    }

    public final String toString() {
        return ToString.builder((String)"ExportTr31KeyBlock").add("WrappingKeyIdentifier", (Object)this.wrappingKeyIdentifier()).add("KeyBlockHeaders", (Object)this.keyBlockHeaders()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WrappingKeyIdentifier": {
                return Optional.ofNullable(clazz.cast(this.wrappingKeyIdentifier()));
            }
            case "KeyBlockHeaders": {
                return Optional.ofNullable(clazz.cast(this.keyBlockHeaders()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("WrappingKeyIdentifier", WRAPPING_KEY_IDENTIFIER_FIELD);
        map.put("KeyBlockHeaders", KEY_BLOCK_HEADERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExportTr31KeyBlock, T> g) {
        return obj -> g.apply((ExportTr31KeyBlock)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String wrappingKeyIdentifier;
        private KeyBlockHeaders keyBlockHeaders;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportTr31KeyBlock model) {
            this.wrappingKeyIdentifier(model.wrappingKeyIdentifier);
            this.keyBlockHeaders(model.keyBlockHeaders);
        }

        public final String getWrappingKeyIdentifier() {
            return this.wrappingKeyIdentifier;
        }

        public final void setWrappingKeyIdentifier(String wrappingKeyIdentifier) {
            this.wrappingKeyIdentifier = wrappingKeyIdentifier;
        }

        @Override
        public final Builder wrappingKeyIdentifier(String wrappingKeyIdentifier) {
            this.wrappingKeyIdentifier = wrappingKeyIdentifier;
            return this;
        }

        public final KeyBlockHeaders.Builder getKeyBlockHeaders() {
            return this.keyBlockHeaders != null ? this.keyBlockHeaders.toBuilder() : null;
        }

        public final void setKeyBlockHeaders(KeyBlockHeaders.BuilderImpl keyBlockHeaders) {
            this.keyBlockHeaders = keyBlockHeaders != null ? keyBlockHeaders.build() : null;
        }

        @Override
        public final Builder keyBlockHeaders(KeyBlockHeaders keyBlockHeaders) {
            this.keyBlockHeaders = keyBlockHeaders;
            return this;
        }

        public ExportTr31KeyBlock build() {
            return new ExportTr31KeyBlock(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExportTr31KeyBlock> {
        public Builder wrappingKeyIdentifier(String var1);

        public Builder keyBlockHeaders(KeyBlockHeaders var1);

        default public Builder keyBlockHeaders(Consumer<KeyBlockHeaders.Builder> keyBlockHeaders) {
            return this.keyBlockHeaders((KeyBlockHeaders)((KeyBlockHeaders.Builder)KeyBlockHeaders.builder().applyMutation(keyBlockHeaders)).build());
        }
    }
}

