/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptography.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum KeyAlgorithm {
    TDES_2_KEY("TDES_2KEY"),
    TDES_3_KEY("TDES_3KEY"),
    AES_128("AES_128"),
    AES_192("AES_192"),
    AES_256("AES_256"),
    RSA_2048("RSA_2048"),
    RSA_3072("RSA_3072"),
    RSA_4096("RSA_4096"),
    ECC_NIST_P256("ECC_NIST_P256"),
    ECC_NIST_P384("ECC_NIST_P384"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, KeyAlgorithm> VALUE_MAP;
    private final String value;

    private KeyAlgorithm(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static KeyAlgorithm fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<KeyAlgorithm> knownValues() {
        EnumSet<KeyAlgorithm> knownValues = EnumSet.allOf(KeyAlgorithm.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(KeyAlgorithm.class, KeyAlgorithm::toString);
    }
}

