/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptography.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.paymentcryptography.PaymentCryptographyClient;
import software.amazon.awssdk.services.paymentcryptography.internal.UserAgentUtils;
import software.amazon.awssdk.services.paymentcryptography.model.Alias;
import software.amazon.awssdk.services.paymentcryptography.model.ListAliasesRequest;
import software.amazon.awssdk.services.paymentcryptography.model.ListAliasesResponse;

public class ListAliasesIterable
implements SdkIterable<ListAliasesResponse> {
    private final PaymentCryptographyClient client;
    private final ListAliasesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAliasesIterable(PaymentCryptographyClient client, ListAliasesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAliasesResponseFetcher();
    }

    public Iterator<ListAliasesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Alias> aliases() {
        Function<ListAliasesResponse, Iterator> getIterator = response -> {
            if (response != null && response.aliases() != null) {
                return response.aliases().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAliasesResponseFetcher
    implements SyncPageFetcher<ListAliasesResponse> {
        private ListAliasesResponseFetcher() {
        }

        public boolean hasNextPage(ListAliasesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAliasesResponse nextPage(ListAliasesResponse previousPage) {
            if (previousPage == null) {
                return ListAliasesIterable.this.client.listAliases(ListAliasesIterable.this.firstRequest);
            }
            return ListAliasesIterable.this.client.listAliases((ListAliasesRequest)((Object)ListAliasesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

