/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptography.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.paymentcryptography.model.KeyAlgorithm;
import software.amazon.awssdk.services.paymentcryptography.model.KeyMaterialType;
import software.amazon.awssdk.services.paymentcryptography.model.PaymentCryptographyRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetParametersForExportRequest
extends PaymentCryptographyRequest
implements ToCopyableBuilder<Builder, GetParametersForExportRequest> {
    private static final SdkField<String> KEY_MATERIAL_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyMaterialType").getter(GetParametersForExportRequest.getter(GetParametersForExportRequest::keyMaterialTypeAsString)).setter(GetParametersForExportRequest.setter(Builder::keyMaterialType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyMaterialType").build()}).build();
    private static final SdkField<String> SIGNING_KEY_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SigningKeyAlgorithm").getter(GetParametersForExportRequest.getter(GetParametersForExportRequest::signingKeyAlgorithmAsString)).setter(GetParametersForExportRequest.setter(Builder::signingKeyAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SigningKeyAlgorithm").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_MATERIAL_TYPE_FIELD, SIGNING_KEY_ALGORITHM_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("KeyMaterialType", KEY_MATERIAL_TYPE_FIELD);
            this.put("SigningKeyAlgorithm", SIGNING_KEY_ALGORITHM_FIELD);
        }
    });
    private final String keyMaterialType;
    private final String signingKeyAlgorithm;

    private GetParametersForExportRequest(BuilderImpl builder) {
        super(builder);
        this.keyMaterialType = builder.keyMaterialType;
        this.signingKeyAlgorithm = builder.signingKeyAlgorithm;
    }

    public final KeyMaterialType keyMaterialType() {
        return KeyMaterialType.fromValue(this.keyMaterialType);
    }

    public final String keyMaterialTypeAsString() {
        return this.keyMaterialType;
    }

    public final KeyAlgorithm signingKeyAlgorithm() {
        return KeyAlgorithm.fromValue(this.signingKeyAlgorithm);
    }

    public final String signingKeyAlgorithmAsString() {
        return this.signingKeyAlgorithm;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.keyMaterialTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.signingKeyAlgorithmAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetParametersForExportRequest)) {
            return false;
        }
        GetParametersForExportRequest other = (GetParametersForExportRequest)((Object)obj);
        return Objects.equals(this.keyMaterialTypeAsString(), other.keyMaterialTypeAsString()) && Objects.equals(this.signingKeyAlgorithmAsString(), other.signingKeyAlgorithmAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetParametersForExportRequest").add("KeyMaterialType", (Object)this.keyMaterialTypeAsString()).add("SigningKeyAlgorithm", (Object)this.signingKeyAlgorithmAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyMaterialType": {
                return Optional.ofNullable(clazz.cast(this.keyMaterialTypeAsString()));
            }
            case "SigningKeyAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.signingKeyAlgorithmAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetParametersForExportRequest, T> g) {
        return obj -> g.apply((GetParametersForExportRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PaymentCryptographyRequest.BuilderImpl
    implements Builder {
        private String keyMaterialType;
        private String signingKeyAlgorithm;

        private BuilderImpl() {
        }

        private BuilderImpl(GetParametersForExportRequest model) {
            super(model);
            this.keyMaterialType(model.keyMaterialType);
            this.signingKeyAlgorithm(model.signingKeyAlgorithm);
        }

        public final String getKeyMaterialType() {
            return this.keyMaterialType;
        }

        public final void setKeyMaterialType(String keyMaterialType) {
            this.keyMaterialType = keyMaterialType;
        }

        @Override
        public final Builder keyMaterialType(String keyMaterialType) {
            this.keyMaterialType = keyMaterialType;
            return this;
        }

        @Override
        public final Builder keyMaterialType(KeyMaterialType keyMaterialType) {
            this.keyMaterialType(keyMaterialType == null ? null : keyMaterialType.toString());
            return this;
        }

        public final String getSigningKeyAlgorithm() {
            return this.signingKeyAlgorithm;
        }

        public final void setSigningKeyAlgorithm(String signingKeyAlgorithm) {
            this.signingKeyAlgorithm = signingKeyAlgorithm;
        }

        @Override
        public final Builder signingKeyAlgorithm(String signingKeyAlgorithm) {
            this.signingKeyAlgorithm = signingKeyAlgorithm;
            return this;
        }

        @Override
        public final Builder signingKeyAlgorithm(KeyAlgorithm signingKeyAlgorithm) {
            this.signingKeyAlgorithm(signingKeyAlgorithm == null ? null : signingKeyAlgorithm.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetParametersForExportRequest build() {
            return new GetParametersForExportRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PaymentCryptographyRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetParametersForExportRequest> {
        public Builder keyMaterialType(String var1);

        public Builder keyMaterialType(KeyMaterialType var1);

        public Builder signingKeyAlgorithm(String var1);

        public Builder signingKeyAlgorithm(KeyAlgorithm var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

