/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptography.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum KeyExportability {
    EXPORTABLE("EXPORTABLE"),
    NON_EXPORTABLE("NON_EXPORTABLE"),
    SENSITIVE("SENSITIVE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, KeyExportability> VALUE_MAP;
    private final String value;

    private KeyExportability(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static KeyExportability fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<KeyExportability> knownValues() {
        EnumSet<KeyExportability> knownValues = EnumSet.allOf(KeyExportability.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(KeyExportability.class, KeyExportability::toString);
    }
}

