/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptography.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.paymentcryptography.model.KeyCheckValueAlgorithm;
import software.amazon.awssdk.services.paymentcryptography.model.WrappedKeyMaterialFormat;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WrappedKey
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WrappedKey> {
    private static final SdkField<String> KEY_CHECK_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyCheckValue").getter(WrappedKey.getter(WrappedKey::keyCheckValue)).setter(WrappedKey.setter(Builder::keyCheckValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyCheckValue").build()}).build();
    private static final SdkField<String> KEY_CHECK_VALUE_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyCheckValueAlgorithm").getter(WrappedKey.getter(WrappedKey::keyCheckValueAlgorithmAsString)).setter(WrappedKey.setter(Builder::keyCheckValueAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyCheckValueAlgorithm").build()}).build();
    private static final SdkField<String> KEY_MATERIAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyMaterial").getter(WrappedKey.getter(WrappedKey::keyMaterial)).setter(WrappedKey.setter(Builder::keyMaterial)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyMaterial").build()}).build();
    private static final SdkField<String> WRAPPED_KEY_MATERIAL_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WrappedKeyMaterialFormat").getter(WrappedKey.getter(WrappedKey::wrappedKeyMaterialFormatAsString)).setter(WrappedKey.setter(Builder::wrappedKeyMaterialFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WrappedKeyMaterialFormat").build()}).build();
    private static final SdkField<String> WRAPPING_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WrappingKeyArn").getter(WrappedKey.getter(WrappedKey::wrappingKeyArn)).setter(WrappedKey.setter(Builder::wrappingKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WrappingKeyArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_CHECK_VALUE_FIELD, KEY_CHECK_VALUE_ALGORITHM_FIELD, KEY_MATERIAL_FIELD, WRAPPED_KEY_MATERIAL_FORMAT_FIELD, WRAPPING_KEY_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String keyCheckValue;
    private final String keyCheckValueAlgorithm;
    private final String keyMaterial;
    private final String wrappedKeyMaterialFormat;
    private final String wrappingKeyArn;

    private WrappedKey(BuilderImpl builder) {
        this.keyCheckValue = builder.keyCheckValue;
        this.keyCheckValueAlgorithm = builder.keyCheckValueAlgorithm;
        this.keyMaterial = builder.keyMaterial;
        this.wrappedKeyMaterialFormat = builder.wrappedKeyMaterialFormat;
        this.wrappingKeyArn = builder.wrappingKeyArn;
    }

    public final String keyCheckValue() {
        return this.keyCheckValue;
    }

    public final KeyCheckValueAlgorithm keyCheckValueAlgorithm() {
        return KeyCheckValueAlgorithm.fromValue(this.keyCheckValueAlgorithm);
    }

    public final String keyCheckValueAlgorithmAsString() {
        return this.keyCheckValueAlgorithm;
    }

    public final String keyMaterial() {
        return this.keyMaterial;
    }

    public final WrappedKeyMaterialFormat wrappedKeyMaterialFormat() {
        return WrappedKeyMaterialFormat.fromValue(this.wrappedKeyMaterialFormat);
    }

    public final String wrappedKeyMaterialFormatAsString() {
        return this.wrappedKeyMaterialFormat;
    }

    public final String wrappingKeyArn() {
        return this.wrappingKeyArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.keyCheckValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyCheckValueAlgorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyMaterial());
        hashCode = 31 * hashCode + Objects.hashCode(this.wrappedKeyMaterialFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.wrappingKeyArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WrappedKey)) {
            return false;
        }
        WrappedKey other = (WrappedKey)obj;
        return Objects.equals(this.keyCheckValue(), other.keyCheckValue()) && Objects.equals(this.keyCheckValueAlgorithmAsString(), other.keyCheckValueAlgorithmAsString()) && Objects.equals(this.keyMaterial(), other.keyMaterial()) && Objects.equals(this.wrappedKeyMaterialFormatAsString(), other.wrappedKeyMaterialFormatAsString()) && Objects.equals(this.wrappingKeyArn(), other.wrappingKeyArn());
    }

    public final String toString() {
        return ToString.builder((String)"WrappedKey").add("KeyCheckValue", (Object)this.keyCheckValue()).add("KeyCheckValueAlgorithm", (Object)this.keyCheckValueAlgorithmAsString()).add("KeyMaterial", (Object)(this.keyMaterial() == null ? null : "*** Sensitive Data Redacted ***")).add("WrappedKeyMaterialFormat", (Object)this.wrappedKeyMaterialFormatAsString()).add("WrappingKeyArn", (Object)this.wrappingKeyArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyCheckValue": {
                return Optional.ofNullable(clazz.cast(this.keyCheckValue()));
            }
            case "KeyCheckValueAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.keyCheckValueAlgorithmAsString()));
            }
            case "KeyMaterial": {
                return Optional.ofNullable(clazz.cast(this.keyMaterial()));
            }
            case "WrappedKeyMaterialFormat": {
                return Optional.ofNullable(clazz.cast(this.wrappedKeyMaterialFormatAsString()));
            }
            case "WrappingKeyArn": {
                return Optional.ofNullable(clazz.cast(this.wrappingKeyArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WrappedKey, T> g) {
        return obj -> g.apply((WrappedKey)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String keyCheckValue;
        private String keyCheckValueAlgorithm;
        private String keyMaterial;
        private String wrappedKeyMaterialFormat;
        private String wrappingKeyArn;

        private BuilderImpl() {
        }

        private BuilderImpl(WrappedKey model) {
            this.keyCheckValue(model.keyCheckValue);
            this.keyCheckValueAlgorithm(model.keyCheckValueAlgorithm);
            this.keyMaterial(model.keyMaterial);
            this.wrappedKeyMaterialFormat(model.wrappedKeyMaterialFormat);
            this.wrappingKeyArn(model.wrappingKeyArn);
        }

        public final String getKeyCheckValue() {
            return this.keyCheckValue;
        }

        public final void setKeyCheckValue(String keyCheckValue) {
            this.keyCheckValue = keyCheckValue;
        }

        @Override
        public final Builder keyCheckValue(String keyCheckValue) {
            this.keyCheckValue = keyCheckValue;
            return this;
        }

        public final String getKeyCheckValueAlgorithm() {
            return this.keyCheckValueAlgorithm;
        }

        public final void setKeyCheckValueAlgorithm(String keyCheckValueAlgorithm) {
            this.keyCheckValueAlgorithm = keyCheckValueAlgorithm;
        }

        @Override
        public final Builder keyCheckValueAlgorithm(String keyCheckValueAlgorithm) {
            this.keyCheckValueAlgorithm = keyCheckValueAlgorithm;
            return this;
        }

        @Override
        public final Builder keyCheckValueAlgorithm(KeyCheckValueAlgorithm keyCheckValueAlgorithm) {
            this.keyCheckValueAlgorithm(keyCheckValueAlgorithm == null ? null : keyCheckValueAlgorithm.toString());
            return this;
        }

        public final String getKeyMaterial() {
            return this.keyMaterial;
        }

        public final void setKeyMaterial(String keyMaterial) {
            this.keyMaterial = keyMaterial;
        }

        @Override
        public final Builder keyMaterial(String keyMaterial) {
            this.keyMaterial = keyMaterial;
            return this;
        }

        public final String getWrappedKeyMaterialFormat() {
            return this.wrappedKeyMaterialFormat;
        }

        public final void setWrappedKeyMaterialFormat(String wrappedKeyMaterialFormat) {
            this.wrappedKeyMaterialFormat = wrappedKeyMaterialFormat;
        }

        @Override
        public final Builder wrappedKeyMaterialFormat(String wrappedKeyMaterialFormat) {
            this.wrappedKeyMaterialFormat = wrappedKeyMaterialFormat;
            return this;
        }

        @Override
        public final Builder wrappedKeyMaterialFormat(WrappedKeyMaterialFormat wrappedKeyMaterialFormat) {
            this.wrappedKeyMaterialFormat(wrappedKeyMaterialFormat == null ? null : wrappedKeyMaterialFormat.toString());
            return this;
        }

        public final String getWrappingKeyArn() {
            return this.wrappingKeyArn;
        }

        public final void setWrappingKeyArn(String wrappingKeyArn) {
            this.wrappingKeyArn = wrappingKeyArn;
        }

        @Override
        public final Builder wrappingKeyArn(String wrappingKeyArn) {
            this.wrappingKeyArn = wrappingKeyArn;
            return this;
        }

        public WrappedKey build() {
            return new WrappedKey(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WrappedKey> {
        public Builder keyCheckValue(String var1);

        public Builder keyCheckValueAlgorithm(String var1);

        public Builder keyCheckValueAlgorithm(KeyCheckValueAlgorithm var1);

        public Builder keyMaterial(String var1);

        public Builder wrappedKeyMaterialFormat(String var1);

        public Builder wrappedKeyMaterialFormat(WrappedKeyMaterialFormat var1);

        public Builder wrappingKeyArn(String var1);
    }
}

