/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptography.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.paymentcryptography.model.KeyAlgorithm;
import software.amazon.awssdk.services.paymentcryptography.model.KeyClass;
import software.amazon.awssdk.services.paymentcryptography.model.KeyModesOfUse;
import software.amazon.awssdk.services.paymentcryptography.model.KeyUsage;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KeyAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KeyAttributes> {
    private static final SdkField<String> KEY_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyAlgorithm").getter(KeyAttributes.getter(KeyAttributes::keyAlgorithmAsString)).setter(KeyAttributes.setter(Builder::keyAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyAlgorithm").build()}).build();
    private static final SdkField<String> KEY_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyClass").getter(KeyAttributes.getter(KeyAttributes::keyClassAsString)).setter(KeyAttributes.setter(Builder::keyClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyClass").build()}).build();
    private static final SdkField<KeyModesOfUse> KEY_MODES_OF_USE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KeyModesOfUse").getter(KeyAttributes.getter(KeyAttributes::keyModesOfUse)).setter(KeyAttributes.setter(Builder::keyModesOfUse)).constructor(KeyModesOfUse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyModesOfUse").build()}).build();
    private static final SdkField<String> KEY_USAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyUsage").getter(KeyAttributes.getter(KeyAttributes::keyUsageAsString)).setter(KeyAttributes.setter(Builder::keyUsage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyUsage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_ALGORITHM_FIELD, KEY_CLASS_FIELD, KEY_MODES_OF_USE_FIELD, KEY_USAGE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String keyAlgorithm;
    private final String keyClass;
    private final KeyModesOfUse keyModesOfUse;
    private final String keyUsage;

    private KeyAttributes(BuilderImpl builder) {
        this.keyAlgorithm = builder.keyAlgorithm;
        this.keyClass = builder.keyClass;
        this.keyModesOfUse = builder.keyModesOfUse;
        this.keyUsage = builder.keyUsage;
    }

    public final KeyAlgorithm keyAlgorithm() {
        return KeyAlgorithm.fromValue(this.keyAlgorithm);
    }

    public final String keyAlgorithmAsString() {
        return this.keyAlgorithm;
    }

    public final KeyClass keyClass() {
        return KeyClass.fromValue(this.keyClass);
    }

    public final String keyClassAsString() {
        return this.keyClass;
    }

    public final KeyModesOfUse keyModesOfUse() {
        return this.keyModesOfUse;
    }

    public final KeyUsage keyUsage() {
        return KeyUsage.fromValue(this.keyUsage);
    }

    public final String keyUsageAsString() {
        return this.keyUsage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.keyAlgorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyClassAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyModesOfUse());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyUsageAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KeyAttributes)) {
            return false;
        }
        KeyAttributes other = (KeyAttributes)obj;
        return Objects.equals(this.keyAlgorithmAsString(), other.keyAlgorithmAsString()) && Objects.equals(this.keyClassAsString(), other.keyClassAsString()) && Objects.equals(this.keyModesOfUse(), other.keyModesOfUse()) && Objects.equals(this.keyUsageAsString(), other.keyUsageAsString());
    }

    public final String toString() {
        return ToString.builder((String)"KeyAttributes").add("KeyAlgorithm", (Object)this.keyAlgorithmAsString()).add("KeyClass", (Object)this.keyClassAsString()).add("KeyModesOfUse", (Object)this.keyModesOfUse()).add("KeyUsage", (Object)this.keyUsageAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.keyAlgorithmAsString()));
            }
            case "KeyClass": {
                return Optional.ofNullable(clazz.cast(this.keyClassAsString()));
            }
            case "KeyModesOfUse": {
                return Optional.ofNullable(clazz.cast(this.keyModesOfUse()));
            }
            case "KeyUsage": {
                return Optional.ofNullable(clazz.cast(this.keyUsageAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KeyAttributes, T> g) {
        return obj -> g.apply((KeyAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String keyAlgorithm;
        private String keyClass;
        private KeyModesOfUse keyModesOfUse;
        private String keyUsage;

        private BuilderImpl() {
        }

        private BuilderImpl(KeyAttributes model) {
            this.keyAlgorithm(model.keyAlgorithm);
            this.keyClass(model.keyClass);
            this.keyModesOfUse(model.keyModesOfUse);
            this.keyUsage(model.keyUsage);
        }

        public final String getKeyAlgorithm() {
            return this.keyAlgorithm;
        }

        public final void setKeyAlgorithm(String keyAlgorithm) {
            this.keyAlgorithm = keyAlgorithm;
        }

        @Override
        public final Builder keyAlgorithm(String keyAlgorithm) {
            this.keyAlgorithm = keyAlgorithm;
            return this;
        }

        @Override
        public final Builder keyAlgorithm(KeyAlgorithm keyAlgorithm) {
            this.keyAlgorithm(keyAlgorithm == null ? null : keyAlgorithm.toString());
            return this;
        }

        public final String getKeyClass() {
            return this.keyClass;
        }

        public final void setKeyClass(String keyClass) {
            this.keyClass = keyClass;
        }

        @Override
        public final Builder keyClass(String keyClass) {
            this.keyClass = keyClass;
            return this;
        }

        @Override
        public final Builder keyClass(KeyClass keyClass) {
            this.keyClass(keyClass == null ? null : keyClass.toString());
            return this;
        }

        public final KeyModesOfUse.Builder getKeyModesOfUse() {
            return this.keyModesOfUse != null ? this.keyModesOfUse.toBuilder() : null;
        }

        public final void setKeyModesOfUse(KeyModesOfUse.BuilderImpl keyModesOfUse) {
            this.keyModesOfUse = keyModesOfUse != null ? keyModesOfUse.build() : null;
        }

        @Override
        public final Builder keyModesOfUse(KeyModesOfUse keyModesOfUse) {
            this.keyModesOfUse = keyModesOfUse;
            return this;
        }

        public final String getKeyUsage() {
            return this.keyUsage;
        }

        public final void setKeyUsage(String keyUsage) {
            this.keyUsage = keyUsage;
        }

        @Override
        public final Builder keyUsage(String keyUsage) {
            this.keyUsage = keyUsage;
            return this;
        }

        @Override
        public final Builder keyUsage(KeyUsage keyUsage) {
            this.keyUsage(keyUsage == null ? null : keyUsage.toString());
            return this;
        }

        public KeyAttributes build() {
            return new KeyAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KeyAttributes> {
        public Builder keyAlgorithm(String var1);

        public Builder keyAlgorithm(KeyAlgorithm var1);

        public Builder keyClass(String var1);

        public Builder keyClass(KeyClass var1);

        public Builder keyModesOfUse(KeyModesOfUse var1);

        default public Builder keyModesOfUse(Consumer<KeyModesOfUse.Builder> keyModesOfUse) {
            return this.keyModesOfUse((KeyModesOfUse)((KeyModesOfUse.Builder)KeyModesOfUse.builder().applyMutation(keyModesOfUse)).build());
        }

        public Builder keyUsage(String var1);

        public Builder keyUsage(KeyUsage var1);
    }
}

