/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptography.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.paymentcryptography.model.KeyAttributes;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TrustedCertificatePublicKey
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TrustedCertificatePublicKey> {
    private static final SdkField<String> CERTIFICATE_AUTHORITY_PUBLIC_KEY_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CertificateAuthorityPublicKeyIdentifier").getter(TrustedCertificatePublicKey.getter(TrustedCertificatePublicKey::certificateAuthorityPublicKeyIdentifier)).setter(TrustedCertificatePublicKey.setter(Builder::certificateAuthorityPublicKeyIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateAuthorityPublicKeyIdentifier").build()}).build();
    private static final SdkField<KeyAttributes> KEY_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KeyAttributes").getter(TrustedCertificatePublicKey.getter(TrustedCertificatePublicKey::keyAttributes)).setter(TrustedCertificatePublicKey.setter(Builder::keyAttributes)).constructor(KeyAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyAttributes").build()}).build();
    private static final SdkField<String> PUBLIC_KEY_CERTIFICATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PublicKeyCertificate").getter(TrustedCertificatePublicKey.getter(TrustedCertificatePublicKey::publicKeyCertificate)).setter(TrustedCertificatePublicKey.setter(Builder::publicKeyCertificate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicKeyCertificate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_AUTHORITY_PUBLIC_KEY_IDENTIFIER_FIELD, KEY_ATTRIBUTES_FIELD, PUBLIC_KEY_CERTIFICATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String certificateAuthorityPublicKeyIdentifier;
    private final KeyAttributes keyAttributes;
    private final String publicKeyCertificate;

    private TrustedCertificatePublicKey(BuilderImpl builder) {
        this.certificateAuthorityPublicKeyIdentifier = builder.certificateAuthorityPublicKeyIdentifier;
        this.keyAttributes = builder.keyAttributes;
        this.publicKeyCertificate = builder.publicKeyCertificate;
    }

    public final String certificateAuthorityPublicKeyIdentifier() {
        return this.certificateAuthorityPublicKeyIdentifier;
    }

    public final KeyAttributes keyAttributes() {
        return this.keyAttributes;
    }

    public final String publicKeyCertificate() {
        return this.publicKeyCertificate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateAuthorityPublicKeyIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicKeyCertificate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrustedCertificatePublicKey)) {
            return false;
        }
        TrustedCertificatePublicKey other = (TrustedCertificatePublicKey)obj;
        return Objects.equals(this.certificateAuthorityPublicKeyIdentifier(), other.certificateAuthorityPublicKeyIdentifier()) && Objects.equals(this.keyAttributes(), other.keyAttributes()) && Objects.equals(this.publicKeyCertificate(), other.publicKeyCertificate());
    }

    public final String toString() {
        return ToString.builder((String)"TrustedCertificatePublicKey").add("CertificateAuthorityPublicKeyIdentifier", (Object)this.certificateAuthorityPublicKeyIdentifier()).add("KeyAttributes", (Object)this.keyAttributes()).add("PublicKeyCertificate", (Object)(this.publicKeyCertificate() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CertificateAuthorityPublicKeyIdentifier": {
                return Optional.ofNullable(clazz.cast(this.certificateAuthorityPublicKeyIdentifier()));
            }
            case "KeyAttributes": {
                return Optional.ofNullable(clazz.cast(this.keyAttributes()));
            }
            case "PublicKeyCertificate": {
                return Optional.ofNullable(clazz.cast(this.publicKeyCertificate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TrustedCertificatePublicKey, T> g) {
        return obj -> g.apply((TrustedCertificatePublicKey)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String certificateAuthorityPublicKeyIdentifier;
        private KeyAttributes keyAttributes;
        private String publicKeyCertificate;

        private BuilderImpl() {
        }

        private BuilderImpl(TrustedCertificatePublicKey model) {
            this.certificateAuthorityPublicKeyIdentifier(model.certificateAuthorityPublicKeyIdentifier);
            this.keyAttributes(model.keyAttributes);
            this.publicKeyCertificate(model.publicKeyCertificate);
        }

        public final String getCertificateAuthorityPublicKeyIdentifier() {
            return this.certificateAuthorityPublicKeyIdentifier;
        }

        public final void setCertificateAuthorityPublicKeyIdentifier(String certificateAuthorityPublicKeyIdentifier) {
            this.certificateAuthorityPublicKeyIdentifier = certificateAuthorityPublicKeyIdentifier;
        }

        @Override
        public final Builder certificateAuthorityPublicKeyIdentifier(String certificateAuthorityPublicKeyIdentifier) {
            this.certificateAuthorityPublicKeyIdentifier = certificateAuthorityPublicKeyIdentifier;
            return this;
        }

        public final KeyAttributes.Builder getKeyAttributes() {
            return this.keyAttributes != null ? this.keyAttributes.toBuilder() : null;
        }

        public final void setKeyAttributes(KeyAttributes.BuilderImpl keyAttributes) {
            this.keyAttributes = keyAttributes != null ? keyAttributes.build() : null;
        }

        @Override
        public final Builder keyAttributes(KeyAttributes keyAttributes) {
            this.keyAttributes = keyAttributes;
            return this;
        }

        public final String getPublicKeyCertificate() {
            return this.publicKeyCertificate;
        }

        public final void setPublicKeyCertificate(String publicKeyCertificate) {
            this.publicKeyCertificate = publicKeyCertificate;
        }

        @Override
        public final Builder publicKeyCertificate(String publicKeyCertificate) {
            this.publicKeyCertificate = publicKeyCertificate;
            return this;
        }

        public TrustedCertificatePublicKey build() {
            return new TrustedCertificatePublicKey(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TrustedCertificatePublicKey> {
        public Builder certificateAuthorityPublicKeyIdentifier(String var1);

        public Builder keyAttributes(KeyAttributes var1);

        default public Builder keyAttributes(Consumer<KeyAttributes.Builder> keyAttributes) {
            return this.keyAttributes((KeyAttributes)((KeyAttributes.Builder)KeyAttributes.builder().applyMutation(keyAttributes)).build());
        }

        public Builder publicKeyCertificate(String var1);
    }
}

