/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.outposts.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.outposts.model.BlockingResourceType;
import software.amazon.awssdk.services.outposts.model.BlockingResourceTypeListCopier;
import software.amazon.awssdk.services.outposts.model.DecommissionRequestStatus;
import software.amazon.awssdk.services.outposts.model.OutpostsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartOutpostDecommissionResponse
extends OutpostsResponse
implements ToCopyableBuilder<Builder, StartOutpostDecommissionResponse> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(StartOutpostDecommissionResponse.getter(StartOutpostDecommissionResponse::statusAsString)).setter(StartOutpostDecommissionResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<List<String>> BLOCKING_RESOURCE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BlockingResourceTypes").getter(StartOutpostDecommissionResponse.getter(StartOutpostDecommissionResponse::blockingResourceTypesAsStrings)).setter(StartOutpostDecommissionResponse.setter(Builder::blockingResourceTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockingResourceTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, BLOCKING_RESOURCE_TYPES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartOutpostDecommissionResponse.memberNameToFieldInitializer();
    private final String status;
    private final List<String> blockingResourceTypes;

    private StartOutpostDecommissionResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.blockingResourceTypes = builder.blockingResourceTypes;
    }

    public final DecommissionRequestStatus status() {
        return DecommissionRequestStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final List<BlockingResourceType> blockingResourceTypes() {
        return BlockingResourceTypeListCopier.copyStringToEnum(this.blockingResourceTypes);
    }

    public final boolean hasBlockingResourceTypes() {
        return this.blockingResourceTypes != null && !(this.blockingResourceTypes instanceof SdkAutoConstructList);
    }

    public final List<String> blockingResourceTypesAsStrings() {
        return this.blockingResourceTypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBlockingResourceTypes() ? this.blockingResourceTypesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartOutpostDecommissionResponse)) {
            return false;
        }
        StartOutpostDecommissionResponse other = (StartOutpostDecommissionResponse)((Object)obj);
        return Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasBlockingResourceTypes() == other.hasBlockingResourceTypes() && Objects.equals(this.blockingResourceTypesAsStrings(), other.blockingResourceTypesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"StartOutpostDecommissionResponse").add("Status", (Object)this.statusAsString()).add("BlockingResourceTypes", this.hasBlockingResourceTypes() ? this.blockingResourceTypesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "BlockingResourceTypes": {
                return Optional.ofNullable(clazz.cast(this.blockingResourceTypesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Status", STATUS_FIELD);
        map.put("BlockingResourceTypes", BLOCKING_RESOURCE_TYPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartOutpostDecommissionResponse, T> g) {
        return obj -> g.apply((StartOutpostDecommissionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OutpostsResponse.BuilderImpl
    implements Builder {
        private String status;
        private List<String> blockingResourceTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartOutpostDecommissionResponse model) {
            super(model);
            this.status(model.status);
            this.blockingResourceTypesWithStrings(model.blockingResourceTypes);
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DecommissionRequestStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Collection<String> getBlockingResourceTypes() {
            if (this.blockingResourceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.blockingResourceTypes;
        }

        public final void setBlockingResourceTypes(Collection<String> blockingResourceTypes) {
            this.blockingResourceTypes = BlockingResourceTypeListCopier.copy(blockingResourceTypes);
        }

        @Override
        public final Builder blockingResourceTypesWithStrings(Collection<String> blockingResourceTypes) {
            this.blockingResourceTypes = BlockingResourceTypeListCopier.copy(blockingResourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockingResourceTypesWithStrings(String ... blockingResourceTypes) {
            this.blockingResourceTypesWithStrings(Arrays.asList(blockingResourceTypes));
            return this;
        }

        @Override
        public final Builder blockingResourceTypes(Collection<BlockingResourceType> blockingResourceTypes) {
            this.blockingResourceTypes = BlockingResourceTypeListCopier.copyEnumToString(blockingResourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockingResourceTypes(BlockingResourceType ... blockingResourceTypes) {
            this.blockingResourceTypes(Arrays.asList(blockingResourceTypes));
            return this;
        }

        @Override
        public StartOutpostDecommissionResponse build() {
            return new StartOutpostDecommissionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends OutpostsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartOutpostDecommissionResponse> {
        public Builder status(String var1);

        public Builder status(DecommissionRequestStatus var1);

        public Builder blockingResourceTypesWithStrings(Collection<String> var1);

        public Builder blockingResourceTypesWithStrings(String ... var1);

        public Builder blockingResourceTypes(Collection<BlockingResourceType> var1);

        public Builder blockingResourceTypes(BlockingResourceType ... var1);
    }
}

