/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.outposts.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.outposts.model.AWSServiceName;
import software.amazon.awssdk.services.outposts.model.AWSServiceNameListCopier;
import software.amazon.awssdk.services.outposts.model.AccountIdListCopier;
import software.amazon.awssdk.services.outposts.model.AssetIdListCopier;
import software.amazon.awssdk.services.outposts.model.OutpostInstanceTypeListCopier;
import software.amazon.awssdk.services.outposts.model.OutpostsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAssetInstancesRequest
extends OutpostsRequest
implements ToCopyableBuilder<Builder, ListAssetInstancesRequest> {
    private static final SdkField<String> OUTPOST_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutpostIdentifier").getter(ListAssetInstancesRequest.getter(ListAssetInstancesRequest::outpostIdentifier)).setter(ListAssetInstancesRequest.setter(Builder::outpostIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("OutpostId").build()}).build();
    private static final SdkField<List<String>> ASSET_ID_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AssetIdFilter").getter(ListAssetInstancesRequest.getter(ListAssetInstancesRequest::assetIdFilter)).setter(ListAssetInstancesRequest.setter(Builder::assetIdFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("AssetIdFilter").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> INSTANCE_TYPE_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InstanceTypeFilter").getter(ListAssetInstancesRequest.getter(ListAssetInstancesRequest::instanceTypeFilter)).setter(ListAssetInstancesRequest.setter(Builder::instanceTypeFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("InstanceTypeFilter").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ACCOUNT_ID_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AccountIdFilter").getter(ListAssetInstancesRequest.getter(ListAssetInstancesRequest::accountIdFilter)).setter(ListAssetInstancesRequest.setter(Builder::accountIdFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("AccountIdFilter").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> AWS_SERVICE_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AwsServiceFilter").getter(ListAssetInstancesRequest.getter(ListAssetInstancesRequest::awsServiceFilterAsStrings)).setter(ListAssetInstancesRequest.setter(Builder::awsServiceFilterWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("AwsServiceFilter").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListAssetInstancesRequest.getter(ListAssetInstancesRequest::maxResults)).setter(ListAssetInstancesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListAssetInstancesRequest.getter(ListAssetInstancesRequest::nextToken)).setter(ListAssetInstancesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPOST_IDENTIFIER_FIELD, ASSET_ID_FILTER_FIELD, INSTANCE_TYPE_FILTER_FIELD, ACCOUNT_ID_FILTER_FIELD, AWS_SERVICE_FILTER_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListAssetInstancesRequest.memberNameToFieldInitializer();
    private final String outpostIdentifier;
    private final List<String> assetIdFilter;
    private final List<String> instanceTypeFilter;
    private final List<String> accountIdFilter;
    private final List<String> awsServiceFilter;
    private final Integer maxResults;
    private final String nextToken;

    private ListAssetInstancesRequest(BuilderImpl builder) {
        super(builder);
        this.outpostIdentifier = builder.outpostIdentifier;
        this.assetIdFilter = builder.assetIdFilter;
        this.instanceTypeFilter = builder.instanceTypeFilter;
        this.accountIdFilter = builder.accountIdFilter;
        this.awsServiceFilter = builder.awsServiceFilter;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final String outpostIdentifier() {
        return this.outpostIdentifier;
    }

    public final boolean hasAssetIdFilter() {
        return this.assetIdFilter != null && !(this.assetIdFilter instanceof SdkAutoConstructList);
    }

    public final List<String> assetIdFilter() {
        return this.assetIdFilter;
    }

    public final boolean hasInstanceTypeFilter() {
        return this.instanceTypeFilter != null && !(this.instanceTypeFilter instanceof SdkAutoConstructList);
    }

    public final List<String> instanceTypeFilter() {
        return this.instanceTypeFilter;
    }

    public final boolean hasAccountIdFilter() {
        return this.accountIdFilter != null && !(this.accountIdFilter instanceof SdkAutoConstructList);
    }

    public final List<String> accountIdFilter() {
        return this.accountIdFilter;
    }

    public final List<AWSServiceName> awsServiceFilter() {
        return AWSServiceNameListCopier.copyStringToEnum(this.awsServiceFilter);
    }

    public final boolean hasAwsServiceFilter() {
        return this.awsServiceFilter != null && !(this.awsServiceFilter instanceof SdkAutoConstructList);
    }

    public final List<String> awsServiceFilterAsStrings() {
        return this.awsServiceFilter;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.outpostIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssetIdFilter() ? this.assetIdFilter() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceTypeFilter() ? this.instanceTypeFilter() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccountIdFilter() ? this.accountIdFilter() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAwsServiceFilter() ? this.awsServiceFilterAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAssetInstancesRequest)) {
            return false;
        }
        ListAssetInstancesRequest other = (ListAssetInstancesRequest)((Object)obj);
        return Objects.equals(this.outpostIdentifier(), other.outpostIdentifier()) && this.hasAssetIdFilter() == other.hasAssetIdFilter() && Objects.equals(this.assetIdFilter(), other.assetIdFilter()) && this.hasInstanceTypeFilter() == other.hasInstanceTypeFilter() && Objects.equals(this.instanceTypeFilter(), other.instanceTypeFilter()) && this.hasAccountIdFilter() == other.hasAccountIdFilter() && Objects.equals(this.accountIdFilter(), other.accountIdFilter()) && this.hasAwsServiceFilter() == other.hasAwsServiceFilter() && Objects.equals(this.awsServiceFilterAsStrings(), other.awsServiceFilterAsStrings()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAssetInstancesRequest").add("OutpostIdentifier", (Object)this.outpostIdentifier()).add("AssetIdFilter", this.hasAssetIdFilter() ? this.assetIdFilter() : null).add("InstanceTypeFilter", this.hasInstanceTypeFilter() ? this.instanceTypeFilter() : null).add("AccountIdFilter", this.hasAccountIdFilter() ? this.accountIdFilter() : null).add("AwsServiceFilter", this.hasAwsServiceFilter() ? this.awsServiceFilterAsStrings() : null).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OutpostIdentifier": {
                return Optional.ofNullable(clazz.cast(this.outpostIdentifier()));
            }
            case "AssetIdFilter": {
                return Optional.ofNullable(clazz.cast(this.assetIdFilter()));
            }
            case "InstanceTypeFilter": {
                return Optional.ofNullable(clazz.cast(this.instanceTypeFilter()));
            }
            case "AccountIdFilter": {
                return Optional.ofNullable(clazz.cast(this.accountIdFilter()));
            }
            case "AwsServiceFilter": {
                return Optional.ofNullable(clazz.cast(this.awsServiceFilterAsStrings()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("OutpostId", OUTPOST_IDENTIFIER_FIELD);
        map.put("AssetIdFilter", ASSET_ID_FILTER_FIELD);
        map.put("InstanceTypeFilter", INSTANCE_TYPE_FILTER_FIELD);
        map.put("AccountIdFilter", ACCOUNT_ID_FILTER_FIELD);
        map.put("AwsServiceFilter", AWS_SERVICE_FILTER_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAssetInstancesRequest, T> g) {
        return obj -> g.apply((ListAssetInstancesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OutpostsRequest.BuilderImpl
    implements Builder {
        private String outpostIdentifier;
        private List<String> assetIdFilter = DefaultSdkAutoConstructList.getInstance();
        private List<String> instanceTypeFilter = DefaultSdkAutoConstructList.getInstance();
        private List<String> accountIdFilter = DefaultSdkAutoConstructList.getInstance();
        private List<String> awsServiceFilter = DefaultSdkAutoConstructList.getInstance();
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAssetInstancesRequest model) {
            super(model);
            this.outpostIdentifier(model.outpostIdentifier);
            this.assetIdFilter(model.assetIdFilter);
            this.instanceTypeFilter(model.instanceTypeFilter);
            this.accountIdFilter(model.accountIdFilter);
            this.awsServiceFilterWithStrings(model.awsServiceFilter);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getOutpostIdentifier() {
            return this.outpostIdentifier;
        }

        public final void setOutpostIdentifier(String outpostIdentifier) {
            this.outpostIdentifier = outpostIdentifier;
        }

        @Override
        public final Builder outpostIdentifier(String outpostIdentifier) {
            this.outpostIdentifier = outpostIdentifier;
            return this;
        }

        public final Collection<String> getAssetIdFilter() {
            if (this.assetIdFilter instanceof SdkAutoConstructList) {
                return null;
            }
            return this.assetIdFilter;
        }

        public final void setAssetIdFilter(Collection<String> assetIdFilter) {
            this.assetIdFilter = AssetIdListCopier.copy(assetIdFilter);
        }

        @Override
        public final Builder assetIdFilter(Collection<String> assetIdFilter) {
            this.assetIdFilter = AssetIdListCopier.copy(assetIdFilter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetIdFilter(String ... assetIdFilter) {
            this.assetIdFilter(Arrays.asList(assetIdFilter));
            return this;
        }

        public final Collection<String> getInstanceTypeFilter() {
            if (this.instanceTypeFilter instanceof SdkAutoConstructList) {
                return null;
            }
            return this.instanceTypeFilter;
        }

        public final void setInstanceTypeFilter(Collection<String> instanceTypeFilter) {
            this.instanceTypeFilter = OutpostInstanceTypeListCopier.copy(instanceTypeFilter);
        }

        @Override
        public final Builder instanceTypeFilter(Collection<String> instanceTypeFilter) {
            this.instanceTypeFilter = OutpostInstanceTypeListCopier.copy(instanceTypeFilter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceTypeFilter(String ... instanceTypeFilter) {
            this.instanceTypeFilter(Arrays.asList(instanceTypeFilter));
            return this;
        }

        public final Collection<String> getAccountIdFilter() {
            if (this.accountIdFilter instanceof SdkAutoConstructList) {
                return null;
            }
            return this.accountIdFilter;
        }

        public final void setAccountIdFilter(Collection<String> accountIdFilter) {
            this.accountIdFilter = AccountIdListCopier.copy(accountIdFilter);
        }

        @Override
        public final Builder accountIdFilter(Collection<String> accountIdFilter) {
            this.accountIdFilter = AccountIdListCopier.copy(accountIdFilter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIdFilter(String ... accountIdFilter) {
            this.accountIdFilter(Arrays.asList(accountIdFilter));
            return this;
        }

        public final Collection<String> getAwsServiceFilter() {
            if (this.awsServiceFilter instanceof SdkAutoConstructList) {
                return null;
            }
            return this.awsServiceFilter;
        }

        public final void setAwsServiceFilter(Collection<String> awsServiceFilter) {
            this.awsServiceFilter = AWSServiceNameListCopier.copy(awsServiceFilter);
        }

        @Override
        public final Builder awsServiceFilterWithStrings(Collection<String> awsServiceFilter) {
            this.awsServiceFilter = AWSServiceNameListCopier.copy(awsServiceFilter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder awsServiceFilterWithStrings(String ... awsServiceFilter) {
            this.awsServiceFilterWithStrings(Arrays.asList(awsServiceFilter));
            return this;
        }

        @Override
        public final Builder awsServiceFilter(Collection<AWSServiceName> awsServiceFilter) {
            this.awsServiceFilter = AWSServiceNameListCopier.copyEnumToString(awsServiceFilter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder awsServiceFilter(AWSServiceName ... awsServiceFilter) {
            this.awsServiceFilter(Arrays.asList(awsServiceFilter));
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAssetInstancesRequest build() {
            return new ListAssetInstancesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends OutpostsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAssetInstancesRequest> {
        public Builder outpostIdentifier(String var1);

        public Builder assetIdFilter(Collection<String> var1);

        public Builder assetIdFilter(String ... var1);

        public Builder instanceTypeFilter(Collection<String> var1);

        public Builder instanceTypeFilter(String ... var1);

        public Builder accountIdFilter(Collection<String> var1);

        public Builder accountIdFilter(String ... var1);

        public Builder awsServiceFilterWithStrings(Collection<String> var1);

        public Builder awsServiceFilterWithStrings(String ... var1);

        public Builder awsServiceFilter(Collection<AWSServiceName> var1);

        public Builder awsServiceFilter(AWSServiceName ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

