/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.outposts.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.outposts.model.MacAddressListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LineItemAssetInformation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LineItemAssetInformation> {
    private static final SdkField<String> ASSET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssetId").getter(LineItemAssetInformation.getter(LineItemAssetInformation::assetId)).setter(LineItemAssetInformation.setter(Builder::assetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssetId").build()}).build();
    private static final SdkField<List<String>> MAC_ADDRESS_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MacAddressList").getter(LineItemAssetInformation.getter(LineItemAssetInformation::macAddressList)).setter(LineItemAssetInformation.setter(Builder::macAddressList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MacAddressList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_ID_FIELD, MAC_ADDRESS_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LineItemAssetInformation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String assetId;
    private final List<String> macAddressList;

    private LineItemAssetInformation(BuilderImpl builder) {
        this.assetId = builder.assetId;
        this.macAddressList = builder.macAddressList;
    }

    public final String assetId() {
        return this.assetId;
    }

    public final boolean hasMacAddressList() {
        return this.macAddressList != null && !(this.macAddressList instanceof SdkAutoConstructList);
    }

    public final List<String> macAddressList() {
        return this.macAddressList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.assetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMacAddressList() ? this.macAddressList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LineItemAssetInformation)) {
            return false;
        }
        LineItemAssetInformation other = (LineItemAssetInformation)obj;
        return Objects.equals(this.assetId(), other.assetId()) && this.hasMacAddressList() == other.hasMacAddressList() && Objects.equals(this.macAddressList(), other.macAddressList());
    }

    public final String toString() {
        return ToString.builder((String)"LineItemAssetInformation").add("AssetId", (Object)this.assetId()).add("MacAddressList", this.hasMacAddressList() ? this.macAddressList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssetId": {
                return Optional.ofNullable(clazz.cast(this.assetId()));
            }
            case "MacAddressList": {
                return Optional.ofNullable(clazz.cast(this.macAddressList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AssetId", ASSET_ID_FIELD);
        map.put("MacAddressList", MAC_ADDRESS_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LineItemAssetInformation, T> g) {
        return obj -> g.apply((LineItemAssetInformation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String assetId;
        private List<String> macAddressList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LineItemAssetInformation model) {
            this.assetId(model.assetId);
            this.macAddressList(model.macAddressList);
        }

        public final String getAssetId() {
            return this.assetId;
        }

        public final void setAssetId(String assetId) {
            this.assetId = assetId;
        }

        @Override
        public final Builder assetId(String assetId) {
            this.assetId = assetId;
            return this;
        }

        public final Collection<String> getMacAddressList() {
            if (this.macAddressList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.macAddressList;
        }

        public final void setMacAddressList(Collection<String> macAddressList) {
            this.macAddressList = MacAddressListCopier.copy(macAddressList);
        }

        @Override
        public final Builder macAddressList(Collection<String> macAddressList) {
            this.macAddressList = MacAddressListCopier.copy(macAddressList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder macAddressList(String ... macAddressList) {
            this.macAddressList(Arrays.asList(macAddressList));
            return this;
        }

        public LineItemAssetInformation build() {
            return new LineItemAssetInformation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LineItemAssetInformation> {
        public Builder assetId(String var1);

        public Builder macAddressList(Collection<String> var1);

        public Builder macAddressList(String ... var1);
    }
}

