/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.outposts.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.outposts.model.CapacityTaskStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CapacityTaskSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CapacityTaskSummary> {
    private static final SdkField<String> CAPACITY_TASK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CapacityTaskId").getter(CapacityTaskSummary.getter(CapacityTaskSummary::capacityTaskId)).setter(CapacityTaskSummary.setter(Builder::capacityTaskId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityTaskId").build()}).build();
    private static final SdkField<String> OUTPOST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutpostId").getter(CapacityTaskSummary.getter(CapacityTaskSummary::outpostId)).setter(CapacityTaskSummary.setter(Builder::outpostId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutpostId").build()}).build();
    private static final SdkField<String> ORDER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OrderId").getter(CapacityTaskSummary.getter(CapacityTaskSummary::orderId)).setter(CapacityTaskSummary.setter(Builder::orderId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrderId").build()}).build();
    private static final SdkField<String> ASSET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssetId").getter(CapacityTaskSummary.getter(CapacityTaskSummary::assetId)).setter(CapacityTaskSummary.setter(Builder::assetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssetId").build()}).build();
    private static final SdkField<String> CAPACITY_TASK_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CapacityTaskStatus").getter(CapacityTaskSummary.getter(CapacityTaskSummary::capacityTaskStatusAsString)).setter(CapacityTaskSummary.setter(Builder::capacityTaskStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityTaskStatus").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationDate").getter(CapacityTaskSummary.getter(CapacityTaskSummary::creationDate)).setter(CapacityTaskSummary.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()}).build();
    private static final SdkField<Instant> COMPLETION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CompletionDate").getter(CapacityTaskSummary.getter(CapacityTaskSummary::completionDate)).setter(CapacityTaskSummary.setter(Builder::completionDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionDate").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedDate").getter(CapacityTaskSummary.getter(CapacityTaskSummary::lastModifiedDate)).setter(CapacityTaskSummary.setter(Builder::lastModifiedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_TASK_ID_FIELD, OUTPOST_ID_FIELD, ORDER_ID_FIELD, ASSET_ID_FIELD, CAPACITY_TASK_STATUS_FIELD, CREATION_DATE_FIELD, COMPLETION_DATE_FIELD, LAST_MODIFIED_DATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CapacityTaskSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String capacityTaskId;
    private final String outpostId;
    private final String orderId;
    private final String assetId;
    private final String capacityTaskStatus;
    private final Instant creationDate;
    private final Instant completionDate;
    private final Instant lastModifiedDate;

    private CapacityTaskSummary(BuilderImpl builder) {
        this.capacityTaskId = builder.capacityTaskId;
        this.outpostId = builder.outpostId;
        this.orderId = builder.orderId;
        this.assetId = builder.assetId;
        this.capacityTaskStatus = builder.capacityTaskStatus;
        this.creationDate = builder.creationDate;
        this.completionDate = builder.completionDate;
        this.lastModifiedDate = builder.lastModifiedDate;
    }

    public final String capacityTaskId() {
        return this.capacityTaskId;
    }

    public final String outpostId() {
        return this.outpostId;
    }

    public final String orderId() {
        return this.orderId;
    }

    public final String assetId() {
        return this.assetId;
    }

    public final CapacityTaskStatus capacityTaskStatus() {
        return CapacityTaskStatus.fromValue(this.capacityTaskStatus);
    }

    public final String capacityTaskStatusAsString() {
        return this.capacityTaskStatus;
    }

    public final Instant creationDate() {
        return this.creationDate;
    }

    public final Instant completionDate() {
        return this.completionDate;
    }

    public final Instant lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityTaskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.outpostId());
        hashCode = 31 * hashCode + Objects.hashCode(this.orderId());
        hashCode = 31 * hashCode + Objects.hashCode(this.assetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityTaskStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.completionDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CapacityTaskSummary)) {
            return false;
        }
        CapacityTaskSummary other = (CapacityTaskSummary)obj;
        return Objects.equals(this.capacityTaskId(), other.capacityTaskId()) && Objects.equals(this.outpostId(), other.outpostId()) && Objects.equals(this.orderId(), other.orderId()) && Objects.equals(this.assetId(), other.assetId()) && Objects.equals(this.capacityTaskStatusAsString(), other.capacityTaskStatusAsString()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.completionDate(), other.completionDate()) && Objects.equals(this.lastModifiedDate(), other.lastModifiedDate());
    }

    public final String toString() {
        return ToString.builder((String)"CapacityTaskSummary").add("CapacityTaskId", (Object)this.capacityTaskId()).add("OutpostId", (Object)this.outpostId()).add("OrderId", (Object)this.orderId()).add("AssetId", (Object)this.assetId()).add("CapacityTaskStatus", (Object)this.capacityTaskStatusAsString()).add("CreationDate", (Object)this.creationDate()).add("CompletionDate", (Object)this.completionDate()).add("LastModifiedDate", (Object)this.lastModifiedDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CapacityTaskId": {
                return Optional.ofNullable(clazz.cast(this.capacityTaskId()));
            }
            case "OutpostId": {
                return Optional.ofNullable(clazz.cast(this.outpostId()));
            }
            case "OrderId": {
                return Optional.ofNullable(clazz.cast(this.orderId()));
            }
            case "AssetId": {
                return Optional.ofNullable(clazz.cast(this.assetId()));
            }
            case "CapacityTaskStatus": {
                return Optional.ofNullable(clazz.cast(this.capacityTaskStatusAsString()));
            }
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "CompletionDate": {
                return Optional.ofNullable(clazz.cast(this.completionDate()));
            }
            case "LastModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CapacityTaskId", CAPACITY_TASK_ID_FIELD);
        map.put("OutpostId", OUTPOST_ID_FIELD);
        map.put("OrderId", ORDER_ID_FIELD);
        map.put("AssetId", ASSET_ID_FIELD);
        map.put("CapacityTaskStatus", CAPACITY_TASK_STATUS_FIELD);
        map.put("CreationDate", CREATION_DATE_FIELD);
        map.put("CompletionDate", COMPLETION_DATE_FIELD);
        map.put("LastModifiedDate", LAST_MODIFIED_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CapacityTaskSummary, T> g) {
        return obj -> g.apply((CapacityTaskSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String capacityTaskId;
        private String outpostId;
        private String orderId;
        private String assetId;
        private String capacityTaskStatus;
        private Instant creationDate;
        private Instant completionDate;
        private Instant lastModifiedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(CapacityTaskSummary model) {
            this.capacityTaskId(model.capacityTaskId);
            this.outpostId(model.outpostId);
            this.orderId(model.orderId);
            this.assetId(model.assetId);
            this.capacityTaskStatus(model.capacityTaskStatus);
            this.creationDate(model.creationDate);
            this.completionDate(model.completionDate);
            this.lastModifiedDate(model.lastModifiedDate);
        }

        public final String getCapacityTaskId() {
            return this.capacityTaskId;
        }

        public final void setCapacityTaskId(String capacityTaskId) {
            this.capacityTaskId = capacityTaskId;
        }

        @Override
        public final Builder capacityTaskId(String capacityTaskId) {
            this.capacityTaskId = capacityTaskId;
            return this;
        }

        public final String getOutpostId() {
            return this.outpostId;
        }

        public final void setOutpostId(String outpostId) {
            this.outpostId = outpostId;
        }

        @Override
        public final Builder outpostId(String outpostId) {
            this.outpostId = outpostId;
            return this;
        }

        public final String getOrderId() {
            return this.orderId;
        }

        public final void setOrderId(String orderId) {
            this.orderId = orderId;
        }

        @Override
        public final Builder orderId(String orderId) {
            this.orderId = orderId;
            return this;
        }

        public final String getAssetId() {
            return this.assetId;
        }

        public final void setAssetId(String assetId) {
            this.assetId = assetId;
        }

        @Override
        public final Builder assetId(String assetId) {
            this.assetId = assetId;
            return this;
        }

        public final String getCapacityTaskStatus() {
            return this.capacityTaskStatus;
        }

        public final void setCapacityTaskStatus(String capacityTaskStatus) {
            this.capacityTaskStatus = capacityTaskStatus;
        }

        @Override
        public final Builder capacityTaskStatus(String capacityTaskStatus) {
            this.capacityTaskStatus = capacityTaskStatus;
            return this;
        }

        @Override
        public final Builder capacityTaskStatus(CapacityTaskStatus capacityTaskStatus) {
            this.capacityTaskStatus(capacityTaskStatus == null ? null : capacityTaskStatus.toString());
            return this;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final Instant getCompletionDate() {
            return this.completionDate;
        }

        public final void setCompletionDate(Instant completionDate) {
            this.completionDate = completionDate;
        }

        @Override
        public final Builder completionDate(Instant completionDate) {
            this.completionDate = completionDate;
            return this;
        }

        public final Instant getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public CapacityTaskSummary build() {
            return new CapacityTaskSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CapacityTaskSummary> {
        public Builder capacityTaskId(String var1);

        public Builder outpostId(String var1);

        public Builder orderId(String var1);

        public Builder assetId(String var1);

        public Builder capacityTaskStatus(String var1);

        public Builder capacityTaskStatus(CapacityTaskStatus var1);

        public Builder creationDate(Instant var1);

        public Builder completionDate(Instant var1);

        public Builder lastModifiedDate(Instant var1);
    }
}

