/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.outposts.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.outposts.model.InstanceTypeCapacity;
import software.amazon.awssdk.services.outposts.model.OutpostsRequest;
import software.amazon.awssdk.services.outposts.model.RequestedInstancePoolsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartCapacityTaskRequest
extends OutpostsRequest
implements ToCopyableBuilder<Builder, StartCapacityTaskRequest> {
    private static final SdkField<String> OUTPOST_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutpostIdentifier").getter(StartCapacityTaskRequest.getter(StartCapacityTaskRequest::outpostIdentifier)).setter(StartCapacityTaskRequest.setter(Builder::outpostIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("OutpostId").build()}).build();
    private static final SdkField<String> ORDER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OrderId").getter(StartCapacityTaskRequest.getter(StartCapacityTaskRequest::orderId)).setter(StartCapacityTaskRequest.setter(Builder::orderId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrderId").build()}).build();
    private static final SdkField<List<InstanceTypeCapacity>> INSTANCE_POOLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InstancePools").getter(StartCapacityTaskRequest.getter(StartCapacityTaskRequest::instancePools)).setter(StartCapacityTaskRequest.setter(Builder::instancePools)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstancePools").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InstanceTypeCapacity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(StartCapacityTaskRequest.getter(StartCapacityTaskRequest::dryRun)).setter(StartCapacityTaskRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPOST_IDENTIFIER_FIELD, ORDER_ID_FIELD, INSTANCE_POOLS_FIELD, DRY_RUN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("OutpostId", OUTPOST_IDENTIFIER_FIELD);
            this.put("OrderId", ORDER_ID_FIELD);
            this.put("InstancePools", INSTANCE_POOLS_FIELD);
            this.put("DryRun", DRY_RUN_FIELD);
        }
    });
    private final String outpostIdentifier;
    private final String orderId;
    private final List<InstanceTypeCapacity> instancePools;
    private final Boolean dryRun;

    private StartCapacityTaskRequest(BuilderImpl builder) {
        super(builder);
        this.outpostIdentifier = builder.outpostIdentifier;
        this.orderId = builder.orderId;
        this.instancePools = builder.instancePools;
        this.dryRun = builder.dryRun;
    }

    public final String outpostIdentifier() {
        return this.outpostIdentifier;
    }

    public final String orderId() {
        return this.orderId;
    }

    public final boolean hasInstancePools() {
        return this.instancePools != null && !(this.instancePools instanceof SdkAutoConstructList);
    }

    public final List<InstanceTypeCapacity> instancePools() {
        return this.instancePools;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.outpostIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.orderId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstancePools() ? this.instancePools() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartCapacityTaskRequest)) {
            return false;
        }
        StartCapacityTaskRequest other = (StartCapacityTaskRequest)((Object)obj);
        return Objects.equals(this.outpostIdentifier(), other.outpostIdentifier()) && Objects.equals(this.orderId(), other.orderId()) && this.hasInstancePools() == other.hasInstancePools() && Objects.equals(this.instancePools(), other.instancePools()) && Objects.equals(this.dryRun(), other.dryRun());
    }

    public final String toString() {
        return ToString.builder((String)"StartCapacityTaskRequest").add("OutpostIdentifier", (Object)this.outpostIdentifier()).add("OrderId", (Object)this.orderId()).add("InstancePools", this.hasInstancePools() ? this.instancePools() : null).add("DryRun", (Object)this.dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OutpostIdentifier": {
                return Optional.ofNullable(clazz.cast(this.outpostIdentifier()));
            }
            case "OrderId": {
                return Optional.ofNullable(clazz.cast(this.orderId()));
            }
            case "InstancePools": {
                return Optional.ofNullable(clazz.cast(this.instancePools()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<StartCapacityTaskRequest, T> g) {
        return obj -> g.apply((StartCapacityTaskRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OutpostsRequest.BuilderImpl
    implements Builder {
        private String outpostIdentifier;
        private String orderId;
        private List<InstanceTypeCapacity> instancePools = DefaultSdkAutoConstructList.getInstance();
        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(StartCapacityTaskRequest model) {
            super(model);
            this.outpostIdentifier(model.outpostIdentifier);
            this.orderId(model.orderId);
            this.instancePools(model.instancePools);
            this.dryRun(model.dryRun);
        }

        public final String getOutpostIdentifier() {
            return this.outpostIdentifier;
        }

        public final void setOutpostIdentifier(String outpostIdentifier) {
            this.outpostIdentifier = outpostIdentifier;
        }

        @Override
        public final Builder outpostIdentifier(String outpostIdentifier) {
            this.outpostIdentifier = outpostIdentifier;
            return this;
        }

        public final String getOrderId() {
            return this.orderId;
        }

        public final void setOrderId(String orderId) {
            this.orderId = orderId;
        }

        @Override
        public final Builder orderId(String orderId) {
            this.orderId = orderId;
            return this;
        }

        public final List<InstanceTypeCapacity.Builder> getInstancePools() {
            List<InstanceTypeCapacity.Builder> result = RequestedInstancePoolsCopier.copyToBuilder(this.instancePools);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstancePools(Collection<InstanceTypeCapacity.BuilderImpl> instancePools) {
            this.instancePools = RequestedInstancePoolsCopier.copyFromBuilder(instancePools);
        }

        @Override
        public final Builder instancePools(Collection<InstanceTypeCapacity> instancePools) {
            this.instancePools = RequestedInstancePoolsCopier.copy(instancePools);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instancePools(InstanceTypeCapacity ... instancePools) {
            this.instancePools(Arrays.asList(instancePools));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instancePools(Consumer<InstanceTypeCapacity.Builder> ... instancePools) {
            this.instancePools(Stream.of(instancePools).map(c -> (InstanceTypeCapacity)((InstanceTypeCapacity.Builder)InstanceTypeCapacity.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartCapacityTaskRequest build() {
            return new StartCapacityTaskRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends OutpostsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartCapacityTaskRequest> {
        public Builder outpostIdentifier(String var1);

        public Builder orderId(String var1);

        public Builder instancePools(Collection<InstanceTypeCapacity> var1);

        public Builder instancePools(InstanceTypeCapacity ... var1);

        public Builder instancePools(Consumer<InstanceTypeCapacity.Builder> ... var1);

        public Builder dryRun(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

