/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.outposts.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.outposts.model.InstanceTypeItem;
import software.amazon.awssdk.services.outposts.model.InstanceTypeListDefinitionCopier;
import software.amazon.awssdk.services.outposts.model.OutpostsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetOutpostSupportedInstanceTypesResponse
extends OutpostsResponse
implements ToCopyableBuilder<Builder, GetOutpostSupportedInstanceTypesResponse> {
    private static final SdkField<List<InstanceTypeItem>> INSTANCE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InstanceTypes").getter(GetOutpostSupportedInstanceTypesResponse.getter(GetOutpostSupportedInstanceTypesResponse::instanceTypes)).setter(GetOutpostSupportedInstanceTypesResponse.setter(Builder::instanceTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InstanceTypeItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetOutpostSupportedInstanceTypesResponse.getter(GetOutpostSupportedInstanceTypesResponse::nextToken)).setter(GetOutpostSupportedInstanceTypesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_TYPES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetOutpostSupportedInstanceTypesResponse.memberNameToFieldInitializer();
    private final List<InstanceTypeItem> instanceTypes;
    private final String nextToken;

    private GetOutpostSupportedInstanceTypesResponse(BuilderImpl builder) {
        super(builder);
        this.instanceTypes = builder.instanceTypes;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasInstanceTypes() {
        return this.instanceTypes != null && !(this.instanceTypes instanceof SdkAutoConstructList);
    }

    public final List<InstanceTypeItem> instanceTypes() {
        return this.instanceTypes;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceTypes() ? this.instanceTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOutpostSupportedInstanceTypesResponse)) {
            return false;
        }
        GetOutpostSupportedInstanceTypesResponse other = (GetOutpostSupportedInstanceTypesResponse)((Object)obj);
        return this.hasInstanceTypes() == other.hasInstanceTypes() && Objects.equals(this.instanceTypes(), other.instanceTypes()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetOutpostSupportedInstanceTypesResponse").add("InstanceTypes", this.hasInstanceTypes() ? this.instanceTypes() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceTypes": {
                return Optional.ofNullable(clazz.cast(this.instanceTypes()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("InstanceTypes", INSTANCE_TYPES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetOutpostSupportedInstanceTypesResponse, T> g) {
        return obj -> g.apply((GetOutpostSupportedInstanceTypesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OutpostsResponse.BuilderImpl
    implements Builder {
        private List<InstanceTypeItem> instanceTypes = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetOutpostSupportedInstanceTypesResponse model) {
            super(model);
            this.instanceTypes(model.instanceTypes);
            this.nextToken(model.nextToken);
        }

        public final List<InstanceTypeItem.Builder> getInstanceTypes() {
            List<InstanceTypeItem.Builder> result = InstanceTypeListDefinitionCopier.copyToBuilder(this.instanceTypes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstanceTypes(Collection<InstanceTypeItem.BuilderImpl> instanceTypes) {
            this.instanceTypes = InstanceTypeListDefinitionCopier.copyFromBuilder(instanceTypes);
        }

        @Override
        public final Builder instanceTypes(Collection<InstanceTypeItem> instanceTypes) {
            this.instanceTypes = InstanceTypeListDefinitionCopier.copy(instanceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceTypes(InstanceTypeItem ... instanceTypes) {
            this.instanceTypes(Arrays.asList(instanceTypes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceTypes(Consumer<InstanceTypeItem.Builder> ... instanceTypes) {
            this.instanceTypes(Stream.of(instanceTypes).map(c -> (InstanceTypeItem)((InstanceTypeItem.Builder)InstanceTypeItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetOutpostSupportedInstanceTypesResponse build() {
            return new GetOutpostSupportedInstanceTypesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends OutpostsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetOutpostSupportedInstanceTypesResponse> {
        public Builder instanceTypes(Collection<InstanceTypeItem> var1);

        public Builder instanceTypes(InstanceTypeItem ... var1);

        public Builder instanceTypes(Consumer<InstanceTypeItem.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

