/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.outposts.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.outposts.model.BlockingInstance;
import software.amazon.awssdk.services.outposts.model.BlockingInstancesListCopier;
import software.amazon.awssdk.services.outposts.model.OutpostsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListBlockingInstancesForCapacityTaskResponse
extends OutpostsResponse
implements ToCopyableBuilder<Builder, ListBlockingInstancesForCapacityTaskResponse> {
    private static final SdkField<List<BlockingInstance>> BLOCKING_INSTANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BlockingInstances").getter(ListBlockingInstancesForCapacityTaskResponse.getter(ListBlockingInstancesForCapacityTaskResponse::blockingInstances)).setter(ListBlockingInstancesForCapacityTaskResponse.setter(Builder::blockingInstances)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockingInstances").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BlockingInstance::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListBlockingInstancesForCapacityTaskResponse.getter(ListBlockingInstancesForCapacityTaskResponse::nextToken)).setter(ListBlockingInstancesForCapacityTaskResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLOCKING_INSTANCES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListBlockingInstancesForCapacityTaskResponse.memberNameToFieldInitializer();
    private final List<BlockingInstance> blockingInstances;
    private final String nextToken;

    private ListBlockingInstancesForCapacityTaskResponse(BuilderImpl builder) {
        super(builder);
        this.blockingInstances = builder.blockingInstances;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasBlockingInstances() {
        return this.blockingInstances != null && !(this.blockingInstances instanceof SdkAutoConstructList);
    }

    public final List<BlockingInstance> blockingInstances() {
        return this.blockingInstances;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBlockingInstances() ? this.blockingInstances() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBlockingInstancesForCapacityTaskResponse)) {
            return false;
        }
        ListBlockingInstancesForCapacityTaskResponse other = (ListBlockingInstancesForCapacityTaskResponse)((Object)obj);
        return this.hasBlockingInstances() == other.hasBlockingInstances() && Objects.equals(this.blockingInstances(), other.blockingInstances()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListBlockingInstancesForCapacityTaskResponse").add("BlockingInstances", this.hasBlockingInstances() ? this.blockingInstances() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BlockingInstances": {
                return Optional.ofNullable(clazz.cast(this.blockingInstances()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("BlockingInstances", BLOCKING_INSTANCES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListBlockingInstancesForCapacityTaskResponse, T> g) {
        return obj -> g.apply((ListBlockingInstancesForCapacityTaskResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OutpostsResponse.BuilderImpl
    implements Builder {
        private List<BlockingInstance> blockingInstances = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBlockingInstancesForCapacityTaskResponse model) {
            super(model);
            this.blockingInstances(model.blockingInstances);
            this.nextToken(model.nextToken);
        }

        public final List<BlockingInstance.Builder> getBlockingInstances() {
            List<BlockingInstance.Builder> result = BlockingInstancesListCopier.copyToBuilder(this.blockingInstances);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBlockingInstances(Collection<BlockingInstance.BuilderImpl> blockingInstances) {
            this.blockingInstances = BlockingInstancesListCopier.copyFromBuilder(blockingInstances);
        }

        @Override
        public final Builder blockingInstances(Collection<BlockingInstance> blockingInstances) {
            this.blockingInstances = BlockingInstancesListCopier.copy(blockingInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockingInstances(BlockingInstance ... blockingInstances) {
            this.blockingInstances(Arrays.asList(blockingInstances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockingInstances(Consumer<BlockingInstance.Builder> ... blockingInstances) {
            this.blockingInstances(Stream.of(blockingInstances).map(c -> (BlockingInstance)((BlockingInstance.Builder)BlockingInstance.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListBlockingInstancesForCapacityTaskResponse build() {
            return new ListBlockingInstancesForCapacityTaskResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends OutpostsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListBlockingInstancesForCapacityTaskResponse> {
        public Builder blockingInstances(Collection<BlockingInstance> var1);

        public Builder blockingInstances(BlockingInstance ... var1);

        public Builder blockingInstances(Consumer<BlockingInstance.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

