/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.outposts.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.outposts.model.AssetInstance;
import software.amazon.awssdk.services.outposts.model.AssetInstanceListCopier;
import software.amazon.awssdk.services.outposts.model.OutpostsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAssetInstancesResponse
extends OutpostsResponse
implements ToCopyableBuilder<Builder, ListAssetInstancesResponse> {
    private static final SdkField<List<AssetInstance>> ASSET_INSTANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AssetInstances").getter(ListAssetInstancesResponse.getter(ListAssetInstancesResponse::assetInstances)).setter(ListAssetInstancesResponse.setter(Builder::assetInstances)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssetInstances").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssetInstance::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListAssetInstancesResponse.getter(ListAssetInstancesResponse::nextToken)).setter(ListAssetInstancesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_INSTANCES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AssetInstances", ASSET_INSTANCES_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<AssetInstance> assetInstances;
    private final String nextToken;

    private ListAssetInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.assetInstances = builder.assetInstances;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAssetInstances() {
        return this.assetInstances != null && !(this.assetInstances instanceof SdkAutoConstructList);
    }

    public final List<AssetInstance> assetInstances() {
        return this.assetInstances;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssetInstances() ? this.assetInstances() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAssetInstancesResponse)) {
            return false;
        }
        ListAssetInstancesResponse other = (ListAssetInstancesResponse)((Object)obj);
        return this.hasAssetInstances() == other.hasAssetInstances() && Objects.equals(this.assetInstances(), other.assetInstances()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAssetInstancesResponse").add("AssetInstances", this.hasAssetInstances() ? this.assetInstances() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssetInstances": {
                return Optional.ofNullable(clazz.cast(this.assetInstances()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListAssetInstancesResponse, T> g) {
        return obj -> g.apply((ListAssetInstancesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OutpostsResponse.BuilderImpl
    implements Builder {
        private List<AssetInstance> assetInstances = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAssetInstancesResponse model) {
            super(model);
            this.assetInstances(model.assetInstances);
            this.nextToken(model.nextToken);
        }

        public final List<AssetInstance.Builder> getAssetInstances() {
            List<AssetInstance.Builder> result = AssetInstanceListCopier.copyToBuilder(this.assetInstances);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssetInstances(Collection<AssetInstance.BuilderImpl> assetInstances) {
            this.assetInstances = AssetInstanceListCopier.copyFromBuilder(assetInstances);
        }

        @Override
        public final Builder assetInstances(Collection<AssetInstance> assetInstances) {
            this.assetInstances = AssetInstanceListCopier.copy(assetInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetInstances(AssetInstance ... assetInstances) {
            this.assetInstances(Arrays.asList(assetInstances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetInstances(Consumer<AssetInstance.Builder> ... assetInstances) {
            this.assetInstances(Stream.of(assetInstances).map(c -> (AssetInstance)((AssetInstance.Builder)AssetInstance.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAssetInstancesResponse build() {
            return new ListAssetInstancesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends OutpostsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAssetInstancesResponse> {
        public Builder assetInstances(Collection<AssetInstance> var1);

        public Builder assetInstances(AssetInstance ... var1);

        public Builder assetInstances(Consumer<AssetInstance.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

