/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.outposts.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.outposts.model.OutpostsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartConnectionRequest
extends OutpostsRequest
implements ToCopyableBuilder<Builder, StartConnectionRequest> {
    private static final SdkField<String> DEVICE_SERIAL_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceSerialNumber").getter(StartConnectionRequest.getter(StartConnectionRequest::deviceSerialNumber)).setter(StartConnectionRequest.setter(Builder::deviceSerialNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceSerialNumber").build()}).build();
    private static final SdkField<String> ASSET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssetId").getter(StartConnectionRequest.getter(StartConnectionRequest::assetId)).setter(StartConnectionRequest.setter(Builder::assetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssetId").build()}).build();
    private static final SdkField<String> CLIENT_PUBLIC_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientPublicKey").getter(StartConnectionRequest.getter(StartConnectionRequest::clientPublicKey)).setter(StartConnectionRequest.setter(Builder::clientPublicKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientPublicKey").build()}).build();
    private static final SdkField<Integer> NETWORK_INTERFACE_DEVICE_INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NetworkInterfaceDeviceIndex").getter(StartConnectionRequest.getter(StartConnectionRequest::networkInterfaceDeviceIndex)).setter(StartConnectionRequest.setter(Builder::networkInterfaceDeviceIndex)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceDeviceIndex").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_SERIAL_NUMBER_FIELD, ASSET_ID_FIELD, CLIENT_PUBLIC_KEY_FIELD, NETWORK_INTERFACE_DEVICE_INDEX_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DeviceSerialNumber", DEVICE_SERIAL_NUMBER_FIELD);
            this.put("AssetId", ASSET_ID_FIELD);
            this.put("ClientPublicKey", CLIENT_PUBLIC_KEY_FIELD);
            this.put("NetworkInterfaceDeviceIndex", NETWORK_INTERFACE_DEVICE_INDEX_FIELD);
        }
    });
    private final String deviceSerialNumber;
    private final String assetId;
    private final String clientPublicKey;
    private final Integer networkInterfaceDeviceIndex;

    private StartConnectionRequest(BuilderImpl builder) {
        super(builder);
        this.deviceSerialNumber = builder.deviceSerialNumber;
        this.assetId = builder.assetId;
        this.clientPublicKey = builder.clientPublicKey;
        this.networkInterfaceDeviceIndex = builder.networkInterfaceDeviceIndex;
    }

    public final String deviceSerialNumber() {
        return this.deviceSerialNumber;
    }

    public final String assetId() {
        return this.assetId;
    }

    public final String clientPublicKey() {
        return this.clientPublicKey;
    }

    public final Integer networkInterfaceDeviceIndex() {
        return this.networkInterfaceDeviceIndex;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceSerialNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.assetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientPublicKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaceDeviceIndex());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartConnectionRequest)) {
            return false;
        }
        StartConnectionRequest other = (StartConnectionRequest)((Object)obj);
        return Objects.equals(this.deviceSerialNumber(), other.deviceSerialNumber()) && Objects.equals(this.assetId(), other.assetId()) && Objects.equals(this.clientPublicKey(), other.clientPublicKey()) && Objects.equals(this.networkInterfaceDeviceIndex(), other.networkInterfaceDeviceIndex());
    }

    public final String toString() {
        return ToString.builder((String)"StartConnectionRequest").add("DeviceSerialNumber", (Object)this.deviceSerialNumber()).add("AssetId", (Object)this.assetId()).add("ClientPublicKey", (Object)this.clientPublicKey()).add("NetworkInterfaceDeviceIndex", (Object)this.networkInterfaceDeviceIndex()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeviceSerialNumber": {
                return Optional.ofNullable(clazz.cast(this.deviceSerialNumber()));
            }
            case "AssetId": {
                return Optional.ofNullable(clazz.cast(this.assetId()));
            }
            case "ClientPublicKey": {
                return Optional.ofNullable(clazz.cast(this.clientPublicKey()));
            }
            case "NetworkInterfaceDeviceIndex": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaceDeviceIndex()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<StartConnectionRequest, T> g) {
        return obj -> g.apply((StartConnectionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OutpostsRequest.BuilderImpl
    implements Builder {
        private String deviceSerialNumber;
        private String assetId;
        private String clientPublicKey;
        private Integer networkInterfaceDeviceIndex;

        private BuilderImpl() {
        }

        private BuilderImpl(StartConnectionRequest model) {
            super(model);
            this.deviceSerialNumber(model.deviceSerialNumber);
            this.assetId(model.assetId);
            this.clientPublicKey(model.clientPublicKey);
            this.networkInterfaceDeviceIndex(model.networkInterfaceDeviceIndex);
        }

        public final String getDeviceSerialNumber() {
            return this.deviceSerialNumber;
        }

        public final void setDeviceSerialNumber(String deviceSerialNumber) {
            this.deviceSerialNumber = deviceSerialNumber;
        }

        @Override
        public final Builder deviceSerialNumber(String deviceSerialNumber) {
            this.deviceSerialNumber = deviceSerialNumber;
            return this;
        }

        public final String getAssetId() {
            return this.assetId;
        }

        public final void setAssetId(String assetId) {
            this.assetId = assetId;
        }

        @Override
        public final Builder assetId(String assetId) {
            this.assetId = assetId;
            return this;
        }

        public final String getClientPublicKey() {
            return this.clientPublicKey;
        }

        public final void setClientPublicKey(String clientPublicKey) {
            this.clientPublicKey = clientPublicKey;
        }

        @Override
        public final Builder clientPublicKey(String clientPublicKey) {
            this.clientPublicKey = clientPublicKey;
            return this;
        }

        public final Integer getNetworkInterfaceDeviceIndex() {
            return this.networkInterfaceDeviceIndex;
        }

        public final void setNetworkInterfaceDeviceIndex(Integer networkInterfaceDeviceIndex) {
            this.networkInterfaceDeviceIndex = networkInterfaceDeviceIndex;
        }

        @Override
        public final Builder networkInterfaceDeviceIndex(Integer networkInterfaceDeviceIndex) {
            this.networkInterfaceDeviceIndex = networkInterfaceDeviceIndex;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartConnectionRequest build() {
            return new StartConnectionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends OutpostsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartConnectionRequest> {
        public Builder deviceSerialNumber(String var1);

        public Builder assetId(String var1);

        public Builder clientPublicKey(String var1);

        public Builder networkInterfaceDeviceIndex(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

