/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.outposts.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.outposts.model.CapacityTaskStatus;
import software.amazon.awssdk.services.outposts.model.CapacityTaskStatusListCopier;
import software.amazon.awssdk.services.outposts.model.OutpostsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCapacityTasksRequest
extends OutpostsRequest
implements ToCopyableBuilder<Builder, ListCapacityTasksRequest> {
    private static final SdkField<String> OUTPOST_IDENTIFIER_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutpostIdentifierFilter").getter(ListCapacityTasksRequest.getter(ListCapacityTasksRequest::outpostIdentifierFilter)).setter(ListCapacityTasksRequest.setter(Builder::outpostIdentifierFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("OutpostIdentifierFilter").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListCapacityTasksRequest.getter(ListCapacityTasksRequest::maxResults)).setter(ListCapacityTasksRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListCapacityTasksRequest.getter(ListCapacityTasksRequest::nextToken)).setter(ListCapacityTasksRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("NextToken").build()}).build();
    private static final SdkField<List<String>> CAPACITY_TASK_STATUS_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CapacityTaskStatusFilter").getter(ListCapacityTasksRequest.getter(ListCapacityTasksRequest::capacityTaskStatusFilterAsStrings)).setter(ListCapacityTasksRequest.setter(Builder::capacityTaskStatusFilterWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("CapacityTaskStatusFilter").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPOST_IDENTIFIER_FILTER_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, CAPACITY_TASK_STATUS_FILTER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("OutpostIdentifierFilter", OUTPOST_IDENTIFIER_FILTER_FIELD);
            this.put("MaxResults", MAX_RESULTS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
            this.put("CapacityTaskStatusFilter", CAPACITY_TASK_STATUS_FILTER_FIELD);
        }
    });
    private final String outpostIdentifierFilter;
    private final Integer maxResults;
    private final String nextToken;
    private final List<String> capacityTaskStatusFilter;

    private ListCapacityTasksRequest(BuilderImpl builder) {
        super(builder);
        this.outpostIdentifierFilter = builder.outpostIdentifierFilter;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.capacityTaskStatusFilter = builder.capacityTaskStatusFilter;
    }

    public final String outpostIdentifierFilter() {
        return this.outpostIdentifierFilter;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final List<CapacityTaskStatus> capacityTaskStatusFilter() {
        return CapacityTaskStatusListCopier.copyStringToEnum(this.capacityTaskStatusFilter);
    }

    public final boolean hasCapacityTaskStatusFilter() {
        return this.capacityTaskStatusFilter != null && !(this.capacityTaskStatusFilter instanceof SdkAutoConstructList);
    }

    public final List<String> capacityTaskStatusFilterAsStrings() {
        return this.capacityTaskStatusFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.outpostIdentifierFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCapacityTaskStatusFilter() ? this.capacityTaskStatusFilterAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCapacityTasksRequest)) {
            return false;
        }
        ListCapacityTasksRequest other = (ListCapacityTasksRequest)((Object)obj);
        return Objects.equals(this.outpostIdentifierFilter(), other.outpostIdentifierFilter()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && this.hasCapacityTaskStatusFilter() == other.hasCapacityTaskStatusFilter() && Objects.equals(this.capacityTaskStatusFilterAsStrings(), other.capacityTaskStatusFilterAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"ListCapacityTasksRequest").add("OutpostIdentifierFilter", (Object)this.outpostIdentifierFilter()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("CapacityTaskStatusFilter", this.hasCapacityTaskStatusFilter() ? this.capacityTaskStatusFilterAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OutpostIdentifierFilter": {
                return Optional.ofNullable(clazz.cast(this.outpostIdentifierFilter()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "CapacityTaskStatusFilter": {
                return Optional.ofNullable(clazz.cast(this.capacityTaskStatusFilterAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListCapacityTasksRequest, T> g) {
        return obj -> g.apply((ListCapacityTasksRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OutpostsRequest.BuilderImpl
    implements Builder {
        private String outpostIdentifierFilter;
        private Integer maxResults;
        private String nextToken;
        private List<String> capacityTaskStatusFilter = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListCapacityTasksRequest model) {
            super(model);
            this.outpostIdentifierFilter(model.outpostIdentifierFilter);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.capacityTaskStatusFilterWithStrings(model.capacityTaskStatusFilter);
        }

        public final String getOutpostIdentifierFilter() {
            return this.outpostIdentifierFilter;
        }

        public final void setOutpostIdentifierFilter(String outpostIdentifierFilter) {
            this.outpostIdentifierFilter = outpostIdentifierFilter;
        }

        @Override
        public final Builder outpostIdentifierFilter(String outpostIdentifierFilter) {
            this.outpostIdentifierFilter = outpostIdentifierFilter;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Collection<String> getCapacityTaskStatusFilter() {
            if (this.capacityTaskStatusFilter instanceof SdkAutoConstructList) {
                return null;
            }
            return this.capacityTaskStatusFilter;
        }

        public final void setCapacityTaskStatusFilter(Collection<String> capacityTaskStatusFilter) {
            this.capacityTaskStatusFilter = CapacityTaskStatusListCopier.copy(capacityTaskStatusFilter);
        }

        @Override
        public final Builder capacityTaskStatusFilterWithStrings(Collection<String> capacityTaskStatusFilter) {
            this.capacityTaskStatusFilter = CapacityTaskStatusListCopier.copy(capacityTaskStatusFilter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityTaskStatusFilterWithStrings(String ... capacityTaskStatusFilter) {
            this.capacityTaskStatusFilterWithStrings(Arrays.asList(capacityTaskStatusFilter));
            return this;
        }

        @Override
        public final Builder capacityTaskStatusFilter(Collection<CapacityTaskStatus> capacityTaskStatusFilter) {
            this.capacityTaskStatusFilter = CapacityTaskStatusListCopier.copyEnumToString(capacityTaskStatusFilter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityTaskStatusFilter(CapacityTaskStatus ... capacityTaskStatusFilter) {
            this.capacityTaskStatusFilter(Arrays.asList(capacityTaskStatusFilter));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListCapacityTasksRequest build() {
            return new ListCapacityTasksRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends OutpostsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCapacityTasksRequest> {
        public Builder outpostIdentifierFilter(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder capacityTaskStatusFilterWithStrings(Collection<String> var1);

        public Builder capacityTaskStatusFilterWithStrings(String ... var1);

        public Builder capacityTaskStatusFilter(Collection<CapacityTaskStatus> var1);

        public Builder capacityTaskStatusFilter(CapacityTaskStatus ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

