/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.outposts.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.outposts.OutpostsClient;
import software.amazon.awssdk.services.outposts.internal.UserAgentUtils;
import software.amazon.awssdk.services.outposts.model.BlockingInstance;
import software.amazon.awssdk.services.outposts.model.ListBlockingInstancesForCapacityTaskRequest;
import software.amazon.awssdk.services.outposts.model.ListBlockingInstancesForCapacityTaskResponse;

public class ListBlockingInstancesForCapacityTaskIterable
implements SdkIterable<ListBlockingInstancesForCapacityTaskResponse> {
    private final OutpostsClient client;
    private final ListBlockingInstancesForCapacityTaskRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListBlockingInstancesForCapacityTaskIterable(OutpostsClient client, ListBlockingInstancesForCapacityTaskRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListBlockingInstancesForCapacityTaskResponseFetcher();
    }

    public Iterator<ListBlockingInstancesForCapacityTaskResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<BlockingInstance> blockingInstances() {
        Function<ListBlockingInstancesForCapacityTaskResponse, Iterator> getIterator = response -> {
            if (response != null && response.blockingInstances() != null) {
                return response.blockingInstances().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListBlockingInstancesForCapacityTaskResponseFetcher
    implements SyncPageFetcher<ListBlockingInstancesForCapacityTaskResponse> {
        private ListBlockingInstancesForCapacityTaskResponseFetcher() {
        }

        public boolean hasNextPage(ListBlockingInstancesForCapacityTaskResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListBlockingInstancesForCapacityTaskResponse nextPage(ListBlockingInstancesForCapacityTaskResponse previousPage) {
            if (previousPage == null) {
                return ListBlockingInstancesForCapacityTaskIterable.this.client.listBlockingInstancesForCapacityTask(ListBlockingInstancesForCapacityTaskIterable.this.firstRequest);
            }
            return ListBlockingInstancesForCapacityTaskIterable.this.client.listBlockingInstancesForCapacityTask((ListBlockingInstancesForCapacityTaskRequest)((Object)ListBlockingInstancesForCapacityTaskIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

