/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.outposts.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.outposts.model.CapacityTaskFailure;
import software.amazon.awssdk.services.outposts.model.CapacityTaskStatus;
import software.amazon.awssdk.services.outposts.model.InstanceTypeCapacity;
import software.amazon.awssdk.services.outposts.model.OutpostsResponse;
import software.amazon.awssdk.services.outposts.model.RequestedInstancePoolsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCapacityTaskResponse
extends OutpostsResponse
implements ToCopyableBuilder<Builder, GetCapacityTaskResponse> {
    private static final SdkField<String> CAPACITY_TASK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CapacityTaskId").getter(GetCapacityTaskResponse.getter(GetCapacityTaskResponse::capacityTaskId)).setter(GetCapacityTaskResponse.setter(Builder::capacityTaskId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityTaskId").build()}).build();
    private static final SdkField<String> OUTPOST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutpostId").getter(GetCapacityTaskResponse.getter(GetCapacityTaskResponse::outpostId)).setter(GetCapacityTaskResponse.setter(Builder::outpostId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutpostId").build()}).build();
    private static final SdkField<String> ORDER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OrderId").getter(GetCapacityTaskResponse.getter(GetCapacityTaskResponse::orderId)).setter(GetCapacityTaskResponse.setter(Builder::orderId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrderId").build()}).build();
    private static final SdkField<List<InstanceTypeCapacity>> REQUESTED_INSTANCE_POOLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RequestedInstancePools").getter(GetCapacityTaskResponse.getter(GetCapacityTaskResponse::requestedInstancePools)).setter(GetCapacityTaskResponse.setter(Builder::requestedInstancePools)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestedInstancePools").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InstanceTypeCapacity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(GetCapacityTaskResponse.getter(GetCapacityTaskResponse::dryRun)).setter(GetCapacityTaskResponse.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").build()}).build();
    private static final SdkField<String> CAPACITY_TASK_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CapacityTaskStatus").getter(GetCapacityTaskResponse.getter(GetCapacityTaskResponse::capacityTaskStatusAsString)).setter(GetCapacityTaskResponse.setter(Builder::capacityTaskStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityTaskStatus").build()}).build();
    private static final SdkField<CapacityTaskFailure> FAILED_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Failed").getter(GetCapacityTaskResponse.getter(GetCapacityTaskResponse::failed)).setter(GetCapacityTaskResponse.setter(Builder::failed)).constructor(CapacityTaskFailure::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Failed").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationDate").getter(GetCapacityTaskResponse.getter(GetCapacityTaskResponse::creationDate)).setter(GetCapacityTaskResponse.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()}).build();
    private static final SdkField<Instant> COMPLETION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CompletionDate").getter(GetCapacityTaskResponse.getter(GetCapacityTaskResponse::completionDate)).setter(GetCapacityTaskResponse.setter(Builder::completionDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionDate").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedDate").getter(GetCapacityTaskResponse.getter(GetCapacityTaskResponse::lastModifiedDate)).setter(GetCapacityTaskResponse.setter(Builder::lastModifiedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_TASK_ID_FIELD, OUTPOST_ID_FIELD, ORDER_ID_FIELD, REQUESTED_INSTANCE_POOLS_FIELD, DRY_RUN_FIELD, CAPACITY_TASK_STATUS_FIELD, FAILED_FIELD, CREATION_DATE_FIELD, COMPLETION_DATE_FIELD, LAST_MODIFIED_DATE_FIELD));
    private final String capacityTaskId;
    private final String outpostId;
    private final String orderId;
    private final List<InstanceTypeCapacity> requestedInstancePools;
    private final Boolean dryRun;
    private final String capacityTaskStatus;
    private final CapacityTaskFailure failed;
    private final Instant creationDate;
    private final Instant completionDate;
    private final Instant lastModifiedDate;

    private GetCapacityTaskResponse(BuilderImpl builder) {
        super(builder);
        this.capacityTaskId = builder.capacityTaskId;
        this.outpostId = builder.outpostId;
        this.orderId = builder.orderId;
        this.requestedInstancePools = builder.requestedInstancePools;
        this.dryRun = builder.dryRun;
        this.capacityTaskStatus = builder.capacityTaskStatus;
        this.failed = builder.failed;
        this.creationDate = builder.creationDate;
        this.completionDate = builder.completionDate;
        this.lastModifiedDate = builder.lastModifiedDate;
    }

    public final String capacityTaskId() {
        return this.capacityTaskId;
    }

    public final String outpostId() {
        return this.outpostId;
    }

    public final String orderId() {
        return this.orderId;
    }

    public final boolean hasRequestedInstancePools() {
        return this.requestedInstancePools != null && !(this.requestedInstancePools instanceof SdkAutoConstructList);
    }

    public final List<InstanceTypeCapacity> requestedInstancePools() {
        return this.requestedInstancePools;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final CapacityTaskStatus capacityTaskStatus() {
        return CapacityTaskStatus.fromValue(this.capacityTaskStatus);
    }

    public final String capacityTaskStatusAsString() {
        return this.capacityTaskStatus;
    }

    public final CapacityTaskFailure failed() {
        return this.failed;
    }

    public final Instant creationDate() {
        return this.creationDate;
    }

    public final Instant completionDate() {
        return this.completionDate;
    }

    public final Instant lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityTaskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.outpostId());
        hashCode = 31 * hashCode + Objects.hashCode(this.orderId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRequestedInstancePools() ? this.requestedInstancePools() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityTaskStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failed());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.completionDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCapacityTaskResponse)) {
            return false;
        }
        GetCapacityTaskResponse other = (GetCapacityTaskResponse)((Object)obj);
        return Objects.equals(this.capacityTaskId(), other.capacityTaskId()) && Objects.equals(this.outpostId(), other.outpostId()) && Objects.equals(this.orderId(), other.orderId()) && this.hasRequestedInstancePools() == other.hasRequestedInstancePools() && Objects.equals(this.requestedInstancePools(), other.requestedInstancePools()) && Objects.equals(this.dryRun(), other.dryRun()) && Objects.equals(this.capacityTaskStatusAsString(), other.capacityTaskStatusAsString()) && Objects.equals(this.failed(), other.failed()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.completionDate(), other.completionDate()) && Objects.equals(this.lastModifiedDate(), other.lastModifiedDate());
    }

    public final String toString() {
        return ToString.builder((String)"GetCapacityTaskResponse").add("CapacityTaskId", (Object)this.capacityTaskId()).add("OutpostId", (Object)this.outpostId()).add("OrderId", (Object)this.orderId()).add("RequestedInstancePools", this.hasRequestedInstancePools() ? this.requestedInstancePools() : null).add("DryRun", (Object)this.dryRun()).add("CapacityTaskStatus", (Object)this.capacityTaskStatusAsString()).add("Failed", (Object)this.failed()).add("CreationDate", (Object)this.creationDate()).add("CompletionDate", (Object)this.completionDate()).add("LastModifiedDate", (Object)this.lastModifiedDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CapacityTaskId": {
                return Optional.ofNullable(clazz.cast(this.capacityTaskId()));
            }
            case "OutpostId": {
                return Optional.ofNullable(clazz.cast(this.outpostId()));
            }
            case "OrderId": {
                return Optional.ofNullable(clazz.cast(this.orderId()));
            }
            case "RequestedInstancePools": {
                return Optional.ofNullable(clazz.cast(this.requestedInstancePools()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "CapacityTaskStatus": {
                return Optional.ofNullable(clazz.cast(this.capacityTaskStatusAsString()));
            }
            case "Failed": {
                return Optional.ofNullable(clazz.cast(this.failed()));
            }
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "CompletionDate": {
                return Optional.ofNullable(clazz.cast(this.completionDate()));
            }
            case "LastModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetCapacityTaskResponse, T> g) {
        return obj -> g.apply((GetCapacityTaskResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OutpostsResponse.BuilderImpl
    implements Builder {
        private String capacityTaskId;
        private String outpostId;
        private String orderId;
        private List<InstanceTypeCapacity> requestedInstancePools = DefaultSdkAutoConstructList.getInstance();
        private Boolean dryRun;
        private String capacityTaskStatus;
        private CapacityTaskFailure failed;
        private Instant creationDate;
        private Instant completionDate;
        private Instant lastModifiedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCapacityTaskResponse model) {
            super(model);
            this.capacityTaskId(model.capacityTaskId);
            this.outpostId(model.outpostId);
            this.orderId(model.orderId);
            this.requestedInstancePools(model.requestedInstancePools);
            this.dryRun(model.dryRun);
            this.capacityTaskStatus(model.capacityTaskStatus);
            this.failed(model.failed);
            this.creationDate(model.creationDate);
            this.completionDate(model.completionDate);
            this.lastModifiedDate(model.lastModifiedDate);
        }

        public final String getCapacityTaskId() {
            return this.capacityTaskId;
        }

        public final void setCapacityTaskId(String capacityTaskId) {
            this.capacityTaskId = capacityTaskId;
        }

        @Override
        public final Builder capacityTaskId(String capacityTaskId) {
            this.capacityTaskId = capacityTaskId;
            return this;
        }

        public final String getOutpostId() {
            return this.outpostId;
        }

        public final void setOutpostId(String outpostId) {
            this.outpostId = outpostId;
        }

        @Override
        public final Builder outpostId(String outpostId) {
            this.outpostId = outpostId;
            return this;
        }

        public final String getOrderId() {
            return this.orderId;
        }

        public final void setOrderId(String orderId) {
            this.orderId = orderId;
        }

        @Override
        public final Builder orderId(String orderId) {
            this.orderId = orderId;
            return this;
        }

        public final List<InstanceTypeCapacity.Builder> getRequestedInstancePools() {
            List<InstanceTypeCapacity.Builder> result = RequestedInstancePoolsCopier.copyToBuilder(this.requestedInstancePools);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRequestedInstancePools(Collection<InstanceTypeCapacity.BuilderImpl> requestedInstancePools) {
            this.requestedInstancePools = RequestedInstancePoolsCopier.copyFromBuilder(requestedInstancePools);
        }

        @Override
        public final Builder requestedInstancePools(Collection<InstanceTypeCapacity> requestedInstancePools) {
            this.requestedInstancePools = RequestedInstancePoolsCopier.copy(requestedInstancePools);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requestedInstancePools(InstanceTypeCapacity ... requestedInstancePools) {
            this.requestedInstancePools(Arrays.asList(requestedInstancePools));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requestedInstancePools(Consumer<InstanceTypeCapacity.Builder> ... requestedInstancePools) {
            this.requestedInstancePools(Stream.of(requestedInstancePools).map(c -> (InstanceTypeCapacity)((InstanceTypeCapacity.Builder)InstanceTypeCapacity.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getCapacityTaskStatus() {
            return this.capacityTaskStatus;
        }

        public final void setCapacityTaskStatus(String capacityTaskStatus) {
            this.capacityTaskStatus = capacityTaskStatus;
        }

        @Override
        public final Builder capacityTaskStatus(String capacityTaskStatus) {
            this.capacityTaskStatus = capacityTaskStatus;
            return this;
        }

        @Override
        public final Builder capacityTaskStatus(CapacityTaskStatus capacityTaskStatus) {
            this.capacityTaskStatus(capacityTaskStatus == null ? null : capacityTaskStatus.toString());
            return this;
        }

        public final CapacityTaskFailure.Builder getFailed() {
            return this.failed != null ? this.failed.toBuilder() : null;
        }

        public final void setFailed(CapacityTaskFailure.BuilderImpl failed) {
            this.failed = failed != null ? failed.build() : null;
        }

        @Override
        public final Builder failed(CapacityTaskFailure failed) {
            this.failed = failed;
            return this;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final Instant getCompletionDate() {
            return this.completionDate;
        }

        public final void setCompletionDate(Instant completionDate) {
            this.completionDate = completionDate;
        }

        @Override
        public final Builder completionDate(Instant completionDate) {
            this.completionDate = completionDate;
            return this;
        }

        public final Instant getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        @Override
        public GetCapacityTaskResponse build() {
            return new GetCapacityTaskResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OutpostsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetCapacityTaskResponse> {
        public Builder capacityTaskId(String var1);

        public Builder outpostId(String var1);

        public Builder orderId(String var1);

        public Builder requestedInstancePools(Collection<InstanceTypeCapacity> var1);

        public Builder requestedInstancePools(InstanceTypeCapacity ... var1);

        public Builder requestedInstancePools(Consumer<InstanceTypeCapacity.Builder> ... var1);

        public Builder dryRun(Boolean var1);

        public Builder capacityTaskStatus(String var1);

        public Builder capacityTaskStatus(CapacityTaskStatus var1);

        public Builder failed(CapacityTaskFailure var1);

        default public Builder failed(Consumer<CapacityTaskFailure.Builder> failed) {
            return this.failed((CapacityTaskFailure)((CapacityTaskFailure.Builder)CapacityTaskFailure.builder().applyMutation(failed)).build());
        }

        public Builder creationDate(Instant var1);

        public Builder completionDate(Instant var1);

        public Builder lastModifiedDate(Instant var1);
    }
}

