/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.outposts.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.outposts.OutpostsAsyncClient;
import software.amazon.awssdk.services.outposts.internal.UserAgentUtils;
import software.amazon.awssdk.services.outposts.model.ListOutpostsRequest;
import software.amazon.awssdk.services.outposts.model.ListOutpostsResponse;
import software.amazon.awssdk.services.outposts.model.Outpost;

public class ListOutpostsPublisher
implements SdkPublisher<ListOutpostsResponse> {
    private final OutpostsAsyncClient client;
    private final ListOutpostsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListOutpostsPublisher(OutpostsAsyncClient client, ListOutpostsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListOutpostsPublisher(OutpostsAsyncClient client, ListOutpostsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListOutpostsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListOutpostsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Outpost> outposts() {
        Function<ListOutpostsResponse, Iterator> getIterator = response -> {
            if (response != null && response.outposts() != null) {
                return response.outposts().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListOutpostsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListOutpostsResponseFetcher
    implements AsyncPageFetcher<ListOutpostsResponse> {
        private ListOutpostsResponseFetcher() {
        }

        public boolean hasNextPage(ListOutpostsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListOutpostsResponse> nextPage(ListOutpostsResponse previousPage) {
            if (previousPage == null) {
                return ListOutpostsPublisher.this.client.listOutposts(ListOutpostsPublisher.this.firstRequest);
            }
            return ListOutpostsPublisher.this.client.listOutposts((ListOutpostsRequest)((Object)ListOutpostsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

