/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.outposts.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.outposts.OutpostsAsyncClient;
import software.amazon.awssdk.services.outposts.internal.UserAgentUtils;
import software.amazon.awssdk.services.outposts.model.AssetInfo;
import software.amazon.awssdk.services.outposts.model.ListAssetsRequest;
import software.amazon.awssdk.services.outposts.model.ListAssetsResponse;

public class ListAssetsPublisher
implements SdkPublisher<ListAssetsResponse> {
    private final OutpostsAsyncClient client;
    private final ListAssetsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAssetsPublisher(OutpostsAsyncClient client, ListAssetsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAssetsPublisher(OutpostsAsyncClient client, ListAssetsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAssetsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAssetsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AssetInfo> assets() {
        Function<ListAssetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.assets() != null) {
                return response.assets().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAssetsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAssetsResponseFetcher
    implements AsyncPageFetcher<ListAssetsResponse> {
        private ListAssetsResponseFetcher() {
        }

        public boolean hasNextPage(ListAssetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAssetsResponse> nextPage(ListAssetsResponse previousPage) {
            if (previousPage == null) {
                return ListAssetsPublisher.this.client.listAssets(ListAssetsPublisher.this.firstRequest);
            }
            return ListAssetsPublisher.this.client.listAssets((ListAssetsRequest)((Object)ListAssetsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

