/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.outposts;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.outposts.DefaultOutpostsBaseClientBuilder;
import software.amazon.awssdk.services.outposts.DefaultOutpostsClient;
import software.amazon.awssdk.services.outposts.OutpostsClient;
import software.amazon.awssdk.services.outposts.OutpostsClientBuilder;
import software.amazon.awssdk.services.outposts.OutpostsServiceClientConfiguration;
import software.amazon.awssdk.services.outposts.endpoints.OutpostsEndpointProvider;

@SdkInternalApi
final class DefaultOutpostsClientBuilder
extends DefaultOutpostsBaseClientBuilder<OutpostsClientBuilder, OutpostsClient>
implements OutpostsClientBuilder {
    DefaultOutpostsClientBuilder() {
    }

    @Override
    public DefaultOutpostsClientBuilder endpointProvider(OutpostsEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final OutpostsClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultOutpostsClientBuilder.validateClientOptions(clientConfiguration);
        OutpostsServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultOutpostsClient client = new DefaultOutpostsClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private OutpostsServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return OutpostsServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

