/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.outposts.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.outposts.OutpostsClient;
import software.amazon.awssdk.services.outposts.internal.UserAgentUtils;
import software.amazon.awssdk.services.outposts.model.ListCatalogItemsRequest;
import software.amazon.awssdk.services.outposts.model.ListCatalogItemsResponse;

public class ListCatalogItemsIterable
implements SdkIterable<ListCatalogItemsResponse> {
    private final OutpostsClient client;
    private final ListCatalogItemsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCatalogItemsIterable(OutpostsClient client, ListCatalogItemsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListCatalogItemsResponseFetcher();
    }

    public Iterator<ListCatalogItemsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListCatalogItemsResponseFetcher
    implements SyncPageFetcher<ListCatalogItemsResponse> {
        private ListCatalogItemsResponseFetcher() {
        }

        public boolean hasNextPage(ListCatalogItemsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCatalogItemsResponse nextPage(ListCatalogItemsResponse previousPage) {
            if (previousPage == null) {
                return ListCatalogItemsIterable.this.client.listCatalogItems(ListCatalogItemsIterable.this.firstRequest);
            }
            return ListCatalogItemsIterable.this.client.listCatalogItems((ListCatalogItemsRequest)((Object)ListCatalogItemsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

