/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.outposts.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.outposts.OutpostsClient;
import software.amazon.awssdk.services.outposts.internal.UserAgentUtils;
import software.amazon.awssdk.services.outposts.model.ListAssetsRequest;
import software.amazon.awssdk.services.outposts.model.ListAssetsResponse;

public class ListAssetsIterable
implements SdkIterable<ListAssetsResponse> {
    private final OutpostsClient client;
    private final ListAssetsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAssetsIterable(OutpostsClient client, ListAssetsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAssetsResponseFetcher();
    }

    public Iterator<ListAssetsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListAssetsResponseFetcher
    implements SyncPageFetcher<ListAssetsResponse> {
        private ListAssetsResponseFetcher() {
        }

        public boolean hasNextPage(ListAssetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAssetsResponse nextPage(ListAssetsResponse previousPage) {
            if (previousPage == null) {
                return ListAssetsIterable.this.client.listAssets(ListAssetsIterable.this.firstRequest);
            }
            return ListAssetsIterable.this.client.listAssets((ListAssetsRequest)((Object)ListAssetsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

