/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.outposts.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.outposts.OutpostsAsyncClient;
import software.amazon.awssdk.services.outposts.model.ListAssetsRequest;
import software.amazon.awssdk.services.outposts.model.ListAssetsResponse;

public class ListAssetsPublisher
implements SdkPublisher<ListAssetsResponse> {
    private final OutpostsAsyncClient client;
    private final ListAssetsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAssetsPublisher(OutpostsAsyncClient client, ListAssetsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAssetsPublisher(OutpostsAsyncClient client, ListAssetsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAssetsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAssetsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListAssetsResponseFetcher
    implements AsyncPageFetcher<ListAssetsResponse> {
        private ListAssetsResponseFetcher() {
        }

        public boolean hasNextPage(ListAssetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAssetsResponse> nextPage(ListAssetsResponse previousPage) {
            if (previousPage == null) {
                return ListAssetsPublisher.this.client.listAssets(ListAssetsPublisher.this.firstRequest);
            }
            return ListAssetsPublisher.this.client.listAssets((ListAssetsRequest)((Object)ListAssetsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

