/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.outposts.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum OpticalStandard {
    OPTIC_10_GBASE_SR("OPTIC_10GBASE_SR"),
    OPTIC_10_GBASE_IR("OPTIC_10GBASE_IR"),
    OPTIC_10_GBASE_LR("OPTIC_10GBASE_LR"),
    OPTIC_40_GBASE_SR("OPTIC_40GBASE_SR"),
    OPTIC_40_GBASE_ESR("OPTIC_40GBASE_ESR"),
    OPTIC_40_GBASE_IR4_LR4_L("OPTIC_40GBASE_IR4_LR4L"),
    OPTIC_40_GBASE_LR4("OPTIC_40GBASE_LR4"),
    OPTIC_100_GBASE_SR4("OPTIC_100GBASE_SR4"),
    OPTIC_100_GBASE_CWDM4("OPTIC_100GBASE_CWDM4"),
    OPTIC_100_GBASE_LR4("OPTIC_100GBASE_LR4"),
    OPTIC_100_G_PSM4_MSA("OPTIC_100G_PSM4_MSA"),
    OPTIC_1000_BASE_LX("OPTIC_1000BASE_LX"),
    OPTIC_1000_BASE_SX("OPTIC_1000BASE_SX"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, OpticalStandard> VALUE_MAP;
    private final String value;

    private OpticalStandard(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OpticalStandard fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<OpticalStandard> knownValues() {
        EnumSet<OpticalStandard> knownValues = EnumSet.allOf(OpticalStandard.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(OpticalStandard.class, OpticalStandard::toString);
    }
}

