/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.outposts.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AddressType {
    SHIPPING_ADDRESS("SHIPPING_ADDRESS"),
    OPERATING_ADDRESS("OPERATING_ADDRESS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AddressType> VALUE_MAP;
    private final String value;

    private AddressType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AddressType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AddressType> knownValues() {
        EnumSet<AddressType> knownValues = EnumSet.allOf(AddressType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AddressType.class, AddressType::toString);
    }
}

