/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.outposts.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PowerPhase {
    SINGLE_PHASE("SINGLE_PHASE"),
    THREE_PHASE("THREE_PHASE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PowerPhase> VALUE_MAP;
    private final String value;

    private PowerPhase(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PowerPhase fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PowerPhase> knownValues() {
        EnumSet<PowerPhase> knownValues = EnumSet.allOf(PowerPhase.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PowerPhase.class, PowerPhase::toString);
    }
}

