/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.outposts;

import java.util.function.Consumer;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.outposts.DefaultOutpostsClientBuilder;
import software.amazon.awssdk.services.outposts.OutpostsClientBuilder;
import software.amazon.awssdk.services.outposts.model.AccessDeniedException;
import software.amazon.awssdk.services.outposts.model.CreateOutpostRequest;
import software.amazon.awssdk.services.outposts.model.CreateOutpostResponse;
import software.amazon.awssdk.services.outposts.model.GetOutpostInstanceTypesRequest;
import software.amazon.awssdk.services.outposts.model.GetOutpostInstanceTypesResponse;
import software.amazon.awssdk.services.outposts.model.GetOutpostRequest;
import software.amazon.awssdk.services.outposts.model.GetOutpostResponse;
import software.amazon.awssdk.services.outposts.model.InternalServerException;
import software.amazon.awssdk.services.outposts.model.ListOutpostsRequest;
import software.amazon.awssdk.services.outposts.model.ListOutpostsResponse;
import software.amazon.awssdk.services.outposts.model.ListSitesRequest;
import software.amazon.awssdk.services.outposts.model.ListSitesResponse;
import software.amazon.awssdk.services.outposts.model.NotFoundException;
import software.amazon.awssdk.services.outposts.model.OutpostsException;
import software.amazon.awssdk.services.outposts.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.outposts.model.ValidationException;
import software.amazon.awssdk.services.outposts.paginators.ListOutpostsIterable;
import software.amazon.awssdk.services.outposts.paginators.ListSitesIterable;

public interface OutpostsClient
extends SdkClient {
    public static final String SERVICE_NAME = "outposts";

    public static OutpostsClient create() {
        return (OutpostsClient)OutpostsClient.builder().build();
    }

    public static OutpostsClientBuilder builder() {
        return new DefaultOutpostsClientBuilder();
    }

    default public CreateOutpostResponse createOutpost(CreateOutpostRequest createOutpostRequest) throws ValidationException, NotFoundException, AccessDeniedException, InternalServerException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, OutpostsException {
        throw new UnsupportedOperationException();
    }

    default public CreateOutpostResponse createOutpost(Consumer<CreateOutpostRequest.Builder> createOutpostRequest) throws ValidationException, NotFoundException, AccessDeniedException, InternalServerException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, OutpostsException {
        return this.createOutpost((CreateOutpostRequest)((Object)((CreateOutpostRequest.Builder)CreateOutpostRequest.builder().applyMutation(createOutpostRequest)).build()));
    }

    default public GetOutpostResponse getOutpost(GetOutpostRequest getOutpostRequest) throws ValidationException, NotFoundException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, OutpostsException {
        throw new UnsupportedOperationException();
    }

    default public GetOutpostResponse getOutpost(Consumer<GetOutpostRequest.Builder> getOutpostRequest) throws ValidationException, NotFoundException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, OutpostsException {
        return this.getOutpost((GetOutpostRequest)((Object)((GetOutpostRequest.Builder)GetOutpostRequest.builder().applyMutation(getOutpostRequest)).build()));
    }

    default public GetOutpostInstanceTypesResponse getOutpostInstanceTypes(GetOutpostInstanceTypesRequest getOutpostInstanceTypesRequest) throws ValidationException, NotFoundException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, OutpostsException {
        throw new UnsupportedOperationException();
    }

    default public GetOutpostInstanceTypesResponse getOutpostInstanceTypes(Consumer<GetOutpostInstanceTypesRequest.Builder> getOutpostInstanceTypesRequest) throws ValidationException, NotFoundException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, OutpostsException {
        return this.getOutpostInstanceTypes((GetOutpostInstanceTypesRequest)((Object)((GetOutpostInstanceTypesRequest.Builder)GetOutpostInstanceTypesRequest.builder().applyMutation(getOutpostInstanceTypesRequest)).build()));
    }

    default public ListOutpostsResponse listOutposts(ListOutpostsRequest listOutpostsRequest) throws ValidationException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, OutpostsException {
        throw new UnsupportedOperationException();
    }

    default public ListOutpostsResponse listOutposts(Consumer<ListOutpostsRequest.Builder> listOutpostsRequest) throws ValidationException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, OutpostsException {
        return this.listOutposts((ListOutpostsRequest)((Object)((ListOutpostsRequest.Builder)ListOutpostsRequest.builder().applyMutation(listOutpostsRequest)).build()));
    }

    default public ListOutpostsIterable listOutpostsPaginator(ListOutpostsRequest listOutpostsRequest) throws ValidationException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, OutpostsException {
        throw new UnsupportedOperationException();
    }

    default public ListOutpostsIterable listOutpostsPaginator(Consumer<ListOutpostsRequest.Builder> listOutpostsRequest) throws ValidationException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, OutpostsException {
        return this.listOutpostsPaginator((ListOutpostsRequest)((Object)((ListOutpostsRequest.Builder)ListOutpostsRequest.builder().applyMutation(listOutpostsRequest)).build()));
    }

    default public ListSitesResponse listSites(ListSitesRequest listSitesRequest) throws ValidationException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, OutpostsException {
        throw new UnsupportedOperationException();
    }

    default public ListSitesResponse listSites(Consumer<ListSitesRequest.Builder> listSitesRequest) throws ValidationException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, OutpostsException {
        return this.listSites((ListSitesRequest)((Object)((ListSitesRequest.Builder)ListSitesRequest.builder().applyMutation(listSitesRequest)).build()));
    }

    default public ListSitesIterable listSitesPaginator(ListSitesRequest listSitesRequest) throws ValidationException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, OutpostsException {
        throw new UnsupportedOperationException();
    }

    default public ListSitesIterable listSitesPaginator(Consumer<ListSitesRequest.Builder> listSitesRequest) throws ValidationException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, OutpostsException {
        return this.listSitesPaginator((ListSitesRequest)((Object)((ListSitesRequest.Builder)ListSitesRequest.builder().applyMutation(listSitesRequest)).build()));
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)SERVICE_NAME);
    }
}

