/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearchserverless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.opensearchserverless.model.LifecyclePolicyType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LifecyclePolicyResourceIdentifier
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LifecyclePolicyResourceIdentifier> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(LifecyclePolicyResourceIdentifier.getter(LifecyclePolicyResourceIdentifier::typeAsString)).setter(LifecyclePolicyResourceIdentifier.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resource").getter(LifecyclePolicyResourceIdentifier.getter(LifecyclePolicyResourceIdentifier::resource)).setter(LifecyclePolicyResourceIdentifier.setter(Builder::resource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resource").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, RESOURCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LifecyclePolicyResourceIdentifier.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String type;
    private final String resource;

    private LifecyclePolicyResourceIdentifier(BuilderImpl builder) {
        this.type = builder.type;
        this.resource = builder.resource;
    }

    public final LifecyclePolicyType type() {
        return LifecyclePolicyType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String resource() {
        return this.resource;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resource());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LifecyclePolicyResourceIdentifier)) {
            return false;
        }
        LifecyclePolicyResourceIdentifier other = (LifecyclePolicyResourceIdentifier)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.resource(), other.resource());
    }

    public final String toString() {
        return ToString.builder((String)"LifecyclePolicyResourceIdentifier").add("Type", (Object)this.typeAsString()).add("Resource", (Object)this.resource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "resource": {
                return Optional.ofNullable(clazz.cast(this.resource()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("type", TYPE_FIELD);
        map.put("resource", RESOURCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LifecyclePolicyResourceIdentifier, T> g) {
        return obj -> g.apply((LifecyclePolicyResourceIdentifier)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String resource;

        private BuilderImpl() {
        }

        private BuilderImpl(LifecyclePolicyResourceIdentifier model) {
            this.type(model.type);
            this.resource(model.resource);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(LifecyclePolicyType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getResource() {
            return this.resource;
        }

        public final void setResource(String resource) {
            this.resource = resource;
        }

        @Override
        public final Builder resource(String resource) {
            this.resource = resource;
            return this;
        }

        public LifecyclePolicyResourceIdentifier build() {
            return new LifecyclePolicyResourceIdentifier(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LifecyclePolicyResourceIdentifier> {
        public Builder type(String var1);

        public Builder type(LifecyclePolicyType var1);

        public Builder resource(String var1);
    }
}

