/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearchserverless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.opensearchserverless.model.CollectionSummariesCopier;
import software.amazon.awssdk.services.opensearchserverless.model.CollectionSummary;
import software.amazon.awssdk.services.opensearchserverless.model.OpenSearchServerlessResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCollectionsResponse
extends OpenSearchServerlessResponse
implements ToCopyableBuilder<Builder, ListCollectionsResponse> {
    private static final SdkField<List<CollectionSummary>> COLLECTION_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("collectionSummaries").getter(ListCollectionsResponse.getter(ListCollectionsResponse::collectionSummaries)).setter(ListCollectionsResponse.setter(Builder::collectionSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collectionSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CollectionSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListCollectionsResponse.getter(ListCollectionsResponse::nextToken)).setter(ListCollectionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLLECTION_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListCollectionsResponse.memberNameToFieldInitializer();
    private final List<CollectionSummary> collectionSummaries;
    private final String nextToken;

    private ListCollectionsResponse(BuilderImpl builder) {
        super(builder);
        this.collectionSummaries = builder.collectionSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasCollectionSummaries() {
        return this.collectionSummaries != null && !(this.collectionSummaries instanceof SdkAutoConstructList);
    }

    public final List<CollectionSummary> collectionSummaries() {
        return this.collectionSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCollectionSummaries() ? this.collectionSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCollectionsResponse)) {
            return false;
        }
        ListCollectionsResponse other = (ListCollectionsResponse)((Object)obj);
        return this.hasCollectionSummaries() == other.hasCollectionSummaries() && Objects.equals(this.collectionSummaries(), other.collectionSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListCollectionsResponse").add("CollectionSummaries", this.hasCollectionSummaries() ? this.collectionSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "collectionSummaries": {
                return Optional.ofNullable(clazz.cast(this.collectionSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("collectionSummaries", COLLECTION_SUMMARIES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCollectionsResponse, T> g) {
        return obj -> g.apply((ListCollectionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OpenSearchServerlessResponse.BuilderImpl
    implements Builder {
        private List<CollectionSummary> collectionSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCollectionsResponse model) {
            super(model);
            this.collectionSummaries(model.collectionSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<CollectionSummary.Builder> getCollectionSummaries() {
            List<CollectionSummary.Builder> result = CollectionSummariesCopier.copyToBuilder(this.collectionSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCollectionSummaries(Collection<CollectionSummary.BuilderImpl> collectionSummaries) {
            this.collectionSummaries = CollectionSummariesCopier.copyFromBuilder(collectionSummaries);
        }

        @Override
        public final Builder collectionSummaries(Collection<CollectionSummary> collectionSummaries) {
            this.collectionSummaries = CollectionSummariesCopier.copy(collectionSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder collectionSummaries(CollectionSummary ... collectionSummaries) {
            this.collectionSummaries(Arrays.asList(collectionSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder collectionSummaries(Consumer<CollectionSummary.Builder> ... collectionSummaries) {
            this.collectionSummaries(Stream.of(collectionSummaries).map(c -> (CollectionSummary)((CollectionSummary.Builder)CollectionSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListCollectionsResponse build() {
            return new ListCollectionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends OpenSearchServerlessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCollectionsResponse> {
        public Builder collectionSummaries(Collection<CollectionSummary> var1);

        public Builder collectionSummaries(CollectionSummary ... var1);

        public Builder collectionSummaries(Consumer<CollectionSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

