/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearchserverless.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.opensearchserverless.OpenSearchServerlessAsyncClient;
import software.amazon.awssdk.services.opensearchserverless.internal.UserAgentUtils;
import software.amazon.awssdk.services.opensearchserverless.model.ListCollectionsRequest;
import software.amazon.awssdk.services.opensearchserverless.model.ListCollectionsResponse;

public class ListCollectionsPublisher
implements SdkPublisher<ListCollectionsResponse> {
    private final OpenSearchServerlessAsyncClient client;
    private final ListCollectionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCollectionsPublisher(OpenSearchServerlessAsyncClient client, ListCollectionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCollectionsPublisher(OpenSearchServerlessAsyncClient client, ListCollectionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCollectionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCollectionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListCollectionsResponseFetcher
    implements AsyncPageFetcher<ListCollectionsResponse> {
        private ListCollectionsResponseFetcher() {
        }

        public boolean hasNextPage(ListCollectionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCollectionsResponse> nextPage(ListCollectionsResponse previousPage) {
            if (previousPage == null) {
                return ListCollectionsPublisher.this.client.listCollections(ListCollectionsPublisher.this.firstRequest);
            }
            return ListCollectionsPublisher.this.client.listCollections((ListCollectionsRequest)((Object)ListCollectionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

