/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearchserverless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.opensearchserverless.model.LifecyclePolicyType;
import software.amazon.awssdk.services.opensearchserverless.model.ResourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EffectiveLifecyclePolicyDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EffectiveLifecyclePolicyDetail> {
    private static final SdkField<Boolean> NO_MIN_RETENTION_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("noMinRetentionPeriod").getter(EffectiveLifecyclePolicyDetail.getter(EffectiveLifecyclePolicyDetail::noMinRetentionPeriod)).setter(EffectiveLifecyclePolicyDetail.setter(Builder::noMinRetentionPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("noMinRetentionPeriod").build()}).build();
    private static final SdkField<String> POLICY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policyName").getter(EffectiveLifecyclePolicyDetail.getter(EffectiveLifecyclePolicyDetail::policyName)).setter(EffectiveLifecyclePolicyDetail.setter(Builder::policyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyName").build()}).build();
    private static final SdkField<String> RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resource").getter(EffectiveLifecyclePolicyDetail.getter(EffectiveLifecyclePolicyDetail::resource)).setter(EffectiveLifecyclePolicyDetail.setter(Builder::resource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resource").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceType").getter(EffectiveLifecyclePolicyDetail.getter(EffectiveLifecyclePolicyDetail::resourceTypeAsString)).setter(EffectiveLifecyclePolicyDetail.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()}).build();
    private static final SdkField<String> RETENTION_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("retentionPeriod").getter(EffectiveLifecyclePolicyDetail.getter(EffectiveLifecyclePolicyDetail::retentionPeriod)).setter(EffectiveLifecyclePolicyDetail.setter(Builder::retentionPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retentionPeriod").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(EffectiveLifecyclePolicyDetail.getter(EffectiveLifecyclePolicyDetail::typeAsString)).setter(EffectiveLifecyclePolicyDetail.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NO_MIN_RETENTION_PERIOD_FIELD, POLICY_NAME_FIELD, RESOURCE_FIELD, RESOURCE_TYPE_FIELD, RETENTION_PERIOD_FIELD, TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean noMinRetentionPeriod;
    private final String policyName;
    private final String resource;
    private final String resourceType;
    private final String retentionPeriod;
    private final String type;

    private EffectiveLifecyclePolicyDetail(BuilderImpl builder) {
        this.noMinRetentionPeriod = builder.noMinRetentionPeriod;
        this.policyName = builder.policyName;
        this.resource = builder.resource;
        this.resourceType = builder.resourceType;
        this.retentionPeriod = builder.retentionPeriod;
        this.type = builder.type;
    }

    public final Boolean noMinRetentionPeriod() {
        return this.noMinRetentionPeriod;
    }

    public final String policyName() {
        return this.policyName;
    }

    public final String resource() {
        return this.resource;
    }

    public final ResourceType resourceType() {
        return ResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public final String retentionPeriod() {
        return this.retentionPeriod;
    }

    public final LifecyclePolicyType type() {
        return LifecyclePolicyType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.noMinRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.resource());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.retentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EffectiveLifecyclePolicyDetail)) {
            return false;
        }
        EffectiveLifecyclePolicyDetail other = (EffectiveLifecyclePolicyDetail)obj;
        return Objects.equals(this.noMinRetentionPeriod(), other.noMinRetentionPeriod()) && Objects.equals(this.policyName(), other.policyName()) && Objects.equals(this.resource(), other.resource()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.retentionPeriod(), other.retentionPeriod()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"EffectiveLifecyclePolicyDetail").add("NoMinRetentionPeriod", (Object)this.noMinRetentionPeriod()).add("PolicyName", (Object)this.policyName()).add("Resource", (Object)this.resource()).add("ResourceType", (Object)this.resourceTypeAsString()).add("RetentionPeriod", (Object)this.retentionPeriod()).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "noMinRetentionPeriod": {
                return Optional.ofNullable(clazz.cast(this.noMinRetentionPeriod()));
            }
            case "policyName": {
                return Optional.ofNullable(clazz.cast(this.policyName()));
            }
            case "resource": {
                return Optional.ofNullable(clazz.cast(this.resource()));
            }
            case "resourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "retentionPeriod": {
                return Optional.ofNullable(clazz.cast(this.retentionPeriod()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EffectiveLifecyclePolicyDetail, T> g) {
        return obj -> g.apply((EffectiveLifecyclePolicyDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean noMinRetentionPeriod;
        private String policyName;
        private String resource;
        private String resourceType;
        private String retentionPeriod;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(EffectiveLifecyclePolicyDetail model) {
            this.noMinRetentionPeriod(model.noMinRetentionPeriod);
            this.policyName(model.policyName);
            this.resource(model.resource);
            this.resourceType(model.resourceType);
            this.retentionPeriod(model.retentionPeriod);
            this.type(model.type);
        }

        public final Boolean getNoMinRetentionPeriod() {
            return this.noMinRetentionPeriod;
        }

        public final void setNoMinRetentionPeriod(Boolean noMinRetentionPeriod) {
            this.noMinRetentionPeriod = noMinRetentionPeriod;
        }

        @Override
        public final Builder noMinRetentionPeriod(Boolean noMinRetentionPeriod) {
            this.noMinRetentionPeriod = noMinRetentionPeriod;
            return this;
        }

        public final String getPolicyName() {
            return this.policyName;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final String getResource() {
            return this.resource;
        }

        public final void setResource(String resource) {
            this.resource = resource;
        }

        @Override
        public final Builder resource(String resource) {
            this.resource = resource;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final String getRetentionPeriod() {
            return this.retentionPeriod;
        }

        public final void setRetentionPeriod(String retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
        }

        @Override
        public final Builder retentionPeriod(String retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(LifecyclePolicyType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public EffectiveLifecyclePolicyDetail build() {
            return new EffectiveLifecyclePolicyDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EffectiveLifecyclePolicyDetail> {
        public Builder noMinRetentionPeriod(Boolean var1);

        public Builder policyName(String var1);

        public Builder resource(String var1);

        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);

        public Builder retentionPeriod(String var1);

        public Builder type(String var1);

        public Builder type(LifecyclePolicyType var1);
    }
}

