/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearchserverless.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.opensearchserverless.OpenSearchServerlessClient;
import software.amazon.awssdk.services.opensearchserverless.internal.UserAgentUtils;
import software.amazon.awssdk.services.opensearchserverless.model.ListSecurityPoliciesRequest;
import software.amazon.awssdk.services.opensearchserverless.model.ListSecurityPoliciesResponse;

public class ListSecurityPoliciesIterable
implements SdkIterable<ListSecurityPoliciesResponse> {
    private final OpenSearchServerlessClient client;
    private final ListSecurityPoliciesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSecurityPoliciesIterable(OpenSearchServerlessClient client, ListSecurityPoliciesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSecurityPoliciesResponseFetcher();
    }

    public Iterator<ListSecurityPoliciesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListSecurityPoliciesResponseFetcher
    implements SyncPageFetcher<ListSecurityPoliciesResponse> {
        private ListSecurityPoliciesResponseFetcher() {
        }

        public boolean hasNextPage(ListSecurityPoliciesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSecurityPoliciesResponse nextPage(ListSecurityPoliciesResponse previousPage) {
            if (previousPage == null) {
                return ListSecurityPoliciesIterable.this.client.listSecurityPolicies(ListSecurityPoliciesIterable.this.firstRequest);
            }
            return ListSecurityPoliciesIterable.this.client.listSecurityPolicies((ListSecurityPoliciesRequest)((Object)ListSecurityPoliciesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

