/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearchserverless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.opensearchserverless.model.EffectiveLifecyclePolicyDetail;
import software.amazon.awssdk.services.opensearchserverless.model.EffectiveLifecyclePolicyDetailsCopier;
import software.amazon.awssdk.services.opensearchserverless.model.EffectiveLifecyclePolicyErrorDetail;
import software.amazon.awssdk.services.opensearchserverless.model.EffectiveLifecyclePolicyErrorDetailsCopier;
import software.amazon.awssdk.services.opensearchserverless.model.OpenSearchServerlessResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetEffectiveLifecyclePolicyResponse
extends OpenSearchServerlessResponse
implements ToCopyableBuilder<Builder, BatchGetEffectiveLifecyclePolicyResponse> {
    private static final SdkField<List<EffectiveLifecyclePolicyDetail>> EFFECTIVE_LIFECYCLE_POLICY_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("effectiveLifecyclePolicyDetails").getter(BatchGetEffectiveLifecyclePolicyResponse.getter(BatchGetEffectiveLifecyclePolicyResponse::effectiveLifecyclePolicyDetails)).setter(BatchGetEffectiveLifecyclePolicyResponse.setter(Builder::effectiveLifecyclePolicyDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("effectiveLifecyclePolicyDetails").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EffectiveLifecyclePolicyDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<EffectiveLifecyclePolicyErrorDetail>> EFFECTIVE_LIFECYCLE_POLICY_ERROR_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("effectiveLifecyclePolicyErrorDetails").getter(BatchGetEffectiveLifecyclePolicyResponse.getter(BatchGetEffectiveLifecyclePolicyResponse::effectiveLifecyclePolicyErrorDetails)).setter(BatchGetEffectiveLifecyclePolicyResponse.setter(Builder::effectiveLifecyclePolicyErrorDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("effectiveLifecyclePolicyErrorDetails").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EffectiveLifecyclePolicyErrorDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EFFECTIVE_LIFECYCLE_POLICY_DETAILS_FIELD, EFFECTIVE_LIFECYCLE_POLICY_ERROR_DETAILS_FIELD));
    private final List<EffectiveLifecyclePolicyDetail> effectiveLifecyclePolicyDetails;
    private final List<EffectiveLifecyclePolicyErrorDetail> effectiveLifecyclePolicyErrorDetails;

    private BatchGetEffectiveLifecyclePolicyResponse(BuilderImpl builder) {
        super(builder);
        this.effectiveLifecyclePolicyDetails = builder.effectiveLifecyclePolicyDetails;
        this.effectiveLifecyclePolicyErrorDetails = builder.effectiveLifecyclePolicyErrorDetails;
    }

    public final boolean hasEffectiveLifecyclePolicyDetails() {
        return this.effectiveLifecyclePolicyDetails != null && !(this.effectiveLifecyclePolicyDetails instanceof SdkAutoConstructList);
    }

    public final List<EffectiveLifecyclePolicyDetail> effectiveLifecyclePolicyDetails() {
        return this.effectiveLifecyclePolicyDetails;
    }

    public final boolean hasEffectiveLifecyclePolicyErrorDetails() {
        return this.effectiveLifecyclePolicyErrorDetails != null && !(this.effectiveLifecyclePolicyErrorDetails instanceof SdkAutoConstructList);
    }

    public final List<EffectiveLifecyclePolicyErrorDetail> effectiveLifecyclePolicyErrorDetails() {
        return this.effectiveLifecyclePolicyErrorDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEffectiveLifecyclePolicyDetails() ? this.effectiveLifecyclePolicyDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEffectiveLifecyclePolicyErrorDetails() ? this.effectiveLifecyclePolicyErrorDetails() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetEffectiveLifecyclePolicyResponse)) {
            return false;
        }
        BatchGetEffectiveLifecyclePolicyResponse other = (BatchGetEffectiveLifecyclePolicyResponse)((Object)obj);
        return this.hasEffectiveLifecyclePolicyDetails() == other.hasEffectiveLifecyclePolicyDetails() && Objects.equals(this.effectiveLifecyclePolicyDetails(), other.effectiveLifecyclePolicyDetails()) && this.hasEffectiveLifecyclePolicyErrorDetails() == other.hasEffectiveLifecyclePolicyErrorDetails() && Objects.equals(this.effectiveLifecyclePolicyErrorDetails(), other.effectiveLifecyclePolicyErrorDetails());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetEffectiveLifecyclePolicyResponse").add("EffectiveLifecyclePolicyDetails", this.hasEffectiveLifecyclePolicyDetails() ? this.effectiveLifecyclePolicyDetails() : null).add("EffectiveLifecyclePolicyErrorDetails", this.hasEffectiveLifecyclePolicyErrorDetails() ? this.effectiveLifecyclePolicyErrorDetails() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "effectiveLifecyclePolicyDetails": {
                return Optional.ofNullable(clazz.cast(this.effectiveLifecyclePolicyDetails()));
            }
            case "effectiveLifecyclePolicyErrorDetails": {
                return Optional.ofNullable(clazz.cast(this.effectiveLifecyclePolicyErrorDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetEffectiveLifecyclePolicyResponse, T> g) {
        return obj -> g.apply((BatchGetEffectiveLifecyclePolicyResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OpenSearchServerlessResponse.BuilderImpl
    implements Builder {
        private List<EffectiveLifecyclePolicyDetail> effectiveLifecyclePolicyDetails = DefaultSdkAutoConstructList.getInstance();
        private List<EffectiveLifecyclePolicyErrorDetail> effectiveLifecyclePolicyErrorDetails = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetEffectiveLifecyclePolicyResponse model) {
            super(model);
            this.effectiveLifecyclePolicyDetails(model.effectiveLifecyclePolicyDetails);
            this.effectiveLifecyclePolicyErrorDetails(model.effectiveLifecyclePolicyErrorDetails);
        }

        public final List<EffectiveLifecyclePolicyDetail.Builder> getEffectiveLifecyclePolicyDetails() {
            List<EffectiveLifecyclePolicyDetail.Builder> result = EffectiveLifecyclePolicyDetailsCopier.copyToBuilder(this.effectiveLifecyclePolicyDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEffectiveLifecyclePolicyDetails(Collection<EffectiveLifecyclePolicyDetail.BuilderImpl> effectiveLifecyclePolicyDetails) {
            this.effectiveLifecyclePolicyDetails = EffectiveLifecyclePolicyDetailsCopier.copyFromBuilder(effectiveLifecyclePolicyDetails);
        }

        @Override
        public final Builder effectiveLifecyclePolicyDetails(Collection<EffectiveLifecyclePolicyDetail> effectiveLifecyclePolicyDetails) {
            this.effectiveLifecyclePolicyDetails = EffectiveLifecyclePolicyDetailsCopier.copy(effectiveLifecyclePolicyDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder effectiveLifecyclePolicyDetails(EffectiveLifecyclePolicyDetail ... effectiveLifecyclePolicyDetails) {
            this.effectiveLifecyclePolicyDetails(Arrays.asList(effectiveLifecyclePolicyDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder effectiveLifecyclePolicyDetails(Consumer<EffectiveLifecyclePolicyDetail.Builder> ... effectiveLifecyclePolicyDetails) {
            this.effectiveLifecyclePolicyDetails(Stream.of(effectiveLifecyclePolicyDetails).map(c -> (EffectiveLifecyclePolicyDetail)((EffectiveLifecyclePolicyDetail.Builder)EffectiveLifecyclePolicyDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<EffectiveLifecyclePolicyErrorDetail.Builder> getEffectiveLifecyclePolicyErrorDetails() {
            List<EffectiveLifecyclePolicyErrorDetail.Builder> result = EffectiveLifecyclePolicyErrorDetailsCopier.copyToBuilder(this.effectiveLifecyclePolicyErrorDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEffectiveLifecyclePolicyErrorDetails(Collection<EffectiveLifecyclePolicyErrorDetail.BuilderImpl> effectiveLifecyclePolicyErrorDetails) {
            this.effectiveLifecyclePolicyErrorDetails = EffectiveLifecyclePolicyErrorDetailsCopier.copyFromBuilder(effectiveLifecyclePolicyErrorDetails);
        }

        @Override
        public final Builder effectiveLifecyclePolicyErrorDetails(Collection<EffectiveLifecyclePolicyErrorDetail> effectiveLifecyclePolicyErrorDetails) {
            this.effectiveLifecyclePolicyErrorDetails = EffectiveLifecyclePolicyErrorDetailsCopier.copy(effectiveLifecyclePolicyErrorDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder effectiveLifecyclePolicyErrorDetails(EffectiveLifecyclePolicyErrorDetail ... effectiveLifecyclePolicyErrorDetails) {
            this.effectiveLifecyclePolicyErrorDetails(Arrays.asList(effectiveLifecyclePolicyErrorDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder effectiveLifecyclePolicyErrorDetails(Consumer<EffectiveLifecyclePolicyErrorDetail.Builder> ... effectiveLifecyclePolicyErrorDetails) {
            this.effectiveLifecyclePolicyErrorDetails(Stream.of(effectiveLifecyclePolicyErrorDetails).map(c -> (EffectiveLifecyclePolicyErrorDetail)((EffectiveLifecyclePolicyErrorDetail.Builder)EffectiveLifecyclePolicyErrorDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetEffectiveLifecyclePolicyResponse build() {
            return new BatchGetEffectiveLifecyclePolicyResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OpenSearchServerlessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetEffectiveLifecyclePolicyResponse> {
        public Builder effectiveLifecyclePolicyDetails(Collection<EffectiveLifecyclePolicyDetail> var1);

        public Builder effectiveLifecyclePolicyDetails(EffectiveLifecyclePolicyDetail ... var1);

        public Builder effectiveLifecyclePolicyDetails(Consumer<EffectiveLifecyclePolicyDetail.Builder> ... var1);

        public Builder effectiveLifecyclePolicyErrorDetails(Collection<EffectiveLifecyclePolicyErrorDetail> var1);

        public Builder effectiveLifecyclePolicyErrorDetails(EffectiveLifecyclePolicyErrorDetail ... var1);

        public Builder effectiveLifecyclePolicyErrorDetails(Consumer<EffectiveLifecyclePolicyErrorDetail.Builder> ... var1);
    }
}

