/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearchserverless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListVpcEndpointsRequest extends OpenSearchServerlessRequest implements
        ToCopyableBuilder<ListVpcEndpointsRequest.Builder, ListVpcEndpointsRequest> {
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListVpcEndpointsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListVpcEndpointsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<VpcEndpointFilters> VPC_ENDPOINT_FILTERS_FIELD = SdkField
            .<VpcEndpointFilters> builder(MarshallingType.SDK_POJO).memberName("vpcEndpointFilters")
            .getter(getter(ListVpcEndpointsRequest::vpcEndpointFilters)).setter(setter(Builder::vpcEndpointFilters))
            .constructor(VpcEndpointFilters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcEndpointFilters").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_RESULTS_FIELD,
            NEXT_TOKEN_FIELD, VPC_ENDPOINT_FILTERS_FIELD));

    private final Integer maxResults;

    private final String nextToken;

    private final VpcEndpointFilters vpcEndpointFilters;

    private ListVpcEndpointsRequest(BuilderImpl builder) {
        super(builder);
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.vpcEndpointFilters = builder.vpcEndpointFilters;
    }

    /**
     * <p>
     * An optional parameter that specifies the maximum number of results to return. You can use <code>nextToken</code>
     * to get the next page of results. The default is 20.
     * </p>
     * 
     * @return An optional parameter that specifies the maximum number of results to return. You can use
     *         <code>nextToken</code> to get the next page of results. The default is 20.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * If your initial <code>ListVpcEndpoints</code> operation returns a <code>nextToken</code>, you can include the
     * returned <code>nextToken</code> in subsequent <code>ListVpcEndpoints</code> operations, which returns results in
     * the next page.
     * </p>
     * 
     * @return If your initial <code>ListVpcEndpoints</code> operation returns a <code>nextToken</code>, you can include
     *         the returned <code>nextToken</code> in subsequent <code>ListVpcEndpoints</code> operations, which returns
     *         results in the next page.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Filter the results according to the current status of the VPC endpoint. Possible statuses are
     * <code>CREATING</code>, <code>DELETING</code>, <code>UPDATING</code>, <code>ACTIVE</code>, and <code>FAILED</code>
     * .
     * </p>
     * 
     * @return Filter the results according to the current status of the VPC endpoint. Possible statuses are
     *         <code>CREATING</code>, <code>DELETING</code>, <code>UPDATING</code>, <code>ACTIVE</code>, and
     *         <code>FAILED</code>.
     */
    public final VpcEndpointFilters vpcEndpointFilters() {
        return vpcEndpointFilters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(vpcEndpointFilters());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVpcEndpointsRequest)) {
            return false;
        }
        ListVpcEndpointsRequest other = (ListVpcEndpointsRequest) obj;
        return Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(vpcEndpointFilters(), other.vpcEndpointFilters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListVpcEndpointsRequest").add("MaxResults", maxResults()).add("NextToken", nextToken())
                .add("VpcEndpointFilters", vpcEndpointFilters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "vpcEndpointFilters":
            return Optional.ofNullable(clazz.cast(vpcEndpointFilters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListVpcEndpointsRequest, T> g) {
        return obj -> g.apply((ListVpcEndpointsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpenSearchServerlessRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListVpcEndpointsRequest> {
        /**
         * <p>
         * An optional parameter that specifies the maximum number of results to return. You can use
         * <code>nextToken</code> to get the next page of results. The default is 20.
         * </p>
         * 
         * @param maxResults
         *        An optional parameter that specifies the maximum number of results to return. You can use
         *        <code>nextToken</code> to get the next page of results. The default is 20.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * If your initial <code>ListVpcEndpoints</code> operation returns a <code>nextToken</code>, you can include the
         * returned <code>nextToken</code> in subsequent <code>ListVpcEndpoints</code> operations, which returns results
         * in the next page.
         * </p>
         * 
         * @param nextToken
         *        If your initial <code>ListVpcEndpoints</code> operation returns a <code>nextToken</code>, you can
         *        include the returned <code>nextToken</code> in subsequent <code>ListVpcEndpoints</code> operations,
         *        which returns results in the next page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Filter the results according to the current status of the VPC endpoint. Possible statuses are
         * <code>CREATING</code>, <code>DELETING</code>, <code>UPDATING</code>, <code>ACTIVE</code>, and
         * <code>FAILED</code>.
         * </p>
         * 
         * @param vpcEndpointFilters
         *        Filter the results according to the current status of the VPC endpoint. Possible statuses are
         *        <code>CREATING</code>, <code>DELETING</code>, <code>UPDATING</code>, <code>ACTIVE</code>, and
         *        <code>FAILED</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpointFilters(VpcEndpointFilters vpcEndpointFilters);

        /**
         * <p>
         * Filter the results according to the current status of the VPC endpoint. Possible statuses are
         * <code>CREATING</code>, <code>DELETING</code>, <code>UPDATING</code>, <code>ACTIVE</code>, and
         * <code>FAILED</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link VpcEndpointFilters.Builder} avoiding the
         * need to create one manually via {@link VpcEndpointFilters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VpcEndpointFilters.Builder#build()} is called immediately and its
         * result is passed to {@link #vpcEndpointFilters(VpcEndpointFilters)}.
         * 
         * @param vpcEndpointFilters
         *        a consumer that will call methods on {@link VpcEndpointFilters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcEndpointFilters(VpcEndpointFilters)
         */
        default Builder vpcEndpointFilters(Consumer<VpcEndpointFilters.Builder> vpcEndpointFilters) {
            return vpcEndpointFilters(VpcEndpointFilters.builder().applyMutation(vpcEndpointFilters).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OpenSearchServerlessRequest.BuilderImpl implements Builder {
        private Integer maxResults;

        private String nextToken;

        private VpcEndpointFilters vpcEndpointFilters;

        private BuilderImpl() {
        }

        private BuilderImpl(ListVpcEndpointsRequest model) {
            super(model);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            vpcEndpointFilters(model.vpcEndpointFilters);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final VpcEndpointFilters.Builder getVpcEndpointFilters() {
            return vpcEndpointFilters != null ? vpcEndpointFilters.toBuilder() : null;
        }

        public final void setVpcEndpointFilters(VpcEndpointFilters.BuilderImpl vpcEndpointFilters) {
            this.vpcEndpointFilters = vpcEndpointFilters != null ? vpcEndpointFilters.build() : null;
        }

        @Override
        public final Builder vpcEndpointFilters(VpcEndpointFilters vpcEndpointFilters) {
            this.vpcEndpointFilters = vpcEndpointFilters;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListVpcEndpointsRequest build() {
            return new ListVpcEndpointsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
