/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearchserverless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of the data access policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccessPolicySummary implements SdkPojo, Serializable,
        ToCopyableBuilder<AccessPolicySummary.Builder, AccessPolicySummary> {
    private static final SdkField<Long> CREATED_DATE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("createdDate").getter(getter(AccessPolicySummary::createdDate)).setter(setter(Builder::createdDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdDate").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(AccessPolicySummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Long> LAST_MODIFIED_DATE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("lastModifiedDate").getter(getter(AccessPolicySummary::lastModifiedDate))
            .setter(setter(Builder::lastModifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedDate").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(AccessPolicySummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> POLICY_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyVersion").getter(getter(AccessPolicySummary::policyVersion))
            .setter(setter(Builder::policyVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyVersion").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(AccessPolicySummary::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_DATE_FIELD,
            DESCRIPTION_FIELD, LAST_MODIFIED_DATE_FIELD, NAME_FIELD, POLICY_VERSION_FIELD, TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long createdDate;

    private final String description;

    private final Long lastModifiedDate;

    private final String name;

    private final String policyVersion;

    private final String type;

    private AccessPolicySummary(BuilderImpl builder) {
        this.createdDate = builder.createdDate;
        this.description = builder.description;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.name = builder.name;
        this.policyVersion = builder.policyVersion;
        this.type = builder.type;
    }

    /**
     * <p>
     * The Epoch time when the access policy was created.
     * </p>
     * 
     * @return The Epoch time when the access policy was created.
     */
    public final Long createdDate() {
        return createdDate;
    }

    /**
     * <p>
     * The description of the access policy.
     * </p>
     * 
     * @return The description of the access policy.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The date and time when the collection was last modified.
     * </p>
     * 
     * @return The date and time when the collection was last modified.
     */
    public final Long lastModifiedDate() {
        return lastModifiedDate;
    }

    /**
     * <p>
     * The name of the access policy.
     * </p>
     * 
     * @return The name of the access policy.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The version of the policy.
     * </p>
     * 
     * @return The version of the policy.
     */
    public final String policyVersion() {
        return policyVersion;
    }

    /**
     * <p>
     * The type of access policy. Currently the only available type is <code>data</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link AccessPolicyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of access policy. Currently the only available type is <code>data</code>.
     * @see AccessPolicyType
     */
    public final AccessPolicyType type() {
        return AccessPolicyType.fromValue(type);
    }

    /**
     * <p>
     * The type of access policy. Currently the only available type is <code>data</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link AccessPolicyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of access policy. Currently the only available type is <code>data</code>.
     * @see AccessPolicyType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(policyVersion());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccessPolicySummary)) {
            return false;
        }
        AccessPolicySummary other = (AccessPolicySummary) obj;
        return Objects.equals(createdDate(), other.createdDate()) && Objects.equals(description(), other.description())
                && Objects.equals(lastModifiedDate(), other.lastModifiedDate()) && Objects.equals(name(), other.name())
                && Objects.equals(policyVersion(), other.policyVersion()) && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AccessPolicySummary").add("CreatedDate", createdDate()).add("Description", description())
                .add("LastModifiedDate", lastModifiedDate()).add("Name", name()).add("PolicyVersion", policyVersion())
                .add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "createdDate":
            return Optional.ofNullable(clazz.cast(createdDate()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "lastModifiedDate":
            return Optional.ofNullable(clazz.cast(lastModifiedDate()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "policyVersion":
            return Optional.ofNullable(clazz.cast(policyVersion()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AccessPolicySummary, T> g) {
        return obj -> g.apply((AccessPolicySummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccessPolicySummary> {
        /**
         * <p>
         * The Epoch time when the access policy was created.
         * </p>
         * 
         * @param createdDate
         *        The Epoch time when the access policy was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDate(Long createdDate);

        /**
         * <p>
         * The description of the access policy.
         * </p>
         * 
         * @param description
         *        The description of the access policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The date and time when the collection was last modified.
         * </p>
         * 
         * @param lastModifiedDate
         *        The date and time when the collection was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(Long lastModifiedDate);

        /**
         * <p>
         * The name of the access policy.
         * </p>
         * 
         * @param name
         *        The name of the access policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The version of the policy.
         * </p>
         * 
         * @param policyVersion
         *        The version of the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyVersion(String policyVersion);

        /**
         * <p>
         * The type of access policy. Currently the only available type is <code>data</code>.
         * </p>
         * 
         * @param type
         *        The type of access policy. Currently the only available type is <code>data</code>.
         * @see AccessPolicyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccessPolicyType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of access policy. Currently the only available type is <code>data</code>.
         * </p>
         * 
         * @param type
         *        The type of access policy. Currently the only available type is <code>data</code>.
         * @see AccessPolicyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccessPolicyType
         */
        Builder type(AccessPolicyType type);
    }

    static final class BuilderImpl implements Builder {
        private Long createdDate;

        private String description;

        private Long lastModifiedDate;

        private String name;

        private String policyVersion;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(AccessPolicySummary model) {
            createdDate(model.createdDate);
            description(model.description);
            lastModifiedDate(model.lastModifiedDate);
            name(model.name);
            policyVersion(model.policyVersion);
            type(model.type);
        }

        public final Long getCreatedDate() {
            return createdDate;
        }

        public final void setCreatedDate(Long createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public final Builder createdDate(Long createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Long getLastModifiedDate() {
            return lastModifiedDate;
        }

        public final void setLastModifiedDate(Long lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Long lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getPolicyVersion() {
            return policyVersion;
        }

        public final void setPolicyVersion(String policyVersion) {
            this.policyVersion = policyVersion;
        }

        @Override
        public final Builder policyVersion(String policyVersion) {
            this.policyVersion = policyVersion;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(AccessPolicyType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public AccessPolicySummary build() {
            return new AccessPolicySummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
