/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearchserverless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateSecurityPolicyResponse extends OpenSearchServerlessResponse implements
        ToCopyableBuilder<UpdateSecurityPolicyResponse.Builder, UpdateSecurityPolicyResponse> {
    private static final SdkField<SecurityPolicyDetail> SECURITY_POLICY_DETAIL_FIELD = SdkField
            .<SecurityPolicyDetail> builder(MarshallingType.SDK_POJO).memberName("securityPolicyDetail")
            .getter(getter(UpdateSecurityPolicyResponse::securityPolicyDetail)).setter(setter(Builder::securityPolicyDetail))
            .constructor(SecurityPolicyDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityPolicyDetail").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECURITY_POLICY_DETAIL_FIELD));

    private final SecurityPolicyDetail securityPolicyDetail;

    private UpdateSecurityPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.securityPolicyDetail = builder.securityPolicyDetail;
    }

    /**
     * <p>
     * Details about the updated security policy.
     * </p>
     * 
     * @return Details about the updated security policy.
     */
    public final SecurityPolicyDetail securityPolicyDetail() {
        return securityPolicyDetail;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(securityPolicyDetail());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSecurityPolicyResponse)) {
            return false;
        }
        UpdateSecurityPolicyResponse other = (UpdateSecurityPolicyResponse) obj;
        return Objects.equals(securityPolicyDetail(), other.securityPolicyDetail());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateSecurityPolicyResponse").add("SecurityPolicyDetail", securityPolicyDetail()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "securityPolicyDetail":
            return Optional.ofNullable(clazz.cast(securityPolicyDetail()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateSecurityPolicyResponse, T> g) {
        return obj -> g.apply((UpdateSecurityPolicyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpenSearchServerlessResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateSecurityPolicyResponse> {
        /**
         * <p>
         * Details about the updated security policy.
         * </p>
         * 
         * @param securityPolicyDetail
         *        Details about the updated security policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityPolicyDetail(SecurityPolicyDetail securityPolicyDetail);

        /**
         * <p>
         * Details about the updated security policy.
         * </p>
         * This is a convenience method that creates an instance of the {@link SecurityPolicyDetail.Builder} avoiding
         * the need to create one manually via {@link SecurityPolicyDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SecurityPolicyDetail.Builder#build()} is called immediately and
         * its result is passed to {@link #securityPolicyDetail(SecurityPolicyDetail)}.
         * 
         * @param securityPolicyDetail
         *        a consumer that will call methods on {@link SecurityPolicyDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #securityPolicyDetail(SecurityPolicyDetail)
         */
        default Builder securityPolicyDetail(Consumer<SecurityPolicyDetail.Builder> securityPolicyDetail) {
            return securityPolicyDetail(SecurityPolicyDetail.builder().applyMutation(securityPolicyDetail).build());
        }
    }

    static final class BuilderImpl extends OpenSearchServerlessResponse.BuilderImpl implements Builder {
        private SecurityPolicyDetail securityPolicyDetail;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSecurityPolicyResponse model) {
            super(model);
            securityPolicyDetail(model.securityPolicyDetail);
        }

        public final SecurityPolicyDetail.Builder getSecurityPolicyDetail() {
            return securityPolicyDetail != null ? securityPolicyDetail.toBuilder() : null;
        }

        public final void setSecurityPolicyDetail(SecurityPolicyDetail.BuilderImpl securityPolicyDetail) {
            this.securityPolicyDetail = securityPolicyDetail != null ? securityPolicyDetail.build() : null;
        }

        @Override
        public final Builder securityPolicyDetail(SecurityPolicyDetail securityPolicyDetail) {
            this.securityPolicyDetail = securityPolicyDetail;
            return this;
        }

        @Override
        public UpdateSecurityPolicyResponse build() {
            return new UpdateSecurityPolicyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
