/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearchserverless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteCollectionResponse extends OpenSearchServerlessResponse implements
        ToCopyableBuilder<DeleteCollectionResponse.Builder, DeleteCollectionResponse> {
    private static final SdkField<DeleteCollectionDetail> DELETE_COLLECTION_DETAIL_FIELD = SdkField
            .<DeleteCollectionDetail> builder(MarshallingType.SDK_POJO).memberName("deleteCollectionDetail")
            .getter(getter(DeleteCollectionResponse::deleteCollectionDetail)).setter(setter(Builder::deleteCollectionDetail))
            .constructor(DeleteCollectionDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deleteCollectionDetail").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(DELETE_COLLECTION_DETAIL_FIELD));

    private final DeleteCollectionDetail deleteCollectionDetail;

    private DeleteCollectionResponse(BuilderImpl builder) {
        super(builder);
        this.deleteCollectionDetail = builder.deleteCollectionDetail;
    }

    /**
     * <p>
     * Details of the deleted collection.
     * </p>
     * 
     * @return Details of the deleted collection.
     */
    public final DeleteCollectionDetail deleteCollectionDetail() {
        return deleteCollectionDetail;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(deleteCollectionDetail());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteCollectionResponse)) {
            return false;
        }
        DeleteCollectionResponse other = (DeleteCollectionResponse) obj;
        return Objects.equals(deleteCollectionDetail(), other.deleteCollectionDetail());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteCollectionResponse").add("DeleteCollectionDetail", deleteCollectionDetail()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "deleteCollectionDetail":
            return Optional.ofNullable(clazz.cast(deleteCollectionDetail()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteCollectionResponse, T> g) {
        return obj -> g.apply((DeleteCollectionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpenSearchServerlessResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteCollectionResponse> {
        /**
         * <p>
         * Details of the deleted collection.
         * </p>
         * 
         * @param deleteCollectionDetail
         *        Details of the deleted collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteCollectionDetail(DeleteCollectionDetail deleteCollectionDetail);

        /**
         * <p>
         * Details of the deleted collection.
         * </p>
         * This is a convenience method that creates an instance of the {@link DeleteCollectionDetail.Builder} avoiding
         * the need to create one manually via {@link DeleteCollectionDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DeleteCollectionDetail.Builder#build()} is called immediately and
         * its result is passed to {@link #deleteCollectionDetail(DeleteCollectionDetail)}.
         * 
         * @param deleteCollectionDetail
         *        a consumer that will call methods on {@link DeleteCollectionDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deleteCollectionDetail(DeleteCollectionDetail)
         */
        default Builder deleteCollectionDetail(Consumer<DeleteCollectionDetail.Builder> deleteCollectionDetail) {
            return deleteCollectionDetail(DeleteCollectionDetail.builder().applyMutation(deleteCollectionDetail).build());
        }
    }

    static final class BuilderImpl extends OpenSearchServerlessResponse.BuilderImpl implements Builder {
        private DeleteCollectionDetail deleteCollectionDetail;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteCollectionResponse model) {
            super(model);
            deleteCollectionDetail(model.deleteCollectionDetail);
        }

        public final DeleteCollectionDetail.Builder getDeleteCollectionDetail() {
            return deleteCollectionDetail != null ? deleteCollectionDetail.toBuilder() : null;
        }

        public final void setDeleteCollectionDetail(DeleteCollectionDetail.BuilderImpl deleteCollectionDetail) {
            this.deleteCollectionDetail = deleteCollectionDetail != null ? deleteCollectionDetail.build() : null;
        }

        @Override
        public final Builder deleteCollectionDetail(DeleteCollectionDetail deleteCollectionDetail) {
            this.deleteCollectionDetail = deleteCollectionDetail;
            return this;
        }

        @Override
        public DeleteCollectionResponse build() {
            return new DeleteCollectionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
